/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.OnlyTest;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vfile.FileIO;
import com.ovopark.kernel.shared.vfile.LemonEngine;
import com.ovopark.kernel.shared.vfile.SimpleShardFileIO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLemonEngine
implements LemonEngine {
    private static final Logger log = LoggerFactory.getLogger(DefaultLemonEngine.class);
    public static final int LOCK_TIMEOUT_SEC = Math.max(Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.lockTimeoutSec", Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.lockTimeoutSec", 30)), 30);
    public static final int SHARD_COUNT = 3;
    public static final int CB = 128;
    final SimpleShardFileIO shardFileIO;
    final Util.GroupLock groupLock = Util.groupLock(DefaultLemonEngine.class.getName());

    public DefaultLemonEngine(String basePath) {
        this(basePath, null);
    }

    public DefaultLemonEngine(String basePath, Conf conf) {
        if (conf == null) {
            conf = new Conf();
            conf.setMemoryBufferSizeMb(384L);
            conf.setWalBufferSizeMb(10);
            conf.setWalDiskSizeMb(100L);
            conf.setSparseIfMinCount(10000000);
            conf.setKeepMaxFileCount(1);
            conf.setForceMergeIfMaxSkipCount(1);
        }
        SimpleShardFileIO.Conf shardConf = new SimpleShardFileIO.Conf();
        shardConf.setShardCount(3);
        long mbs = this.memoryBufferSizeMbIfMay(conf.getMemoryBufferSizeMb());
        log.info("memory cache per shard: " + mbs + " mb, all memory cache: " + mbs * 3L + ", user hint: " + conf.getMemoryBufferSizeMb());
        shardConf.setMemoryBufferSizeMb(mbs);
        shardConf.setAutoIncrement(false);
        shardConf.setSparseIfMinCount(conf.getSparseIfMinCount());
        shardConf.setForceMergeIfMaxSkipCount(conf.getForceMergeIfMaxSkipCount());
        shardConf.setKeepMaxFileCount(conf.getKeepMaxFileCount());
        shardConf.setWalDiskSizeMb(conf.getWalDiskSizeMb());
        shardConf.setWalBufferSizeMb(conf.getWalBufferSizeMb());
        this.shardFileIO = new SimpleShardFileIO(basePath, shardConf);
    }

    private long memoryBufferSizeMbIfMay(long memoryBufferSizeMb) {
        return (long)(Math.ceil((double)memoryBufferSizeMb / 3.0 / 128.0) * 128.0);
    }

    @Override
    public LemonEngine.PutResult put(String key, Map<String, Object> data) {
        return this.put(key, data, LemonEngine.Options.fromRoute(key));
    }

    @Override
    public LemonEngine.PutResult put(final String key, final Map<String, Object> data, final LemonEngine.Options options) {
        return this.groupLock.lock((Comparable<?>)((Object)key), new Callable<LemonEngine.PutResult>(){

            @Override
            public LemonEngine.PutResult call() throws Exception {
                return DefaultLemonEngine.this.put0(key, data, options, false);
            }
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public LemonEngine.PutResult append(String key, Map<String, Object> data) {
        return this.append(key, data, LemonEngine.Options.fromRoute(key));
    }

    private PutResultImpl put0(String key, Map<String, Object> data, LemonEngine.Options options, boolean append) {
        FileIO.ShardFileIO.Options shardOptions = FileIO.ShardFileIO.Options.fromRoute(options.getRoute());
        FileIO.FileGetResult fileGetResult = append ? this.shardFileIO.get0(key, shardOptions, true) : this.shardFileIO.get0(key, shardOptions, false);
        Map finalData = data;
        if (append && fileGetResult != null) {
            Map preData;
            finalData = preData = JSONAccessor.impl().read(fileGetResult.data(), Map.class);
            finalData.putAll(data);
        }
        FileIO.FilePutResult putResult = this.shardFileIO.put(key, null, JSONAccessor.impl().formatAsBytes(finalData), shardOptions);
        return new PutResultImpl(key, putResult.vcc(), fileGetResult != null && putResult.vcc() > fileGetResult.vcc(), fileGetResult == null);
    }

    @Override
    public LemonEngine.PutResult append(final String key, final Map<String, Object> data, final LemonEngine.Options options) {
        return this.groupLock.lock((Comparable<?>)((Object)key), new Callable<LemonEngine.PutResult>(){

            @Override
            public LemonEngine.PutResult call() throws Exception {
                return DefaultLemonEngine.this.put0(key, data, options, true);
            }
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public LemonEngine.GetResult get(String key) {
        return this.get(key, LemonEngine.Options.fromRoute(key));
    }

    @Override
    public LemonEngine.GetResult get(String key, LemonEngine.Options options) {
        FileIO.ShardFileIO.Options shardOptions = FileIO.ShardFileIO.Options.fromRoute(options.getRoute());
        FileIO.FileGetResult fileGetResult = this.shardFileIO.get(key, shardOptions);
        if (fileGetResult == null) {
            return new GetResultImpl(false, key, -1L, null);
        }
        return new GetResultImpl(true, key, fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()));
    }

    @Override
    public boolean exists(String key) {
        return this.exists(key, LemonEngine.Options.fromRoute(key));
    }

    @Override
    public boolean exists(String key, LemonEngine.Options options) {
        FileIO.ShardFileIO.Options shardOptions = FileIO.ShardFileIO.Options.fromRoute(options.getRoute());
        FileIO.FileGetResult fileGetResult = this.shardFileIO.get0(key, shardOptions, false);
        return fileGetResult != null;
    }

    @Override
    public LemonEngine.DeleteResult delete(String key) {
        return this.delete(key, LemonEngine.Options.fromRoute(key));
    }

    @Override
    public LemonEngine.DeleteResult delete(final String key, final LemonEngine.Options options) {
        return this.groupLock.lock((Comparable<?>)((Object)key), new Callable<LemonEngine.DeleteResult>(){

            @Override
            public LemonEngine.DeleteResult call() throws Exception {
                FileIO.ShardFileIO.Options shardOptions = FileIO.ShardFileIO.Options.fromRoute(options.getRoute());
                FileIO.FileGetResult fileGetResult = DefaultLemonEngine.this.shardFileIO.get(key, shardOptions);
                FileIO.FileDeleteResult fileDeleteResult = DefaultLemonEngine.this.shardFileIO.delete(key, shardOptions);
                if (fileGetResult == null) {
                    return new DeleteResultImpl(false, fileDeleteResult.vcc() > 0L, key, fileDeleteResult.vcc());
                }
                return new DeleteResultImpl(true, fileDeleteResult.vcc() > 0L, key, fileDeleteResult.vcc());
            }
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public LemonEngine.CompareAndSetResult compareAndSet(String key, LemonEngine.CompareAndSet compareAndSet) {
        return this.compareAndSet(key, compareAndSet, LemonEngine.Options.fromRoute(key));
    }

    @Override
    public LemonEngine.CompareAndSetResult compareAndSet(final String key, final LemonEngine.CompareAndSet compareAndSet, final LemonEngine.Options options) {
        return this.groupLock.lock((Comparable<?>)((Object)key), new Callable<LemonEngine.CompareAndSetResult>(){

            @Override
            public LemonEngine.CompareAndSetResult call() throws Exception {
                FileIO.ShardFileIO.Options shardOptions = FileIO.ShardFileIO.Options.fromRoute(options.getRoute());
                FileIO.CompareAndSetResult compareAndSetResult = DefaultLemonEngine.this.shardFileIO.compareAndSet(key, new FileIO.CompareAndSet(){

                    @Override
                    public FileIO.Setter test(FileIO.FileGetResult fileGetResult, FileIO.Operator operator) {
                        GetResultImpl getResult = new GetResultImpl(true, key, fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()));
                        LemonEngine.Setter setter = compareAndSet.test(getResult, new OperatorImpl());
                        if (setter instanceof NoopImpl) {
                            return operator.noop();
                        }
                        if (setter instanceof LemonEngine.Delete) {
                            return operator.delete();
                        }
                        if (setter instanceof LemonEngine.Put) {
                            Map<String, Object> data = ((PutImpl)setter).getData();
                            Map<String, Object> preData = getResult.value();
                            preData.putAll(data);
                            return operator.update().data(JSONAccessor.impl().formatAsBytes(preData));
                        }
                        throw DBOpeException.from("setter is not supported");
                    }
                }, shardOptions);
                if (compareAndSetResult.noop()) {
                    return new CompareAndSetResultImpl(null, null);
                }
                FileIO.FilePutResult filePutResult = compareAndSetResult.updated();
                if (filePutResult != null) {
                    return new CompareAndSetResultImpl(new PutResultImpl(key, filePutResult.vcc(), true, false), null);
                }
                FileIO.FileDeleteResult fileDeleteResult = compareAndSetResult.deleted();
                if (fileDeleteResult != null) {
                    return new CompareAndSetResultImpl(null, new DeleteResultImpl(true, true, key, fileDeleteResult.vcc()));
                }
                throw DBOpeException.from("compareAndSet error, never reach code???");
            }
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public void search(LemonEngine.SearchListener searchListener) {
        this.search(searchListener, LemonEngine.Options.fromRoute(null));
    }

    @Override
    public void search(LemonEngine.SearchListener searchListener, LemonEngine.Options options) {
        SearchContextImpl sc = new SearchContextImpl();
        this.shardFileIO.search((FileIO.FileGetResult fileGetResult, FileIO.SearchContext searchContext) -> {
            GetResultImpl getResult = new GetResultImpl(true, fileGetResult.key(), fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()));
            searchListener.onRow(getResult, sc);
            if (sc.cancelled) {
                searchContext.cancel();
            }
        }, FileIO.ShardFileIO.Options.fromRoute(options.getRoute()));
    }

    @Override
    public List<LemonEngine.GetResult> searchAfter(String key, boolean inclusive, int n) {
        return this.searchAfter(key, inclusive, n, (String k) -> true);
    }

    @Override
    public List<LemonEngine.GetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate) {
        return this.searchAfter(key, inclusive, n, predicate, LemonEngine.Options.fromRoute(null));
    }

    @Override
    public List<LemonEngine.GetResult> searchAfter(String key, boolean inclusive, int n, LemonEngine.Options options) {
        return this.searchAfter(key, inclusive, n, k -> true, options);
    }

    @Override
    public List<LemonEngine.GetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate, LemonEngine.Options options) {
        List<FileIO.FileGetResult> resultList = this.shardFileIO.searchAfter(key, inclusive, n, predicate, FileIO.ShardFileIO.Options.fromRoute(options.getRoute()));
        return resultList.stream().map(fileGetResult -> new GetResultImpl(true, fileGetResult.key(), fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()))).collect(Collectors.toList());
    }

    @Override
    public List<LemonEngine.GetResult> searchBefore(String key, boolean inclusive, int n) {
        return this.searchBefore(key, inclusive, n, (String k) -> true);
    }

    @Override
    public List<LemonEngine.GetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate) {
        return this.searchBefore(key, inclusive, n, predicate, LemonEngine.Options.fromRoute(null));
    }

    @Override
    public List<LemonEngine.GetResult> searchBefore(String key, boolean inclusive, int n, LemonEngine.Options options) {
        return this.searchBefore(key, inclusive, n, k -> true, options);
    }

    @Override
    public List<LemonEngine.GetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate, LemonEngine.Options options) {
        List<FileIO.FileGetResult> resultList = this.shardFileIO.searchBefore(key, inclusive, n, predicate, FileIO.ShardFileIO.Options.fromRoute(options.getRoute()));
        return resultList.stream().map(fileGetResult -> new GetResultImpl(true, fileGetResult.key(), fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()))).collect(Collectors.toList());
    }

    @Override
    public List<LemonEngine.GetResult> top(int n) {
        return this.top(n, LemonEngine.Options.fromRoute(null));
    }

    @Override
    public List<LemonEngine.GetResult> tail(int n) {
        return this.tail(n, LemonEngine.Options.fromRoute(null));
    }

    @Override
    public List<LemonEngine.GetResult> top(int n, LemonEngine.Options options) {
        List<FileIO.FileGetResult> resultList = this.shardFileIO.top(n, FileIO.ShardFileIO.Options.fromRoute(options.getRoute()));
        return resultList.stream().map(fileGetResult -> new GetResultImpl(true, fileGetResult.key(), fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()))).collect(Collectors.toList());
    }

    @Override
    public List<LemonEngine.GetResult> tail(int n, LemonEngine.Options options) {
        List<FileIO.FileGetResult> resultList = this.shardFileIO.tail(n, FileIO.ShardFileIO.Options.fromRoute(options.getRoute()));
        return resultList.stream().map(fileGetResult -> new GetResultImpl(true, fileGetResult.key(), fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()))).collect(Collectors.toList());
    }

    @Override
    public int count() {
        return this.shardFileIO.count();
    }

    @Override
    public void close() throws Exception {
        this.shardFileIO.close();
    }

    @OnlyTest
    @OnlyPrivate
    public void merge() {
        this.shardFileIO.merge();
    }

    @Override
    public void pretty(OutputStreamWriter outputStreamWriter) {
        this.shardFileIO.diskFileStat().pretty(outputStreamWriter);
    }

    @Override
    public void dump(LemonEngine.SearchListener searchListener) {
        LemonEngine.DumpConf dumpConf = new LemonEngine.DumpConf();
        dumpConf.setSnapshotCreatedWaitTimeSec(Integer.MAX_VALUE);
        this.dump(searchListener, dumpConf);
    }

    @Override
    public void dump(LemonEngine.SearchListener searchListener, LemonEngine.DumpConf dumpConf) {
        this.dump0(dumpConf, searchListener, null);
    }

    private void dump0(LemonEngine.DumpConf dumpConf, LemonEngine.SearchListener searchListener, DumpStatListener dumpStatListener) {
        block15: {
            SimpleShardFileIO snapshot = null;
            try {
                snapshot = this.shardFileIO.snapshot(dumpConf.snapshotCreatedWaitTimeSec);
                SearchContextImpl sp = new SearchContextImpl();
                snapshot.dump((FileIO.FileGetResult fileGetResult, FileIO.SearchContext searchContext) -> {
                    GetResultImpl getResult = new GetResultImpl(true, fileGetResult.key(), fileGetResult.vcc(), JSONAccessor.impl().read(fileGetResult.data()));
                    searchListener.onRow(getResult, sp);
                    if (sp.isCancelled()) {
                        searchContext.cancel();
                    }
                });
                if (dumpStatListener == null) break block15;
                dumpStatListener.onCount(snapshot.count());
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
                    snapshot.diskFileStat().pretty(outputStreamWriter);
                    outputStreamWriter.flush();
                    dumpStatListener.onDiskFileStat(Util.utf8(byteArrayOutputStream.toByteArray()));
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                throw Util.convert2RuntimeException(e);
            }
            finally {
                if (snapshot != null) {
                    try {
                        snapshot.releaseSnapshot();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        throw Util.convert2RuntimeException(e);
                    }
                }
            }
        }
    }

    @OnlyTest
    @OnlyPrivate
    void dump(LemonEngine.SearchListener searchListener, DumpStatListener dumpStatListener, LemonEngine.DumpConf dumpConf) {
        this.dump0(dumpConf, searchListener, dumpStatListener);
    }

    static class PutResultImpl
    implements LemonEngine.PutResult {
        final String key;
        final long vcc;
        final boolean updated;
        final boolean created;

        public PutResultImpl(String key, long vcc, boolean updated, boolean created) {
            this.key = key;
            this.vcc = vcc;
            this.updated = updated;
            this.created = created;
        }

        @Override
        public boolean updated() {
            return this.updated;
        }

        @Override
        public boolean created() {
            return this.created;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public long vcc() {
            return this.vcc;
        }
    }

    public static class Conf
    implements Model {
        private int walBufferSizeMb = 10;
        long walDiskSizeMb = 10L;
        long memoryBufferSizeMb;
        private int sparseIfMinCount = 1000000;
        private int forceMergeIfMaxSkipCount = 1;
        private int keepMaxFileCount = 1;

        public int getWalBufferSizeMb() {
            return this.walBufferSizeMb;
        }

        public long getWalDiskSizeMb() {
            return this.walDiskSizeMb;
        }

        public long getMemoryBufferSizeMb() {
            return this.memoryBufferSizeMb;
        }

        public int getSparseIfMinCount() {
            return this.sparseIfMinCount;
        }

        public int getForceMergeIfMaxSkipCount() {
            return this.forceMergeIfMaxSkipCount;
        }

        public int getKeepMaxFileCount() {
            return this.keepMaxFileCount;
        }

        public void setWalBufferSizeMb(int walBufferSizeMb) {
            this.walBufferSizeMb = walBufferSizeMb;
        }

        public void setWalDiskSizeMb(long walDiskSizeMb) {
            this.walDiskSizeMb = walDiskSizeMb;
        }

        public void setMemoryBufferSizeMb(long memoryBufferSizeMb) {
            this.memoryBufferSizeMb = memoryBufferSizeMb;
        }

        public void setSparseIfMinCount(int sparseIfMinCount) {
            this.sparseIfMinCount = sparseIfMinCount;
        }

        public void setForceMergeIfMaxSkipCount(int forceMergeIfMaxSkipCount) {
            this.forceMergeIfMaxSkipCount = forceMergeIfMaxSkipCount;
        }

        public void setKeepMaxFileCount(int keepMaxFileCount) {
            this.keepMaxFileCount = keepMaxFileCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conf)) {
                return false;
            }
            Conf other = (Conf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWalBufferSizeMb() != other.getWalBufferSizeMb()) {
                return false;
            }
            if (this.getWalDiskSizeMb() != other.getWalDiskSizeMb()) {
                return false;
            }
            if (this.getMemoryBufferSizeMb() != other.getMemoryBufferSizeMb()) {
                return false;
            }
            if (this.getSparseIfMinCount() != other.getSparseIfMinCount()) {
                return false;
            }
            if (this.getForceMergeIfMaxSkipCount() != other.getForceMergeIfMaxSkipCount()) {
                return false;
            }
            return this.getKeepMaxFileCount() == other.getKeepMaxFileCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWalBufferSizeMb();
            long $walDiskSizeMb = this.getWalDiskSizeMb();
            result = result * 59 + (int)($walDiskSizeMb >>> 32 ^ $walDiskSizeMb);
            long $memoryBufferSizeMb = this.getMemoryBufferSizeMb();
            result = result * 59 + (int)($memoryBufferSizeMb >>> 32 ^ $memoryBufferSizeMb);
            result = result * 59 + this.getSparseIfMinCount();
            result = result * 59 + this.getForceMergeIfMaxSkipCount();
            result = result * 59 + this.getKeepMaxFileCount();
            return result;
        }

        public String toString() {
            return "DefaultLemonEngine.Conf(walBufferSizeMb=" + this.getWalBufferSizeMb() + ", walDiskSizeMb=" + this.getWalDiskSizeMb() + ", memoryBufferSizeMb=" + this.getMemoryBufferSizeMb() + ", sparseIfMinCount=" + this.getSparseIfMinCount() + ", forceMergeIfMaxSkipCount=" + this.getForceMergeIfMaxSkipCount() + ", keepMaxFileCount=" + this.getKeepMaxFileCount() + ")";
        }
    }

    static class GetResultImpl
    implements LemonEngine.GetResult {
        final boolean exists;
        final String key;
        final long vcc;
        final Map<String, Object> value;
        static final Map<String, Util.JSONMapAccessor.MapPath> mapPathMap = new ConcurrentHashMap<String, Util.JSONMapAccessor.MapPath>();
        static final Function<String, Util.JSONMapAccessor.MapPath> pathFunction = s -> {
            if (mapPathMap.size() > 100000) {
                mapPathMap.clear();
            }
            return mapPathMap.computeIfAbsent((String)s, Util.JSONMapAccessor::compile);
        };

        public GetResultImpl(boolean exists, String key, long vcc, Map<String, Object> value) {
            this.exists = exists;
            this.key = key;
            this.vcc = vcc;
            this.value = value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Map<String, Object> value() {
            return this.value;
        }

        @Override
        public long vcc() {
            return this.vcc;
        }

        @Override
        public <T> T get(String path, Class<T> clazz) {
            if (!this.exists()) {
                return null;
            }
            Util.JSONMapAccessor.GetResult getResult = Util.jsonGet(this.value(), path, pathFunction);
            if (getResult.exists()) {
                Object v = getResult.value();
                if (clazz == String.class) {
                    return clazz.cast(Util.convert2String(v));
                }
                if (clazz == Long.class) {
                    if (v instanceof Integer) {
                        return clazz.cast(Util.convert2Long((Integer)v, null));
                    }
                    return clazz.cast(v);
                }
                if (clazz == Short.class) {
                    if (v instanceof Integer && (Integer)v <= Short.MAX_VALUE && (Integer)v >= Short.MIN_VALUE) {
                        return clazz.cast(Util.convert2Short((Integer)v, null));
                    }
                    return clazz.cast(v);
                }
                if (clazz == Byte.class) {
                    if (v instanceof Integer && (Integer)v <= 127 && (Integer)v >= -128) {
                        return clazz.cast(Util.convert2Byte((Integer)v, null));
                    }
                    return clazz.cast(v);
                }
                if (clazz == Float.class) {
                    if (v instanceof Integer) {
                        return clazz.cast(Util.convert2Float((Integer)v, null));
                    }
                    if (v instanceof Long) {
                        return clazz.cast(Util.convert2Float((Long)v, null));
                    }
                    if (v instanceof Double && (Double)v <= 3.4028234663852886E38 && (Double)v >= (double)1.4E-45f) {
                        return clazz.cast(Util.convert2Float((Double)v, null));
                    }
                    return clazz.cast(v);
                }
                if (clazz == Double.class) {
                    if (v instanceof Integer) {
                        return clazz.cast(Util.convert2Double((Integer)v, null));
                    }
                    if (v instanceof Long) {
                        return clazz.cast(Util.convert2Double((Long)v, null));
                    }
                    return clazz.cast(v);
                }
                return clazz.cast(v);
            }
            return null;
        }
    }

    static class SearchContextImpl
    implements LemonEngine.SearchContext {
        private volatile boolean cancelled;

        SearchContextImpl() {
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    @OnlyTest
    @OnlyPrivate
    public static interface DumpStatListener {
        public void onCount(int var1);

        public void onDiskFileStat(String var1);
    }

    static class MgrImpl
    implements LemonEngine.Mgr {
        private final Map<String, LemonEngine> engineMap = new ConcurrentHashMap<String, LemonEngine>();
        static final LemonEngine.Mgr mgr = new MgrImpl();

        MgrImpl() {
        }

        @Override
        public void add(String engine, LemonEngine lemonEngine) {
            this.engineMap.put(engine, lemonEngine);
        }

        @Override
        public void remove(String engine) {
            this.engineMap.remove(engine);
        }

        @Override
        public LemonEngine get(String engine) {
            return this.engineMap.get(engine);
        }

        @Override
        public List<String> list() {
            return new ArrayList<String>(this.engineMap.keySet());
        }
    }

    static class CompareAndSetResultImpl
    implements LemonEngine.CompareAndSetResult {
        final LemonEngine.PutResult putResult;
        final LemonEngine.DeleteResult deleteResult;

        public CompareAndSetResultImpl(LemonEngine.PutResult putResult, LemonEngine.DeleteResult deleteResult) {
            this.putResult = putResult;
            this.deleteResult = deleteResult;
        }

        @Override
        public LemonEngine.PutResult updated() {
            return this.putResult;
        }

        @Override
        public LemonEngine.DeleteResult deleted() {
            return this.deleteResult;
        }

        @Override
        public boolean noop() {
            return this.deleteResult == null && this.putResult == null;
        }
    }

    static class PutImpl
    implements LemonEngine.Put {
        private Map<String, Object> data;

        @Override
        public LemonEngine.Put data(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PutImpl)) {
                return false;
            }
            PutImpl other = (PutImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$data = this.getData();
            Map<String, Object> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PutImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultLemonEngine.PutImpl(data=" + this.getData() + ")";
        }
    }

    static class DeleteImpl
    implements LemonEngine.Delete {
        DeleteImpl() {
        }
    }

    static class NoopImpl
    implements LemonEngine.Setter {
        static final NoopImpl NOOP = new NoopImpl();

        NoopImpl() {
        }
    }

    static class OperatorImpl
    implements LemonEngine.Operator {
        OperatorImpl() {
        }

        @Override
        public LemonEngine.Setter noop() {
            return NoopImpl.NOOP;
        }

        @Override
        public LemonEngine.Put update() {
            return new PutImpl();
        }

        @Override
        public LemonEngine.Delete delete() {
            return new DeleteImpl();
        }
    }

    static class DeleteResultImpl
    implements LemonEngine.DeleteResult {
        final boolean exists;
        final boolean deleted;
        final String key;
        final long vcc;

        public DeleteResultImpl(boolean exists, boolean deleted, String key, long vcc) {
            this.exists = exists;
            this.deleted = deleted;
            this.key = key;
            this.vcc = vcc;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public boolean deleted() {
            return this.deleted;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public long vcc() {
            return this.vcc;
        }
    }
}

