/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.kernel.shared.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JSONAccessor {
    public static JSONAccessor impl() {
        return JSONAccessorHolder.jsonAccessor;
    }

    public String format(Object var1);

    default public byte[] formatAsBytes(Object object) {
        return Util.utf8(this.format(object));
    }

    public <T> T read(String var1, Class<T> var2);

    public <T> T read(String var1, TypeReference<T> var2);

    public Map read(String var1);

    default public Map read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    default public Map read(byte[] data, int off, int len) {
        return this.read(Util.utf8(data, off, len));
    }

    default public <T> T read(byte[] data, TypeReference<T> typeReference) {
        return this.read(data, 0, data.length, typeReference);
    }

    default public <T> T read(byte[] data, int off, int len, TypeReference<T> typeReference) {
        return this.read(Util.utf8(data, off, len), typeReference);
    }

    default public <T> T read(byte[] data, Class<T> type) {
        return this.read(data, 0, data.length, type);
    }

    default public <T> T read(byte[] data, int off, int len, Class<T> type) {
        return this.read(Util.utf8(data, off, len), type);
    }

    public static class JSONAccessorHolder {
        private static final Logger log = LoggerFactory.getLogger(JSONAccessorHolder.class);
        static final JSONAccessor jsonAccessor = JSONAccessorHolder.getJson();

        private JSONAccessorHolder() {
        }

        private static JSONAccessor getJson() {
            JSONAccessor json = null;
            ServiceLoader<JSONAccessorProvider> serviceLoader = ServiceLoader.load(JSONAccessorProvider.class);
            for (JSONAccessorProvider sl : serviceLoader) {
                json = (JSONAccessor)sl.get();
            }
            log.info("use json implement: " + json.getClass().getName());
            return json;
        }
    }

    public static abstract class TypeReference<T>
    implements Comparable<TypeReference<T>> {
        protected final Type _type;

        protected TypeReference() {
            Type superClass = this.getClass().getGenericSuperclass();
            if (superClass instanceof Class) {
                throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
            }
            this._type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }

        public Type getType() {
            return this._type;
        }

        @Override
        public int compareTo(TypeReference<T> o) {
            return 0;
        }
    }

    public static interface JSONAccessorProvider
    extends ServiceProvider<JSONAccessor> {
    }
}

