/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.kernel.shared.stream.Subscription;
import com.ovopark.kernel.shared.vfile.AppendLog;
import com.ovopark.kernel.shared.vfile.FileIO;
import com.ovopark.kernel.shared.vfile.LayeredFileIO;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleFileIO
implements FileIO,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(SimpleFileIO.class);
    static final Map<String, Object> EMPTY = new HashMap<String, Object>();
    private static final int printIfExceedTimeMs = Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.printIfExceedTimeMs", Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.printIfExceedTimeMs", 1000));
    private static final int maxSearchNum = Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.maxSearchNum", Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.maxSearchNum", 10000));
    private final SimpleBinWriter simpleBinWriter;
    private final SimpleBinReader simpleBinReader;
    private final ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock dataSLock = new ReleasableLock(this.dataReadWriteLock.readLock());
    private final ReleasableLock dataXLock = new ReleasableLock(this.dataReadWriteLock.writeLock());
    public static final int LOCK_TIMEOUT_SEC = Math.max(Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.lockTimeoutSec", Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.lockTimeoutSec", 30)), 30);
    final boolean compressed;
    final KeyGenerator keyGenerator = new KeyGeneratorImpl();
    final String filePath;
    final String fileName;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SimpleFileIO(String tag, String filePath, Conf conf, boolean readonly) {
        this(tag, filePath, conf, readonly, true, true);
    }

    public SimpleFileIO(String tag, String filePath, Conf conf, boolean readonly, boolean metaInMemory, boolean load) {
        this(tag, filePath, conf, readonly, metaInMemory, load, null, new MemoryBufferImpl(0x100000L * conf.getMemoryBufferSizeMb()));
    }

    public SimpleFileIO(String tag, String filePath, Conf conf, boolean readonly, boolean metaInMemory, boolean load, VccGenerator vccGenerator, MemoryBuffer memoryBuffer) {
        this.filePath = filePath;
        this.fileName = new File(filePath).getName();
        this.compressed = conf.isCompressed();
        this.simpleBinWriter = readonly ? null : new SimpleBinWriter(tag, filePath, conf, vccGenerator, conf.getRowRegion());
        this.simpleBinReader = new SimpleBinReader(tag, filePath, metaInMemory, load, conf.sorted, conf.sparse, memoryBuffer);
        if (this.simpleBinWriter != null) {
            this.simpleBinWriter.simpleBinReader = this.simpleBinReader;
        }
    }

    @Override
    public FileIO.FilePutResult put(String key, Map<String, Object> meta, byte[] data) {
        if (this.simpleBinWriter == null) {
            throw new UnsupportedOperationException();
        }
        return this.dataX_lock(() -> this.put0(false, key, meta, data, -1L), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    FilePutResultImpl put0(boolean deleted, String key, Map<String, Object> meta, byte[] data, long vccPreDef) {
        return this.put0(deleted, key, meta, ByteBuffer.wrap(data), vccPreDef);
    }

    FilePutResultImpl put0(boolean deleted, String key, Map<String, Object> meta, ByteBuffer data, long vccPreDef) {
        BinWriter.BinPutResult putResult = deleted ? this.simpleBinWriter.delete(key, vccPreDef) : this.simpleBinWriter.put(key, meta, data, vccPreDef);
        return new FilePutResultImpl(putResult.key(), putResult.vcc());
    }

    @Override
    public FileIO.FilePutResult put(Map<String, Object> meta, byte[] data) {
        if (this.simpleBinWriter == null) {
            throw new UnsupportedOperationException();
        }
        return this.dataX_lock(() -> this.put0(false, this.keyGenerator.key(), meta, data, -1L), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public FileIO.CompareAndSetResult compareAndSet(String key, FileIO.CompareAndSet compareAndSet) {
        if (this.simpleBinWriter == null) {
            throw new UnsupportedOperationException();
        }
        return this.dataX_lock(() -> {
            FileGetResultImpl fileGetResult = this.get0(key);
            if (fileGetResult == null) {
                throw DBOpeException.from("key does not exist: " + key);
            }
            fileGetResult.fetchDataAndReleaseBufferRef();
            OperatorImpl operator = new OperatorImpl();
            FileIO.Setter setter = compareAndSet.test(fileGetResult, operator);
            if (setter instanceof NoopImpl) {
                return new CompareAndSetResultImpl(null, null);
            }
            if (setter instanceof FileIO.Delete) {
                FileDeleteResultImpl fileDeleteResult = this.delete0(key);
                return new CompareAndSetResultImpl(null, fileDeleteResult);
            }
            if (setter instanceof FileIO.Put) {
                FilePutResultImpl filePutResult = this.put0(false, key, ((PutImpl)setter).getMeta(), ((PutImpl)setter).getData(), -1L);
                return new CompareAndSetResultImpl(filePutResult, null);
            }
            throw DBOpeException.from("setter is not supported");
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public FileIO.FileGetResult get(String key) {
        return this.dataS_lock(() -> this.getIfFetch(key, true), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private FileGetResultImpl getIfFetch(String key, boolean fetchData) {
        FileGetResultImpl fileGetResult = this.get0(key);
        if (fileGetResult == null || fileGetResult.deleted()) {
            return null;
        }
        if (fetchData) {
            fileGetResult.fetchDataAndReleaseBufferRef();
        } else {
            fileGetResult.releaseBufferRef();
        }
        return fileGetResult;
    }

    @Override
    public FileIO.FileGetResult get(String key, boolean fetchData) {
        return this.dataS_lock(() -> this.getIfFetch(key, fetchData), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public FileIO.FileDeleteResult delete(String key) {
        if (this.simpleBinWriter == null) {
            throw new UnsupportedOperationException();
        }
        return this.dataX_lock(() -> this.delete0(key), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    FileDeleteResultImpl delete0(String key) {
        FilePutResultImpl putResult = this.put0(true, key, EMPTY, new byte[0], -1L);
        return new FileDeleteResultImpl(putResult.key(), putResult.vcc());
    }

    FileGetResultImpl get0(String key) {
        return this.get0(key, true);
    }

    FileGetResultImpl get0(String key, boolean checkDeletedByHighLayer) {
        BinReader.BinMetaGet binMetaGet;
        if (this.simpleBinWriter != null && (binMetaGet = this.simpleBinWriter.get(key)) != null) {
            ByteBuffer byteBuffer = binMetaGet.read();
            return new FileGetResultImpl(binMetaGet.binMeta().getKey(), binMetaGet.binMeta().isDeleted(), binMetaGet.binMeta().getMeta(), byteBuffer, binMetaGet.binMeta().getVcc(), this.filePath, false, this);
        }
        binMetaGet = this.simpleBinReader.get0(key, checkDeletedByHighLayer);
        if (binMetaGet == null) {
            return null;
        }
        ByteBuffer byteBuffer = binMetaGet.read();
        return new FileGetResultImpl(binMetaGet.binMeta().getKey(), binMetaGet.binMeta().isDeleted(), binMetaGet.binMeta().getMeta(), byteBuffer, binMetaGet.binMeta().getVcc(), this.filePath, true, this);
    }

    BinReader.BinMetaGet getBinMetaGet0(String key, boolean fetchMemory, boolean checkDeletedByHighLayer) {
        BinReader.BinMetaGet binMetaGet;
        if (fetchMemory && this.simpleBinWriter != null && (binMetaGet = this.simpleBinWriter.get(key)) != null) {
            return binMetaGet;
        }
        binMetaGet = this.simpleBinReader.get0(key, checkDeletedByHighLayer);
        if (binMetaGet == null) {
            return null;
        }
        return binMetaGet;
    }

    long freeSize() {
        return this.simpleBinWriter.freeSize() - 0x100000L;
    }

    boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws Exception {
        this.closed.set(true);
        Throwable exception = null;
        try {
            if (this.simpleBinWriter != null) {
                this.simpleBinWriter.close();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            exception = e;
        }
        try {
            this.simpleBinReader.close();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            exception = e;
        }
        if (exception != null) {
            throw DBOpeException.from(exception);
        }
    }

    @Override
    public FileIO.DiskFileStat diskFileStat() {
        return new FileIO.DiskFileStat(){

            @Override
            public FileIO.FileStat fileStat() {
                FileIO.FileStat fileStat = new FileIO.FileStat();
                FileIO.FileStat.File file = new FileIO.FileStat.File();
                File f = new File(SimpleFileIO.this.filePath);
                file.setName(f.getName());
                file.setLastModifiedTimeMs(f.lastModified());
                file.setValid(true);
                file.setByteSize(f.length());
                fileStat.fileList.add(file);
                fileStat.setSumByteSize(fileStat.getSumByteSize() + file.getByteSize());
                return fileStat;
            }

            @Override
            public void pretty(OutputStreamWriter outputStreamWriter) {
                FileIO.FileStat fileStat = this.fileStat();
                for (FileIO.FileStat.File file : fileStat.fileList) {
                    try {
                        outputStreamWriter.write(file.getName() + "," + file.getByteSize() + "," + file.getLastModifiedTimeMs() + "(" + Util.formatTime(Util.dateTime(file.getLastModifiedTimeMs()), new String[0]) + "),valid?: " + file.isValid());
                    }
                    catch (IOException e) {
                        throw Util.convert2RuntimeException(e);
                    }
                }
            }
        };
    }

    public long commitAndFsync(boolean closeWrite, boolean postSparse) {
        return this.commitAndFsync(closeWrite, true, postSparse);
    }

    public long commitAndFsync(boolean closeWrite, boolean disableSharedByteBuffer, boolean postSparse) {
        long a;
        if (this.simpleBinWriter == null) {
            throw DBOpeException.from("fsync error, already closed: " + this.filePath);
        }
        long b = this.simpleBinWriter.getWritePosition();
        if (b != (a = this.simpleBinWriter.commitAndFsync())) {
            try {
                long startTime = System.currentTimeMillis();
                if (postSparse) {
                    this.simpleBinReader.postSparseIfAvailable();
                }
                if (disableSharedByteBuffer) {
                    this.simpleBinWriter.disableSharedByteBuffer();
                }
                if (closeWrite) {
                    this.simpleBinWriter.close();
                    Field field = SimpleFileIO.class.getDeclaredField("simpleBinWriter");
                    field.setAccessible(true);
                    field.set(this, null);
                }
                if (System.currentTimeMillis() - startTime > (long)printIfExceedTimeMs) {
                    log.debug("commitAndFsync , cost: " + Util.costTime(startTime));
                }
            }
            catch (Exception e) {
                throw DBOpeException.from(e);
            }
        }
        return a - b;
    }

    @Override
    public void search(final FileIO.SearchListener searchListener) {
        SearchContextImpl searchContext = new SearchContextImpl();
        FileIO.SearchListener proxy = new FileIO.SearchListener(){

            @Override
            public void onRow(FileIO.FileGetResult fileGetResult, FileIO.SearchContext searchContext) {
                FileGetResultImpl getResult = (FileGetResultImpl)fileGetResult;
                if (getResult.deleted()) {
                    return;
                }
                getResult.fetchDataAndReleaseBufferRef();
                searchListener.onRow(fileGetResult, searchContext);
            }
        };
        this.search0(proxy, searchContext, true, true);
    }

    void search0(final FileIO.SearchListener searchListener, final SearchContextImpl searchContext, final boolean checkDiskAtMemory, boolean fetchData) {
        this.simpleBinReader.tail(new CoreSubscriber<FileIO.FileGetResult>(){

            @Override
            public void onNext(FileIO.FileGetResult record) {
                BinReader.BinMetaGet binMetaGet;
                if (checkDiskAtMemory && SimpleFileIO.this.simpleBinWriter != null && (binMetaGet = SimpleFileIO.this.simpleBinWriter.get(record.key())) != null) {
                    return;
                }
                searchListener.onRow(record, searchContext);
                if (searchContext.isCancelled()) {
                    this.cancel();
                }
            }
        }, null, false, false, fetchData);
        if (searchContext.isCancelled()) {
            return;
        }
        if (this.simpleBinWriter != null) {
            this.simpleBinWriter.tail(new CoreSubscriber<FileIO.FileGetResult>(){

                @Override
                public void onNext(FileIO.FileGetResult record) {
                    searchListener.onRow(record, searchContext);
                    if (searchContext.isCancelled()) {
                        this.cancel();
                    }
                }
            }, null, false, false, fetchData);
        }
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n) {
        return this.searchAfter(key, inclusive, n, k -> true);
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate) {
        List<FileIO.FileGetResult> resultList = this.searchAfter0(key, inclusive, n, true, fileGetResult -> !((FileGetResultImpl)fileGetResult).deleted() && predicate.test(fileGetResult.key()));
        resultList.forEach(fileGetResult -> ((FileGetResultImpl)fileGetResult).fetchDataAndReleaseBufferRef());
        return resultList;
    }

    List<FileIO.FileGetResult> searchAfter0(String key, boolean inclusive, int n, boolean checkMemory, DataValidChecker dataValidChecker) {
        return this.getN(key, inclusive, n, false, checkMemory, dataValidChecker);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n) {
        return this.searchBefore(key, inclusive, n, k -> true);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate) {
        List<FileIO.FileGetResult> resultList = this.searchBefore0(key, inclusive, n, true, fileGetResult -> !((FileGetResultImpl)fileGetResult).deleted() && predicate.test(fileGetResult.key()));
        resultList.forEach(fileGetResult -> ((FileGetResultImpl)fileGetResult).fetchDataAndReleaseBufferRef());
        return resultList;
    }

    List<FileIO.FileGetResult> searchBefore0(String key, boolean inclusive, int n, boolean checkMemory, DataValidChecker dataValidChecker) {
        return this.getN(key, inclusive, n, true, checkMemory, dataValidChecker);
    }

    @Override
    public List<FileIO.FileGetResult> top(int n) {
        return this.searchAfter0(null, true, n, true, fileGetResult -> !((FileGetResultImpl)fileGetResult).deleted());
    }

    private List<FileIO.FileGetResult> getN(String key, boolean inclusive, final int n, boolean reversed, final boolean checkMemory, final DataValidChecker dataValidChecker) {
        if (n > maxSearchNum) {
            throw DBOpeException.from("exceed max search num: " + maxSearchNum + " < " + n);
        }
        final ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n + (this.simpleBinWriter == null ? 0 : n));
        this.simpleBinReader.tail(new CoreSubscriber<FileIO.FileGetResult>(){
            int acceptCount = 0;

            @Override
            protected void onSubscribe0(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(FileIO.FileGetResult record) {
                BinReader.BinMetaGet binMetaGet;
                if (checkMemory && SimpleFileIO.this.simpleBinWriter != null && (binMetaGet = SimpleFileIO.this.simpleBinWriter.get(record.key())) != null) {
                    return;
                }
                if (dataValidChecker != null && !dataValidChecker.dataIsValid(record)) {
                    return;
                }
                if (++this.acceptCount > n) {
                    this.cancel();
                }
                fileGetResultList.add(record);
            }
        }, key, inclusive, reversed, true);
        if (this.simpleBinWriter != null) {
            this.simpleBinWriter.tail(new CoreSubscriber<FileIO.FileGetResult>(){
                int acceptCount = 0;

                @Override
                protected void onSubscribe0(Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(FileIO.FileGetResult record) {
                    if (dataValidChecker != null && !dataValidChecker.dataIsValid(record)) {
                        return;
                    }
                    if (++this.acceptCount > n) {
                        this.cancel();
                    }
                    fileGetResultList.add(record);
                }
            }, key, inclusive, reversed, true);
        }
        Comparator<FileIO.FileGetResult> comparing = Comparator.comparing(FileIO.FileGetResult::key);
        fileGetResultList.sort(reversed ? comparing.reversed() : comparing);
        return fileGetResultList.subList(0, Math.min(n, fileGetResultList.size()));
    }

    @Override
    public List<FileIO.FileGetResult> tail(int n) {
        return this.searchBefore0(null, true, n, true, fileGetResult -> !((FileGetResultImpl)fileGetResult).deleted());
    }

    FileIO.FileGetResult firstIncludeInvalidData() {
        List<FileIO.FileGetResult> list = this.searchAfter0(null, true, 1, true, fileGetResult -> true);
        if (Util.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    FileIO.FileGetResult lastIncludeInvalidData() {
        List<FileIO.FileGetResult> list = this.searchBefore0(null, true, 1, true, fileGetResult -> true);
        if (Util.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    MemoryBufferStat memoryBufferStat() {
        return this.simpleBinReader.memoryBufferProxy.memoryBufferStat;
    }

    @Override
    public int rowCountIncludeInvalidData() {
        int size = this.simpleBinReader.size();
        if (this.simpleBinWriter != null) {
            size += this.simpleBinWriter.size();
        }
        return size;
    }

    boolean addDeletedByHighLayer(String key, long vcc) {
        return this.simpleBinReader.addDeletedByHighLayer(key, vcc);
    }

    @Override
    public int count() {
        final AtomicInteger c = new AtomicInteger();
        SearchContextImpl searchContext = new SearchContextImpl();
        FileIO.SearchListener proxy = new FileIO.SearchListener(){

            @Override
            public void onRow(FileIO.FileGetResult fileGetResult, FileIO.SearchContext searchContext) {
                FileGetResultImpl getResult = (FileGetResultImpl)fileGetResult;
                if (getResult.deleted()) {
                    return;
                }
                c.incrementAndGet();
            }
        };
        this.search0(proxy, searchContext, true, false);
        return c.get();
    }

    String fileName() {
        return this.fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T dataX_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock dataXLock = this.dataXLock.acquire(time, unit);){
            if (dataXLock == null) {
                throw new TimeoutException("dataXLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T dataS_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock metaSLock = this.dataSLock.acquire(time, unit);){
            if (metaSLock == null) {
                throw new TimeoutException("dataSLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from(e);
        }
    }

    SimpleFileIO snapshot() {
        SimpleFileIO cloned;
        try {
            cloned = (SimpleFileIO)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Util.convert2RuntimeException(e);
        }
        try {
            Field field = SimpleFileIO.class.getDeclaredField("simpleBinWriter");
            field.setAccessible(true);
            field.set(cloned, null);
            field = SimpleFileIO.class.getDeclaredField("keyGenerator");
            field.setAccessible(true);
            field.set(cloned, () -> {
                throw new UnsupportedOperationException();
            });
            SimpleBinReader snapshotReader = cloned.simpleBinReader.snapshot();
            field = SimpleFileIO.class.getDeclaredField("simpleBinReader");
            field.setAccessible(true);
            field.set(cloned, snapshotReader);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException(e);
        }
        return cloned;
    }

    @Override
    public void releaseSnapshot() {
        log.info("releaseSnapshot: nothing");
    }

    public String getFilePath() {
        return this.filePath;
    }

    private class SimpleBinWriter
    implements BinWriter,
    BinReader {
        private final AppendLog.BufferedAppendLogImpl bufferedAppendLog;
        private final ConcurrentSkipListMap<String, SharedByteBufferGetImpl> binMetaRefMap = new ConcurrentSkipListMap(Comparator.naturalOrder());
        long wp;
        final long maxRowByteSize;
        final long maxRegionByteSize;
        final VccGenerator vccGenerator;
        final int rowRegion;
        RegionFormat regionFormat;
        SimpleBinReader simpleBinReader;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public SimpleBinWriter(String tag, String filePath, Conf conf, VccGenerator vccGenerator, int rowRegion) {
            if (conf.getWalDiskSizeMb() < 2L) {
                throw DBOpeException.from("disk size > 2: " + conf.getWalDiskSizeMb());
            }
            this.bufferedAppendLog = new AppendLog.BufferedAppendLogImpl(tag, filePath, conf);
            log.info(filePath + ", init freeSize: " + this.bufferedAppendLog.freeSize4G() + ", walBufferSizeMb: " + conf.getWalBufferSizeMb() + ", walDiskSizeMb: " + conf.getWalDiskSizeMb());
            this.wp = this.bufferedAppendLog.getWritePosition();
            this.maxRegionByteSize = (long)conf.getWalBufferSizeMb() * 0x100000L / 2L;
            this.maxRowByteSize = this.maxRegionByteSize / 2L;
            this.rowRegion = rowRegion;
            this.vccGenerator = vccGenerator == null ? new VccGenerator(){
                private final AtomicLong vcc = new AtomicLong();

                @Override
                public long next() {
                    return this.vcc.incrementAndGet();
                }
            } : vccGenerator;
            this.regionFormat = new RegionFormat();
        }

        @Override
        public BinWriter.BinPutResult put(String key, Map<String, Object> meta, byte[] data, long vccPreDef) {
            return this.put0(false, key, meta, ByteBuffer.wrap(data), vccPreDef);
        }

        @Override
        public BinWriter.BinPutResult put(String key, Map<String, Object> meta, ByteBuffer data, long vccPreDef) {
            return this.put0(false, key, meta, data, vccPreDef);
        }

        private BinPutResultImpl put0(boolean deleted, String key, Map<String, Object> meta, ByteBuffer data, long vccPreDef) {
            boolean flushRegionFlag;
            BinMeta binMeta = new BinMeta();
            binMeta.setDeleted(deleted);
            binMeta.setKey(key);
            binMeta.setMeta(meta);
            long vcc = vccPreDef >= 0L ? vccPreDef : this.vccGenerator.next();
            ByteBuffer byteBuffer = BinFormat.write(deleted, binMeta, data, vcc);
            byte[] array = byteBuffer.array();
            if ((long)array.length > this.maxRowByteSize) {
                throw DBOpeException.from("exceed buff size: " + this.maxRowByteSize + " < " + array.length);
            }
            int l = this.regionFormat.write(deleted, key, vcc, byteBuffer);
            boolean bl = flushRegionFlag = l > this.rowRegion || this.regionFormat.byteSize() > this.maxRegionByteSize;
            if (!flushRegionFlag) {
                SharedByteBufferGetImpl byteBufferGet = new SharedByteBufferGetImpl(deleted, key, vcc, ByteBuffer.wrap(byteBuffer.array()));
                this.binMetaRefMap.put(key, byteBufferGet);
                return new BinPutResultImpl(key, vcc, this.bufferedAppendLog.getWritePosition());
            }
            long writePosition = this.flushRegion0();
            return new BinPutResultImpl(key, vcc, writePosition);
        }

        private long flushRegion0() {
            byte[] array = this.regionFormat.toByteArray();
            Map regionKeyMap = this.regionFormat.binFormatList;
            AppendLog.BufferedAppendLogImpl.RowCapture rowCapture = new AppendLog.BufferedAppendLogImpl.RowCapture(){

                @Override
                public void capture(ByteBuffer ref) {
                    ByteBuffer sharedByteBuffer = ref;
                    if (SimpleBinWriter.this.bufferedAppendLog.compressed()) {
                        byte[] decompressed = Util.decompress(ref.array(), ref.position(), ref.limit() - ref.position());
                        sharedByteBuffer = ByteBuffer.wrap(decompressed);
                    }
                    LinkedHashMap<String, RegionFormat.ReadableRow> rowMap = RegionFormat.read(sharedByteBuffer);
                    for (Map.Entry entry : rowMap.entrySet()) {
                        String key = (String)entry.getKey();
                        RegionFormat.ReadableRow readableRow = (RegionFormat.ReadableRow)entry.getValue();
                        SharedByteBufferGetImpl byteBufferGet = new SharedByteBufferGetImpl(readableRow.deleted, key, readableRow.vcc, readableRow.getByteBuffer().duplicate());
                        SimpleBinWriter.this.binMetaRefMap.put(key, byteBufferGet);
                    }
                    SimpleBinWriter.this.regionFormat = new RegionFormat();
                }
            };
            if (this.bufferedAppendLog.compressed()) {
                this.bufferedAppendLog.appendInternal(Util.compress(array), rowCapture);
            } else {
                this.bufferedAppendLog.appendInternal(array, rowCapture);
            }
            long writePosition = this.bufferedAppendLog.getWritePosition();
            if (this.wp != writePosition) {
                try {
                    long startTime = System.currentTimeMillis();
                    long refresh = this.simpleBinReader.refresh(this.wp, writePosition);
                    if (System.currentTimeMillis() - startTime > (long)printIfExceedTimeMs) {
                        log.debug("write flush, then reader load all data , from " + this.wp + " > " + refresh + "/" + writePosition + "(" + (refresh - writePosition) + ") , cost: " + Util.costTime(startTime));
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw Util.convert2RuntimeException(e);
                }
                for (SharedByteBufferGetImpl sharedByteBufferGet : this.binMetaRefMap.values()) {
                    if (regionKeyMap.containsKey(sharedByteBufferGet.key)) continue;
                    sharedByteBufferGet.fsync = true;
                    this.binMetaRefMap.remove(sharedByteBufferGet.key);
                }
                this.wp = writePosition;
            }
            return writePosition;
        }

        void disableSharedByteBuffer() {
            for (SharedByteBufferGetImpl sharedByteBufferGet : this.binMetaRefMap.values()) {
                sharedByteBufferGet.fsync = true;
            }
            this.binMetaRefMap.clear();
        }

        @Override
        public BinWriter.BinPutResult delete(String key, long vccPreDef) {
            return this.put0(true, key, EMPTY, ByteBuffer.wrap(new byte[0]), vccPreDef);
        }

        @Override
        public long freeSize() {
            return this.bufferedAppendLog.freeSize4G();
        }

        @Override
        public void close() throws IOException {
            if (this.closed.get()) {
                return;
            }
            this.commitAndFsync();
            this.disableSharedByteBuffer();
            this.bufferedAppendLog.close();
            this.closed.set(true);
            log.info("writer closed : " + SimpleFileIO.this.filePath);
        }

        public long commitAndFsync() {
            long b = this.flushRegion0();
            this.bufferedAppendLog.commit();
            long a = this.bufferedAppendLog.getWritePosition();
            try {
                this.simpleBinReader.refresh(b, a);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException(e);
            }
            return this.bufferedAppendLog.getWritePosition();
        }

        long getWritePosition() {
            return this.bufferedAppendLog.getWritePosition();
        }

        @Override
        public BinReader.BinMetaGet get(String key) {
            return this.binMetaRefMap.get(key);
        }

        @Override
        public boolean addDeletedByHighLayer(String key, long vcc) {
            throw new UnsupportedOperationException();
        }

        void tail(final CoreSubscriber<FileIO.FileGetResult> coreSubscriber, String key, boolean inclusive, boolean reversed, final boolean fetchData) {
            NavigableMap<Object, Object> navigableMap = Util.isEmpty(key) ? (reversed ? this.binMetaRefMap.descendingMap() : this.binMetaRefMap) : (reversed ? this.binMetaRefMap.descendingMap().tailMap(key, inclusive) : this.binMetaRefMap.tailMap((Object)key, inclusive));
            Iterator iterator = navigableMap.entrySet().iterator();
            Stream.from(iterator).subscribe(new CoreSubscriber<Map.Entry<String, SharedByteBufferGetImpl>>(){

                @Override
                protected void onSubscribe0(Subscription subscription) {
                    coreSubscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(Map.Entry<String, SharedByteBufferGetImpl> record) {
                    BinReader.BinMetaGet binMetaGet = record.getValue();
                    ByteBuffer byteBuffer = fetchData ? binMetaGet.read() : null;
                    FileGetResultImpl fileGetResult = new FileGetResultImpl(binMetaGet.binMeta().getKey(), binMetaGet.binMeta().isDeleted(), binMetaGet.binMeta().getMeta(), byteBuffer, binMetaGet.binMeta().getVcc(), SimpleFileIO.this.filePath, false, SimpleFileIO.this);
                    coreSubscriber.onNext(fileGetResult);
                }
            });
        }

        int size() {
            return this.binMetaRefMap.size();
        }

        class BinPutResultImpl
        implements BinWriter.BinPutResult {
            private final String key;
            final long writePosition;
            final long vcc;

            public BinPutResultImpl(String key, long vcc, long writePosition) {
                this.key = key;
                this.vcc = vcc;
                this.writePosition = writePosition;
            }

            @Override
            public String key() {
                return this.key;
            }

            @Override
            public long filePositionPossible() {
                return this.writePosition;
            }

            @Override
            public long vcc() {
                return this.vcc;
            }
        }

        class SharedByteBufferGetImpl
        implements BinReader.BinMetaGet {
            final boolean deleted;
            private final long vcc;
            private final String key;
            final ByteBuffer byteBuffer;
            BinFormat.SharedBufferBinMeta sharedBufferBinMeta;
            boolean fsync;

            public SharedByteBufferGetImpl(boolean deleted, String key, long vcc, ByteBuffer byteBuffer) {
                this.deleted = deleted;
                this.key = key;
                this.vcc = vcc;
                this.byteBuffer = byteBuffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BinMeta binMeta() {
                if (this.sharedBufferBinMeta != null) {
                    return this.sharedBufferBinMeta;
                }
                ByteBuffer byteBuffer = this.byteBuffer;
                synchronized (byteBuffer) {
                    if (this.sharedBufferBinMeta != null) {
                        return this.sharedBufferBinMeta;
                    }
                    this.sharedBufferBinMeta = BinFormat.readFromMemory0(this.byteBuffer);
                    return this.sharedBufferBinMeta;
                }
            }

            @Override
            public ByteBuffer read() {
                if (this.sharedBufferBinMeta == null) {
                    this.binMeta();
                }
                return this.sharedBufferBinMeta.getByteBuffer().duplicate();
            }

            @Override
            public void close() {
            }
        }
    }

    public static class Conf
    extends AppendLog.AppendLogConf
    implements Model {
        private int rowRegion = 100;
        boolean sparse;
        boolean sorted;
        long memoryBufferSizeMb = 10L;

        public static Conf defaultConf() {
            Conf conf = new Conf();
            conf.setCompressed(true);
            return conf;
        }

        public int getRowRegion() {
            return this.rowRegion;
        }

        public boolean isSparse() {
            return this.sparse;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        public long getMemoryBufferSizeMb() {
            return this.memoryBufferSizeMb;
        }

        public void setRowRegion(int rowRegion) {
            this.rowRegion = rowRegion;
        }

        public void setSparse(boolean sparse) {
            this.sparse = sparse;
        }

        public void setSorted(boolean sorted) {
            this.sorted = sorted;
        }

        public void setMemoryBufferSizeMb(long memoryBufferSizeMb) {
            this.memoryBufferSizeMb = memoryBufferSizeMb;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conf)) {
                return false;
            }
            Conf other = (Conf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRowRegion() != other.getRowRegion()) {
                return false;
            }
            if (this.isSparse() != other.isSparse()) {
                return false;
            }
            if (this.isSorted() != other.isSorted()) {
                return false;
            }
            return this.getMemoryBufferSizeMb() == other.getMemoryBufferSizeMb();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Conf;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowRegion();
            result = result * 59 + (this.isSparse() ? 79 : 97);
            result = result * 59 + (this.isSorted() ? 79 : 97);
            long $memoryBufferSizeMb = this.getMemoryBufferSizeMb();
            result = result * 59 + (int)($memoryBufferSizeMb >>> 32 ^ $memoryBufferSizeMb);
            return result;
        }

        @Override
        public String toString() {
            return "SimpleFileIO.Conf(rowRegion=" + this.getRowRegion() + ", sparse=" + this.isSparse() + ", sorted=" + this.isSorted() + ", memoryBufferSizeMb=" + this.getMemoryBufferSizeMb() + ")";
        }
    }

    static class MemoryBufferImpl
    implements MemoryBuffer {
        final ShardMap[] shards;
        final AtomicLong usedByteSize = new AtomicLong();
        final long maxBufferSize;
        final long splitBufferSize;
        final MemoryBufferStat memoryBufferStat;

        public MemoryBufferImpl(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            this.splitBufferSize = maxBufferSize * 4L / 5L;
            this.memoryBufferStat = new MemoryBufferStat();
            this.memoryBufferStat.maxBufferSize = this.maxBufferSize;
            this.memoryBufferStat.splitBufferSize = this.splitBufferSize;
            this.shards = new ShardMap[5];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ShardMap shardMap(String key) {
            int i = Util.shard(key, this.shards.length);
            ShardMap shardMap = this.shards[i];
            if (shardMap == null) {
                ShardMap[] shardMapArray = this.shards;
                synchronized (this.shards) {
                    this.shards[i] = new ShardMap();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.shards[i];
                }
            }
            return shardMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean add(String filePath, long startPosition, long endPosition, ByteBuffer byteBuffer) {
            String key = filePath + ":" + startPosition + ":" + endPosition;
            if (this.usedByteSize.get() > this.maxBufferSize) {
                int sumShardMapBufferCount;
                ShardMap[] shardMapArray = this.shards;
                // MONITORENTER : this.shards
                do {
                    sumShardMapBufferCount = 0;
                    for (ShardMap shardMap : this.shards) {
                        LinkedHashMap<String, ByteBuffer> shardBufferMap;
                        if (shardMap == null) continue;
                        LinkedHashMap<String, ByteBuffer> linkedHashMap = shardBufferMap = shardMap.shardBufferMap;
                        // MONITORENTER : linkedHashMap
                        int size = shardBufferMap.size();
                        sumShardMapBufferCount += size;
                        int removedSize = size / 5;
                        Iterator<Map.Entry<String, ByteBuffer>> iterator = shardBufferMap.entrySet().iterator();
                        int count = 0;
                        while (iterator.hasNext()) {
                            int capacity = iterator.next().getValue().capacity();
                            iterator.remove();
                            this.usedByteSize.addAndGet(-capacity);
                            shardMap.shardUsedByteSize.addAndGet(-capacity);
                            if (count++ <= removedSize) continue;
                        }
                        // MONITOREXIT : linkedHashMap
                    }
                } while (this.usedByteSize.get() <= this.splitBufferSize && sumShardMapBufferCount != 0);
                // MONITOREXIT : shardMapArray
                ++this.memoryBufferStat.clearCount;
                this.memoryBufferStat.usedByteSize = this.usedByteSize.get();
            }
            boolean f = this.shardMap(key).add(key, filePath, startPosition, endPosition, byteBuffer);
            this.usedByteSize.addAndGet(byteBuffer.array().length);
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAllBuffer(String filePath) {
            ShardMap[] shardMapArray = this.shards;
            synchronized (this.shards) {
                for (ShardMap shardMap : this.shards) {
                    LinkedHashMap<String, ByteBuffer> shardBufferMap;
                    if (shardMap == null) continue;
                    LinkedHashMap<String, ByteBuffer> linkedHashMap = shardBufferMap = shardMap.shardBufferMap;
                    synchronized (linkedHashMap) {
                        Iterator<Map.Entry<String, ByteBuffer>> iterator = shardBufferMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, ByteBuffer> next = iterator.next();
                            String key = next.getKey();
                            if (!key.startsWith(filePath)) continue;
                            int capacity = next.getValue().capacity();
                            iterator.remove();
                            this.usedByteSize.addAndGet(-capacity);
                            shardMap.shardUsedByteSize.addAndGet(-capacity);
                        }
                    }
                }
                this.memoryBufferStat.usedByteSize = this.usedByteSize.get();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        @Override
        public ByteBuffer read(String filePath, long startPosition, long endPosition) {
            int length = (int)(endPosition - startPosition);
            if (length == 0) {
                return ByteBuffer.allocate(0);
            }
            String key = filePath + ":" + startPosition + ":" + endPosition;
            ByteBuffer b = this.shardMap(key).read(key, filePath, startPosition, endPosition);
            if (b != null) {
                this.memoryBufferStat.hint.incrementAndGet();
                return b.duplicate();
            }
            this.memoryBufferStat.miss.incrementAndGet();
            return null;
        }

        class ShardMap {
            final LinkedHashMap<String, ByteBuffer> shardBufferMap = new LinkedHashMap();
            final AtomicLong shardUsedByteSize = new AtomicLong();

            ShardMap() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean add(String key, String filePath, long startPosition, long endPosition, ByteBuffer byteBuffer) {
                LinkedHashMap<String, ByteBuffer> linkedHashMap = this.shardBufferMap;
                synchronized (linkedHashMap) {
                    this.shardBufferMap.put(key, byteBuffer);
                }
                this.shardUsedByteSize.addAndGet(byteBuffer.array().length);
                return true;
            }

            int size() {
                return this.shardBufferMap.size();
            }

            ByteBuffer read(String key, String filePath, long startPosition, long endPosition) {
                int length = (int)(endPosition - startPosition);
                if (length == 0) {
                    return ByteBuffer.allocate(0);
                }
                ByteBuffer b = this.shardBufferMap.get(key);
                if (b != null) {
                    MemoryBufferImpl.this.memoryBufferStat.hint.incrementAndGet();
                    return b.duplicate();
                }
                MemoryBufferImpl.this.memoryBufferStat.miss.incrementAndGet();
                return null;
            }
        }
    }

    static interface VccGenerator {
        public long next();
    }

    static interface MemoryBuffer {
        public ByteBuffer read(String var1, long var2, long var4);

        public boolean add(String var1, long var2, long var4, ByteBuffer var6);

        public void removeAllBuffer(String var1);
    }

    private static class KeyGeneratorImpl
    implements KeyGenerator {
        private final String keyPrefix = Util.uniqueFirstPart();
        private static final int LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();
        private final AtomicLong key = new AtomicLong();

        private KeyGeneratorImpl() {
        }

        @Override
        public String key() {
            return this.keyPrefix + ":" + Util.leftPad(this.key.incrementAndGet(), LONG_LENGTH);
        }
    }

    static interface KeyGenerator {
        public String key();
    }

    private class SimpleBinReader
    implements Closeable,
    BinReader,
    Cloneable {
        private final AppendLog.AppendLogFileImpl appendLogFile;
        private final ConcurrentSkipListMap<String, BinMetaRef> binMetaRefMap = new ConcurrentSkipListMap(Comparator.naturalOrder());
        final boolean metaInMemory;
        private volatile long readPosition;
        final MemoryBufferProxy memoryBufferProxy;
        final boolean sparse;
        final boolean sorted;
        private int realKeyCount;
        final DeletedByHighLayer deletedByHighLayer;
        private final ReentrantReadWriteLock delLock = new ReentrantReadWriteLock();
        private final ReleasableLock delSLock = new ReleasableLock(this.delLock.readLock());
        private final ReleasableLock delXLock = new ReleasableLock(this.delLock.writeLock());

        public SimpleBinReader(String tag, String path) {
            this(tag, path, true, true, false, false, new MemoryBufferImpl(0xA00000L));
        }

        public SimpleBinReader(String path) {
            this("bin", path);
        }

        public SimpleBinReader(String tag, String path, boolean metaInMemory, boolean load, boolean sorted, boolean sparse, MemoryBuffer memoryBuffer) {
            this.metaInMemory = metaInMemory;
            this.sorted = sorted;
            this.sparse = sparse;
            this.appendLogFile = new AppendLog.AppendLogFileImpl(tag, path, 0x40000000L, true);
            log.info("file reader(" + path + ") , metaInMemory: " + metaInMemory + " ,  sorted: " + sorted + " , sparse: " + sparse);
            if (load) {
                try {
                    long startTime = System.currentTimeMillis();
                    this.readPosition = this.refresh(0L, this.appendLogFile.getWritePosition());
                    log.debug(path + " , load all data (0 > " + this.readPosition + ") , size: " + this.binMetaRefMap.size() + " , cost: " + Util.costTime(startTime));
                }
                catch (Exception e) {
                    try {
                        this.appendLogFile.close();
                    }
                    catch (Exception e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    throw Util.convert2RuntimeException(e);
                }
            }
            this.memoryBufferProxy = new MemoryBufferProxy(memoryBuffer);
            this.deletedByHighLayer = new MemoryDeletedByHighLayer();
        }

        void postSparseIfAvailable() {
        }

        long refresh(final long start, final long end) throws Exception {
            return this.delX_lock(new DoInLock<Long>(){

                @Override
                public Long doInLock() {
                    if (start == end) {
                        return SimpleBinReader.this.readPosition;
                    }
                    final AtomicLong scanPosition = new AtomicLong(-1L);
                    long s = Math.max(SimpleBinReader.this.readPosition, start);
                    long e = Math.max(SimpleBinReader.this.readPosition, end);
                    SimpleBinReader.this.appendLogFile.advancedScan(s, e, new AppendLog.AdvancedRowListener(){

                        @Override
                        public void onRow(byte[] row, int offset, int length, long startPosition, long endPosition) {
                            LinkedHashMap<String, RegionFormat.ReadableRow> rowMap = RegionFormat.read(SimpleBinReader.this.appendLogFile.compressed() ? ByteBuffer.wrap(Util.decompress(row, offset, length)) : ByteBuffer.wrap(row, offset, length));
                            int count = 0;
                            for (Map.Entry<String, RegionFormat.ReadableRow> entry : rowMap.entrySet()) {
                                String key = entry.getKey();
                                RegionFormat.ReadableRow readableRow = entry.getValue();
                                BinMetaRef binMetaRef = SimpleBinReader.this.binMetaRefFromReadableRow0(startPosition, endPosition, readableRow, key);
                                if (SimpleBinReader.this.sorted && SimpleBinReader.this.sparse) {
                                    if (count++ != 0) continue;
                                    SimpleBinReader.this.binMetaRefMap.put(binMetaRef.getKey(), binMetaRef);
                                    SimpleBinReader.this.realKeyCount += rowMap.size();
                                    continue;
                                }
                                SimpleBinReader.this.binMetaRefMap.put(binMetaRef.getKey(), binMetaRef);
                                SimpleBinReader.this.realKeyCount++;
                            }
                            scanPosition.set(endPosition);
                        }
                    });
                    SimpleBinReader.this.readPosition = scanPosition.get() > -1L ? scanPosition.get() : SimpleBinReader.this.readPosition;
                    return SimpleBinReader.this.readPosition;
                }
            });
        }

        private BinMetaRef binMetaRefFromReadableRow0(long startPosition, long endPosition, RegionFormat.ReadableRow readableRow, String key) {
            ByteBuffer buffer = readableRow.getByteBuffer().duplicate();
            buffer.position(readableRow.startInRegion);
            buffer.limit(readableRow.endInRegion);
            BinMeta bm = BinFormat.read(buffer);
            if (bm == null || Util.compare2((Comparable)((Object)key), (Comparable)((Object)bm.getKey())) != 0) {
                throw DBOpeException.from("data error");
            }
            BinMetaRef binMetaRef = new BinMetaRef();
            binMetaRef.setDeleted(bm.isDeleted());
            binMetaRef.setKey(bm.getKey());
            binMetaRef.setVcc(bm.getVcc());
            binMetaRef.setStartPosition(startPosition);
            binMetaRef.setEndPosition(endPosition);
            binMetaRef.setStartInRegion(readableRow.startInRegion);
            binMetaRef.setEndInRegion(readableRow.endInRegion);
            if (this.metaInMemory) {
                binMetaRef.setMeta(bm.getMeta());
            }
            binMetaRef.setJsonLength(bm.getJsonLength());
            binMetaRef.setBinLength(bm.getBinLength());
            return binMetaRef;
        }

        @Override
        public void close() throws IOException {
            Throwable exception = null;
            try {
                this.appendLogFile.close();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                exception = e;
            }
            this.binMetaRefMap.clear();
            try {
                this.deletedByHighLayer.close();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                exception = e;
            }
            if (exception != null) {
                throw DBOpeException.from(exception);
            }
        }

        @Override
        public BinReader.BinMetaGet get(String key) {
            return this.get0(key, true);
        }

        @Override
        public boolean addDeletedByHighLayer(final String key, final long vcc) {
            if (SimpleFileIO.this.simpleBinWriter != null) {
                return true;
            }
            return this.delX_lock(new DoInLock<Boolean>(){

                @Override
                public Boolean doInLock() {
                    BinMetaGetImpl binMetaGet = SimpleBinReader.this.get0(key, false);
                    if (binMetaGet.binMeta().getVcc() == vcc) {
                        return SimpleBinReader.this.deletedByHighLayer.add(key);
                    }
                    return true;
                }
            });
        }

        private BinMetaGetImpl get0(String key, boolean checkDeletedByHighLayer) {
            if (this.sorted && this.sparse) {
                Map.Entry<String, BinMetaRef> entry = this.binMetaRefMap.floorEntry(key);
                if (entry == null) {
                    return null;
                }
                BinMetaRef binMetaRef = entry.getValue();
                if (key.equals(entry.getKey())) {
                    return new BinMetaGetImpl(binMetaRef);
                }
                ByteBuffer byteBuffer = this.memoryBufferProxy.read(binMetaRef.startPosition, binMetaRef.endPosition);
                LinkedHashMap<String, RegionFormat.ReadableRow> map = RegionFormat.read(byteBuffer);
                RegionFormat.ReadableRow readableRow = map.get(key);
                if (readableRow == null) {
                    return null;
                }
                BinMetaRef metaRef = this.binMetaRefFromReadableRow0(binMetaRef.startPosition, binMetaRef.endPosition, readableRow, key);
                if (checkDeletedByHighLayer && this.deletedByHighLayer.deletedByHighLayer(metaRef)) {
                    return null;
                }
                return new BinMetaGetImpl(metaRef);
            }
            BinMetaRef binMetaRef = this.binMetaRefMap.get(key);
            if (binMetaRef == null) {
                return null;
            }
            if (checkDeletedByHighLayer && this.deletedByHighLayer.deletedByHighLayer(binMetaRef)) {
                return null;
            }
            return new BinMetaGetImpl(binMetaRef);
        }

        void tail(final CoreSubscriber<FileIO.FileGetResult> coreSubscriber, String key, boolean inclusive, boolean reversed, final boolean fetchData) {
            EntryIterator itMetaRef;
            NavigableMap<Object, Object> navigableMap = Util.isEmpty(key) ? (reversed ? this.binMetaRefMap.descendingMap() : this.binMetaRefMap) : (reversed ? this.binMetaRefMap.descendingMap().tailMap(key, inclusive) : this.binMetaRefMap.tailMap((Object)key, inclusive));
            EntryIterator tempIterator = itMetaRef = navigableMap.entrySet().iterator();
            if (this.sorted && this.sparse) {
                tempIterator = new EntryIterator(itMetaRef, reversed, key);
            }
            final EntryIterator finalTempIterator = tempIterator;
            Iterator<Map.Entry<String, BinMetaRef>> iterator = new Iterator<Map.Entry<String, BinMetaRef>>(){
                final Iterator<Map.Entry<String, BinMetaRef>> iterator;
                Map.Entry<String, BinMetaRef> entry;
                {
                    this.iterator = finalTempIterator;
                }

                @Override
                public boolean hasNext() {
                    while (this.iterator.hasNext()) {
                        Map.Entry<String, BinMetaRef> next = this.iterator.next();
                        if (SimpleBinReader.this.deletedByHighLayer.deletedByHighLayer(next.getValue())) continue;
                        this.entry = next;
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<String, BinMetaRef> next() {
                    return this.entry;
                }
            };
            Stream.from(iterator).subscribe((Subscriber<3>)new CoreSubscriber<Map.Entry<String, BinMetaRef>>(){

                @Override
                protected void onSubscribe0(Subscription subscription) {
                    coreSubscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(Map.Entry<String, BinMetaRef> record) {
                    BinMetaGetImpl binMetaGet = new BinMetaGetImpl(record.getValue());
                    ByteBuffer byteBuffer = fetchData ? binMetaGet.read() : null;
                    FileGetResultImpl fileGetResult = new FileGetResultImpl(binMetaGet.binMeta().getKey(), binMetaGet.binMeta().isDeleted(), binMetaGet.binMeta().getMeta(), byteBuffer, binMetaGet.binMeta().getVcc(), SimpleFileIO.this.filePath, true, SimpleFileIO.this);
                    coreSubscriber.onNext(fileGetResult);
                }
            });
        }

        int size() {
            return this.realKeyCount;
        }

        private ByteBuffer readFromDisk(long startPosition, long endPosition) {
            ByteBuffer byteBuffer;
            block9: {
                int length = (int)(endPosition - startPosition);
                if (length == 0) {
                    return ByteBuffer.allocate(0);
                }
                File file = new File(this.appendLogFile.filePath());
                FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
                try {
                    fileChannel.position(startPosition);
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(length);
                    fileChannel.read(byteBuffer2);
                    byteBuffer2.flip();
                    byteBuffer2.position(4);
                    byteBuffer = byteBuffer2;
                    if (fileChannel == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileChannel != null) {
                            try {
                                fileChannel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw DBOpeException.from(e);
                    }
                }
                fileChannel.close();
            }
            return byteBuffer;
        }

        SimpleBinReader snapshot() {
            SimpleBinReader cloned;
            try {
                cloned = (SimpleBinReader)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw Util.convert2RuntimeException(e);
            }
            try {
                Field field = SimpleBinReader.class.getDeclaredField("deletedByHighLayer");
                field.setAccessible(true);
                field.set(cloned, new DisableDeletedByHighLayer());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException(e);
            }
            return cloned;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T delX_lock(DoInLock<T> doInLock) {
            try (ReleasableLock dataXLock = this.delXLock.acquire();){
                T t = doInLock.doInLock();
                return t;
            }
            catch (Exception e) {
                throw DBOpeException.from(e);
            }
        }

        class BinMetaRef
        extends BinMeta {
            private long startPosition;
            private long endPosition;
            private int startInRegion;
            private int endInRegion;

            public long getStartPosition() {
                return this.startPosition;
            }

            public long getEndPosition() {
                return this.endPosition;
            }

            public int getStartInRegion() {
                return this.startInRegion;
            }

            public int getEndInRegion() {
                return this.endInRegion;
            }

            public void setStartPosition(long startPosition) {
                this.startPosition = startPosition;
            }

            public void setEndPosition(long endPosition) {
                this.endPosition = endPosition;
            }

            public void setStartInRegion(int startInRegion) {
                this.startInRegion = startInRegion;
            }

            public void setEndInRegion(int endInRegion) {
                this.endInRegion = endInRegion;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BinMetaRef)) {
                    return false;
                }
                BinMetaRef other = (BinMetaRef)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getStartPosition() != other.getStartPosition()) {
                    return false;
                }
                if (this.getEndPosition() != other.getEndPosition()) {
                    return false;
                }
                if (this.getStartInRegion() != other.getStartInRegion()) {
                    return false;
                }
                return this.getEndInRegion() == other.getEndInRegion();
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof BinMetaRef;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $startPosition = this.getStartPosition();
                result = result * 59 + (int)($startPosition >>> 32 ^ $startPosition);
                long $endPosition = this.getEndPosition();
                result = result * 59 + (int)($endPosition >>> 32 ^ $endPosition);
                result = result * 59 + this.getStartInRegion();
                result = result * 59 + this.getEndInRegion();
                return result;
            }

            @Override
            public String toString() {
                return "SimpleFileIO.SimpleBinReader.BinMetaRef(startPosition=" + this.getStartPosition() + ", endPosition=" + this.getEndPosition() + ", startInRegion=" + this.getStartInRegion() + ", endInRegion=" + this.getEndInRegion() + ")";
            }
        }

        class BinMetaGetImpl
        implements BinReader.BinMetaGet {
            final long startPosition;
            final long endPosition;
            private int startInRegion;
            private int endInRegion;
            ByteBuffer buffer;
            BinMeta binMeta;

            public BinMetaGetImpl(BinMetaRef binMetaRef) {
                this.endPosition = binMetaRef.getEndPosition();
                this.startPosition = binMetaRef.getStartPosition();
                this.startInRegion = binMetaRef.getStartInRegion();
                this.endInRegion = binMetaRef.getEndInRegion();
                if (SimpleBinReader.this.metaInMemory) {
                    this.binMeta = binMetaRef;
                }
            }

            @Override
            public BinMeta binMeta() {
                if (this.binMeta == null) {
                    this.buffer = this.read0();
                    this.binMeta = BinFormat.read(this.buffer);
                }
                return this.binMeta;
            }

            public ByteBuffer read0() {
                return SimpleBinReader.this.memoryBufferProxy.read(this.startPosition, this.endPosition);
            }

            @Override
            public ByteBuffer read() {
                this.binMeta();
                if (this.buffer == null) {
                    this.buffer = this.read0();
                }
                ByteBuffer byteBuffer = this.buffer.duplicate();
                byteBuffer.position(this.startInRegion);
                byteBuffer.position(this.startInRegion + 1 + 8 + 8 + this.binMeta.getJsonLength());
                byteBuffer.limit(byteBuffer.position() + this.binMeta.getBinLength());
                assert (byteBuffer.limit() == this.endInRegion);
                return byteBuffer;
            }

            @Override
            public void close() {
                this.buffer.clear();
                this.buffer = null;
                this.binMeta = null;
            }
        }

        class MemoryBufferProxy {
            final MemoryBuffer memoryBuffer;
            final MemoryBufferStat memoryBufferStat = new MemoryBufferStat();

            public MemoryBufferProxy(MemoryBuffer memoryBuffer) {
                this.memoryBuffer = memoryBuffer;
            }

            ByteBuffer read(long startPosition, long endPosition) {
                int length = (int)(endPosition - startPosition);
                if (length == 0) {
                    return ByteBuffer.allocate(0);
                }
                ByteBuffer b = this.memoryBuffer.read(SimpleFileIO.this.filePath, startPosition, endPosition);
                if (b != null) {
                    this.memoryBufferStat.hint.incrementAndGet();
                    return b.duplicate();
                }
                String key = startPosition + ":" + endPosition;
                return Util.lock("getFileFromDisk:" + key, () -> {
                    ByteBuffer bf = this.memoryBuffer.read(SimpleFileIO.this.filePath, startPosition, endPosition);
                    if (bf != null) {
                        return bf.duplicate();
                    }
                    bf = SimpleBinReader.this.readFromDisk(startPosition, endPosition);
                    if (SimpleFileIO.this.compressed) {
                        bf = ByteBuffer.wrap(Util.decompress(bf.array(), bf.position(), bf.limit() - bf.position()));
                    }
                    this.memoryBuffer.add(SimpleFileIO.this.filePath, startPosition, endPosition, bf);
                    this.memoryBufferStat.miss.incrementAndGet();
                    return bf.duplicate();
                });
            }
        }

        private class MemoryDeletedByHighLayer
        implements DeletedByHighLayer {
            private final Set<String> deletedByHighLayerKeySet = ConcurrentHashMap.newKeySet();

            private MemoryDeletedByHighLayer() {
            }

            @Override
            public boolean deletedByHighLayer(BinMeta binMeta) {
                return this.deletedByHighLayerKeySet.contains(binMeta.getKey());
            }

            @Override
            public boolean deletedByHighLayer(String key) {
                return this.deletedByHighLayerKeySet.contains(key);
            }

            @Override
            public boolean add(BinMeta binMeta) {
                return this.add(binMeta.getKey());
            }

            @Override
            public boolean add(String key) {
                return this.deletedByHighLayerKeySet.add(key);
            }

            @Override
            public void close() throws IOException {
                this.deletedByHighLayerKeySet.clear();
            }
        }

        private class EntryIterator
        implements Iterator<Map.Entry<String, BinMetaRef>> {
            final Iterator<Map.Entry<String, BinMetaRef>> sparseIterator;
            private final boolean reversed;
            private final String key;
            Iterator<Map.Entry<String, RegionFormat.ReadableRow>> regionMapIterator;
            BinMetaRef binMetaRef;

            public EntryIterator(Iterator<Map.Entry<String, BinMetaRef>> itMetaRef, boolean reversed, String key) {
                this.reversed = reversed;
                this.key = key;
                this.sparseIterator = itMetaRef;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.regionMapIterator != null && (f = this.regionMapIterator.hasNext())) {
                    return true;
                }
                do lbl-1000:
                // 3 sources

                {
                    this.regionMapIterator = null;
                    this.binMetaRef = null;
                    f = this.sparseIterator.hasNext();
                    if (!f) {
                        return false;
                    }
                    binMetaRef = this.sparseIterator.next().getValue();
                    byteBuffer = SimpleBinReader.this.memoryBufferProxy.read(BinMetaRef.access$1000(binMetaRef), BinMetaRef.access$1100(binMetaRef));
                    rowMap = null;
                    try {
                        rowMap = RegionFormat.read(byteBuffer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (Util.isEmpty(rowMap)) ** GOTO lbl-1000
                    it = rowMap.entrySet().iterator();
                    while (it.hasNext()) {
                        next = it.next();
                        if (this.reversed) {
                            if (!Util.isNotEmpty(this.key) || next.getKey().compareTo(this.key) <= 0) continue;
                            it.remove();
                            continue;
                        }
                        if (!Util.isNotEmpty(this.key) || next.getKey().compareTo(this.key) >= 0) continue;
                        it.remove();
                    }
                } while (Util.isEmpty(rowMap));
                list = new ArrayList<Map.Entry<String, RegionFormat.ReadableRow>>(rowMap.entrySet());
                Collections.reverse(list);
                this.regionMapIterator = this.reversed != false ? list.iterator() : rowMap.entrySet().iterator();
                this.binMetaRef = binMetaRef;
                return true;
            }

            @Override
            public Map.Entry<String, BinMetaRef> next() {
                Map.Entry<String, RegionFormat.ReadableRow> next = this.regionMapIterator.next();
                final String key = next.getKey();
                final BinMetaRef metaRef = SimpleBinReader.this.binMetaRefFromReadableRow0(this.binMetaRef.startPosition, this.binMetaRef.endPosition, next.getValue(), key);
                return new Map.Entry<String, BinMetaRef>(){

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public BinMetaRef getValue() {
                        return metaRef;
                    }

                    @Override
                    public BinMetaRef setValue(BinMetaRef value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        private class DisableDeletedByHighLayer
        implements DeletedByHighLayer {
            private DisableDeletedByHighLayer() {
            }

            @Override
            public boolean deletedByHighLayer(BinMeta binMeta) {
                return false;
            }

            @Override
            public boolean deletedByHighLayer(String key) {
                return false;
            }

            @Override
            public boolean add(BinMeta binMeta) {
                return false;
            }

            @Override
            public boolean add(String key) {
                return false;
            }

            @Override
            public void close() throws IOException {
            }
        }
    }

    private static interface DoInLock<T> {
        public T doInLock();
    }

    private static class FilePutResultImpl
    implements FileIO.FilePutResult {
        private final String key;
        private final long vcc;

        public FilePutResultImpl(String key, long vcc) {
            this.key = key;
            this.vcc = vcc;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public long vcc() {
            return this.vcc;
        }
    }

    private static interface BinWriter
    extends Closeable {
        public BinPutResult put(String var1, Map<String, Object> var2, byte[] var3, long var4);

        public BinPutResult put(String var1, Map<String, Object> var2, ByteBuffer var3, long var4);

        public BinPutResult delete(String var1, long var2);

        public long freeSize();

        public static interface BinPutResult {
            public String key();

            public long vcc();

            public long filePositionPossible();
        }
    }

    static class FileGetResultImpl
    implements FileIO.FileGetResult {
        final boolean deleted;
        final Map<String, Object> meta;
        ByteBuffer byteBuffer;
        final long vcc;
        final String key;
        final String filePath;
        final boolean disk;
        private byte[] data;
        final SimpleFileIO simpleFileIO;
        private boolean dataFetched;

        public FileGetResultImpl(String key, boolean deleted, Map<String, Object> meta, ByteBuffer data, long vcc, String filePath, boolean disk, SimpleFileIO simpleFileIO) {
            this.key = key;
            this.deleted = deleted;
            this.meta = meta;
            this.byteBuffer = data;
            this.vcc = vcc;
            this.filePath = filePath;
            this.disk = disk;
            this.simpleFileIO = simpleFileIO;
        }

        void fetchDataAndReleaseBufferRef() {
            byte[] data = new byte[this.byteBuffer.limit() - this.byteBuffer.position()];
            this.byteBuffer.get(data);
            this.data = data;
            this.byteBuffer = null;
            this.dataFetched = true;
        }

        void releaseBufferRef() {
            this.byteBuffer = null;
            this.dataFetched = false;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        @Override
        public byte[] data() {
            if (!this.dataFetched) {
                throw new UnsupportedOperationException("data is not fetched");
            }
            return this.data;
        }

        public boolean deleted() {
            return this.deleted;
        }

        @Override
        public long vcc() {
            return this.vcc;
        }

        @Override
        public String filePath() {
            return this.filePath;
        }
    }

    static class FileDeleteResultImpl
    implements FileIO.FileDeleteResult {
        private final String key;
        private final long vcc;

        public FileDeleteResultImpl(String key, long vcc) {
            this.key = key;
            this.vcc = vcc;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public long vcc() {
            return this.vcc;
        }
    }

    static interface BinReader {
        public BinMetaGet get(String var1);

        public boolean addDeletedByHighLayer(String var1, long var2);

        public static interface BinMetaGet {
            public BinMeta binMeta();

            public ByteBuffer read();

            public void close();
        }
    }

    static class BinMeta
    implements Model {
        private boolean deleted;
        private long vcc;
        private String key;
        private Map<String, Object> meta;
        int jsonLength;
        int binLength;

        public boolean isDeleted() {
            return this.deleted;
        }

        public long getVcc() {
            return this.vcc;
        }

        public String getKey() {
            return this.key;
        }

        public Map<String, Object> getMeta() {
            return this.meta;
        }

        public int getJsonLength() {
            return this.jsonLength;
        }

        public int getBinLength() {
            return this.binLength;
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }

        public void setVcc(long vcc) {
            this.vcc = vcc;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        public void setJsonLength(int jsonLength) {
            this.jsonLength = jsonLength;
        }

        public void setBinLength(int binLength) {
            this.binLength = binLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BinMeta)) {
                return false;
            }
            BinMeta other = (BinMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDeleted() != other.isDeleted()) {
                return false;
            }
            if (this.getVcc() != other.getVcc()) {
                return false;
            }
            if (this.getJsonLength() != other.getJsonLength()) {
                return false;
            }
            if (this.getBinLength() != other.getBinLength()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BinMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDeleted() ? 79 : 97);
            long $vcc = this.getVcc();
            result = result * 59 + (int)($vcc >>> 32 ^ $vcc);
            result = result * 59 + this.getJsonLength();
            result = result * 59 + this.getBinLength();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        public String toString() {
            return "SimpleFileIO.BinMeta(deleted=" + this.isDeleted() + ", vcc=" + this.getVcc() + ", key=" + this.getKey() + ", meta=" + this.getMeta() + ", jsonLength=" + this.getJsonLength() + ", binLength=" + this.getBinLength() + ")";
        }
    }

    static class SearchContextImpl
    implements FileIO.SearchContext {
        private volatile boolean cancelled;
        List<LayeredFileIO.FileIOProxy> topLayList;

        SearchContextImpl() {
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setTopLayList(List<LayeredFileIO.FileIOProxy> topLayList) {
            this.topLayList = topLayList;
        }

        public List<LayeredFileIO.FileIOProxy> getTopLayList() {
            return this.topLayList;
        }
    }

    static interface DataValidChecker {
        public boolean dataIsValid(FileIO.FileGetResult var1);
    }

    static class MemoryBufferStat {
        long maxBufferSize;
        long splitBufferSize;
        long usedByteSize = 0L;
        long clearCount;
        private final AtomicLong miss = new AtomicLong(0L);
        private final AtomicLong hint = new AtomicLong(0L);
        private double missRate;

        public long getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public long getSplitBufferSize() {
            return this.splitBufferSize;
        }

        public long getUsedByteSize() {
            return this.usedByteSize;
        }

        public long getClearCount() {
            return this.clearCount;
        }

        public AtomicLong getMiss() {
            return this.miss;
        }

        public AtomicLong getHint() {
            return this.hint;
        }

        public double getMissRate() {
            return this.missRate;
        }

        public void setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
        }

        public void setSplitBufferSize(long splitBufferSize) {
            this.splitBufferSize = splitBufferSize;
        }

        public void setUsedByteSize(long usedByteSize) {
            this.usedByteSize = usedByteSize;
        }

        public void setClearCount(long clearCount) {
            this.clearCount = clearCount;
        }

        public void setMissRate(double missRate) {
            this.missRate = missRate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemoryBufferStat)) {
                return false;
            }
            MemoryBufferStat other = (MemoryBufferStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxBufferSize() != other.getMaxBufferSize()) {
                return false;
            }
            if (this.getSplitBufferSize() != other.getSplitBufferSize()) {
                return false;
            }
            if (this.getUsedByteSize() != other.getUsedByteSize()) {
                return false;
            }
            if (this.getClearCount() != other.getClearCount()) {
                return false;
            }
            if (Double.compare(this.getMissRate(), other.getMissRate()) != 0) {
                return false;
            }
            AtomicLong this$miss = this.getMiss();
            AtomicLong other$miss = other.getMiss();
            if (this$miss == null ? other$miss != null : !this$miss.equals(other$miss)) {
                return false;
            }
            AtomicLong this$hint = this.getHint();
            AtomicLong other$hint = other.getHint();
            return !(this$hint == null ? other$hint != null : !this$hint.equals(other$hint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MemoryBufferStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $maxBufferSize = this.getMaxBufferSize();
            result = result * 59 + (int)($maxBufferSize >>> 32 ^ $maxBufferSize);
            long $splitBufferSize = this.getSplitBufferSize();
            result = result * 59 + (int)($splitBufferSize >>> 32 ^ $splitBufferSize);
            long $usedByteSize = this.getUsedByteSize();
            result = result * 59 + (int)($usedByteSize >>> 32 ^ $usedByteSize);
            long $clearCount = this.getClearCount();
            result = result * 59 + (int)($clearCount >>> 32 ^ $clearCount);
            long $missRate = Double.doubleToLongBits(this.getMissRate());
            result = result * 59 + (int)($missRate >>> 32 ^ $missRate);
            AtomicLong $miss = this.getMiss();
            result = result * 59 + ($miss == null ? 43 : $miss.hashCode());
            AtomicLong $hint = this.getHint();
            result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
            return result;
        }

        public String toString() {
            return "SimpleFileIO.MemoryBufferStat(maxBufferSize=" + this.getMaxBufferSize() + ", splitBufferSize=" + this.getSplitBufferSize() + ", usedByteSize=" + this.getUsedByteSize() + ", clearCount=" + this.getClearCount() + ", miss=" + this.getMiss() + ", hint=" + this.getHint() + ", missRate=" + this.getMissRate() + ")";
        }
    }

    static class OperatorImpl
    implements FileIO.Operator {
        OperatorImpl() {
        }

        @Override
        public FileIO.Setter noop() {
            return NoopImpl.NOOP;
        }

        @Override
        public FileIO.Put update() {
            return new PutImpl();
        }

        @Override
        public FileIO.Delete delete() {
            return new DeleteImpl();
        }
    }

    static class NoopImpl
    implements FileIO.Setter {
        static final NoopImpl NOOP = new NoopImpl();

        NoopImpl() {
        }
    }

    static class CompareAndSetResultImpl
    implements FileIO.CompareAndSetResult {
        final FileIO.FilePutResult putResult;
        final FileIO.FileDeleteResult deleteResult;

        public CompareAndSetResultImpl(FileIO.FilePutResult putResult, FileIO.FileDeleteResult deleteResult) {
            this.putResult = putResult;
            this.deleteResult = deleteResult;
        }

        @Override
        public FileIO.FilePutResult updated() {
            return this.putResult;
        }

        @Override
        public FileIO.FileDeleteResult deleted() {
            return this.deleteResult;
        }

        @Override
        public boolean noop() {
            return this.deleteResult == null && this.putResult == null;
        }
    }

    static class PutImpl
    implements FileIO.Put {
        private Map<String, Object> meta;
        private byte[] data;

        @Override
        public FileIO.Put data(byte[] data) {
            this.data = data;
            return this;
        }

        @Override
        public FileIO.Put meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Map<String, Object> getMeta() {
            return this.meta;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PutImpl)) {
                return false;
            }
            PutImpl other = (PutImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            return Arrays.equals(this.getData(), other.getData());
        }

        protected boolean canEqual(Object other) {
            return other instanceof PutImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        public String toString() {
            return "SimpleFileIO.PutImpl(meta=" + this.getMeta() + ", data=" + Arrays.toString(this.getData()) + ")";
        }
    }

    static interface DeletedByHighLayer
    extends Closeable {
        public boolean deletedByHighLayer(BinMeta var1);

        public boolean deletedByHighLayer(String var1);

        public boolean add(BinMeta var1);

        public boolean add(String var1);
    }

    static class DeleteImpl
    implements FileIO.Delete {
        DeleteImpl() {
        }
    }

    private static final class BinFormat {
        public static final int DELETE_LENGTH = 1;
        public static final int V_LENGTH = 4;
        public static final int VCC_LENGTH = 8;

        private BinFormat() {
        }

        public static SharedBufferBinMeta readFromMemory0(ByteBuffer byteBuffer) {
            int position = byteBuffer.position();
            int limit = byteBuffer.limit();
            if (limit - position == 0) {
                return null;
            }
            byte deleted = byteBuffer.get();
            long vcc = byteBuffer.getLong();
            int jsonLength = byteBuffer.getInt();
            int binLength = byteBuffer.getInt();
            byte[] strBytes = new byte[jsonLength];
            byteBuffer.get(strBytes);
            int dataEndPosition = byteBuffer.position() + binLength;
            byteBuffer.position(dataEndPosition);
            String json = new String(strBytes, StandardCharsets.UTF_8).trim();
            SharedBufferBinMeta sharedBufferBinMeta = JSONAccessor.impl().read(json, SharedBufferBinMeta.class);
            sharedBufferBinMeta.setDeleted(deleted == 1);
            sharedBufferBinMeta.setVcc(vcc);
            sharedBufferBinMeta.setJsonLength(jsonLength);
            sharedBufferBinMeta.setBinLength(binLength);
            ByteBuffer b = byteBuffer.duplicate();
            b.position(position + 1 + 8 + 8 + jsonLength);
            b.limit(position + 1 + 8 + 8 + jsonLength + binLength);
            sharedBufferBinMeta.setByteBuffer(b);
            return sharedBufferBinMeta;
        }

        public static BinMeta read(ByteBuffer byteBuffer) {
            int position = byteBuffer.position();
            int limit = byteBuffer.limit();
            if (limit - position == 0) {
                return null;
            }
            byte deleted = byteBuffer.get();
            long vcc = byteBuffer.getLong();
            int jsonLength = byteBuffer.getInt();
            int binLength = byteBuffer.getInt();
            byte[] strBytes = new byte[jsonLength];
            byteBuffer.get(strBytes);
            String json = new String(strBytes, StandardCharsets.UTF_8).trim();
            BinMeta binMeta = JSONAccessor.impl().read(json, BinMeta.class);
            binMeta.setDeleted(deleted == 1);
            binMeta.setVcc(vcc);
            binMeta.setJsonLength(jsonLength);
            binMeta.setBinLength(binLength);
            return binMeta;
        }

        public static ByteBuffer write(boolean deleted, BinMeta binMeta, ByteBuffer data, long vcc) {
            int dataLen = data.limit() - data.position();
            byte[] metaBytes = JSONAccessor.impl().format(binMeta).getBytes(StandardCharsets.UTF_8);
            ByteBuffer byteBuffer = ByteBuffer.allocate(17 + metaBytes.length + dataLen);
            byteBuffer.put((byte)(deleted ? 1 : 0));
            byteBuffer.putLong(vcc);
            byteBuffer.putInt(metaBytes.length);
            byteBuffer.putInt(dataLen);
            byteBuffer.put(metaBytes);
            byteBuffer.put(data);
            return byteBuffer;
        }

        public static ByteBuffer write(boolean deleted, BinMeta binMeta, byte[] data, long vcc) {
            return BinFormat.write(deleted, binMeta, ByteBuffer.wrap(data), vcc);
        }

        static class SharedBufferBinMeta
        extends BinMeta {
            private ByteBuffer byteBuffer;

            public ByteBuffer getByteBuffer() {
                return this.byteBuffer;
            }

            public void setByteBuffer(ByteBuffer byteBuffer) {
                this.byteBuffer = byteBuffer;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SharedBufferBinMeta)) {
                    return false;
                }
                SharedBufferBinMeta other = (SharedBufferBinMeta)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ByteBuffer this$byteBuffer = this.getByteBuffer();
                ByteBuffer other$byteBuffer = other.getByteBuffer();
                return !(this$byteBuffer == null ? other$byteBuffer != null : !((Object)this$byteBuffer).equals(other$byteBuffer));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof SharedBufferBinMeta;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ByteBuffer $byteBuffer = this.getByteBuffer();
                result = result * 59 + ($byteBuffer == null ? 43 : ((Object)$byteBuffer).hashCode());
                return result;
            }

            @Override
            public String toString() {
                return "SimpleFileIO.BinFormat.SharedBufferBinMeta(byteBuffer=" + this.getByteBuffer() + ")";
            }
        }
    }

    private static final class RegionFormat {
        private final Map<String, ByteBufferWrapper> binFormatList = new LinkedHashMap<String, ByteBufferWrapper>();
        long byteSize;

        private RegionFormat() {
        }

        long byteSize() {
            return this.byteSize;
        }

        int write(boolean deleted, String key, long vcc, ByteBuffer byteBuffer) {
            ByteBufferWrapper b = this.binFormatList.put(key, new ByteBufferWrapper(deleted, vcc, byteBuffer));
            this.byteSize = b == null ? (this.byteSize += (long)byteBuffer.array().length) : (this.byteSize += (long)(byteBuffer.array().length - b.byteBuffer.array().length));
            return this.binFormatList.size();
        }

        byte[] toByteArray() {
            int rowCount = this.binFormatList.size();
            int rlSum = 145 * rowCount;
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 + (int)this.byteSize + rlSum);
            byteBuffer.putInt(rowCount);
            for (Map.Entry<String, ByteBufferWrapper> entry : this.binFormatList.entrySet()) {
                String key = entry.getKey();
                ByteBufferWrapper byteBufferWrapper = entry.getValue();
                byte[] bytes = Util.utf8(key);
                byteBuffer.put((byte)(byteBufferWrapper.deleted ? 1 : 0));
                byteBuffer.putInt(bytes.length);
                byteBuffer.put(bytes);
                byteBuffer.putLong(byteBufferWrapper.vcc);
                byteBuffer.putInt(byteBufferWrapper.byteBuffer.array().length);
            }
            for (Map.Entry<String, ByteBufferWrapper> entry : this.binFormatList.entrySet()) {
                ByteBufferWrapper byteBufferWrapper = entry.getValue();
                byteBuffer.put(byteBufferWrapper.byteBuffer.array());
            }
            return byteBuffer.array();
        }

        static LinkedHashMap<String, ReadableRow> read(ByteBuffer byteBuffer) {
            LinkedHashMap<String, ReadableRow> dataMap = new LinkedHashMap<String, ReadableRow>();
            int rowCount = byteBuffer.getInt();
            for (int i = 0; i < rowCount; ++i) {
                byte deleted = byteBuffer.get();
                int keyLen = byteBuffer.getInt();
                String key = Util.utf8(byteBuffer.array(), byteBuffer.position(), keyLen);
                byteBuffer.position(byteBuffer.position() + keyLen);
                long vcc = byteBuffer.getLong();
                int dataLen = byteBuffer.getInt();
                ReadableRow readableRow = new ReadableRow(deleted == 1, vcc, dataLen);
                dataMap.put(key, readableRow);
            }
            int start = byteBuffer.position();
            for (Map.Entry entry : dataMap.entrySet()) {
                ReadableRow readableRow = (ReadableRow)entry.getValue();
                ByteBuffer rowBuffer = byteBuffer.duplicate();
                rowBuffer.position(start);
                int end = start + readableRow.dataLen;
                rowBuffer.limit(end);
                readableRow.byteBuffer = rowBuffer;
                readableRow.startInRegion = start;
                readableRow.endInRegion = end;
                start = end;
            }
            return dataMap;
        }

        class ByteBufferWrapper {
            final boolean deleted;
            final long vcc;
            final ByteBuffer byteBuffer;

            public ByteBufferWrapper(boolean deleted, long vcc, ByteBuffer byteBuffer) {
                this.deleted = deleted;
                this.vcc = vcc;
                this.byteBuffer = byteBuffer;
            }
        }

        static class ReadableRow {
            final boolean deleted;
            final long vcc;
            final int dataLen;
            int startInRegion;
            int endInRegion;
            ByteBuffer byteBuffer;

            public ReadableRow(boolean deleted, long vcc, int dataLen) {
                this.deleted = deleted;
                this.vcc = vcc;
                this.dataLen = dataLen;
            }

            public ByteBuffer getByteBuffer() {
                return this.byteBuffer;
            }
        }
    }
}

