/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared;

import com.ovopark.module.shared.ClientInfo;

public interface Session {
    public static SessionOperation getOrCreate() {
        return SessionOperation.SESSION_OPERATION;
    }

    public int isAccountUser();

    public Integer getIsAgency();

    public Integer getUserId();

    public String getUserName();

    public Integer getGroupId();

    public ClientInfo clientInfo();

    public String backendToken();

    default public boolean isMcp() {
        return false;
    }

    public static class SessionOperation {
        static SessionOperation SESSION_OPERATION = new SessionOperation();
        static ThreadLocal<Session> sessionCache = new ThreadLocal();

        public Session get() {
            return sessionCache.get();
        }

        public void set(Session session) {
            sessionCache.set(session);
        }

        public void remove() {
            sessionCache.remove();
        }
    }
}

