/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.DataCorruptAssert;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AppendLog
extends Closeable {
    public long append(byte[] var1);

    default public void commit() {
        this.fsync();
    }

    public void fsync();

    @Deprecated
    public int freeSize();

    public long freeSize4G();

    public void scan(RowListener var1);

    public String filePath();

    public void advancedScan(long var1, long var3, AdvancedRowListener var5);

    default public boolean compressed() {
        return false;
    }

    public static class StringLogImpl
    implements StringLog {
        private final AppendLog appendLog;
        private StringRegion stringRegion;
        final int fixSize;
        final boolean readonly;

        public StringLogImpl(String filePath, boolean readonly) {
            this(filePath, 100, readonly);
        }

        public StringLogImpl(String filePath, int fixSize, boolean readonly) {
            this.readonly = readonly;
            if (readonly) {
                this.appendLog = new AppendLogFileImpl("log", filePath);
            } else {
                AppendLogConf appendLogConf = new AppendLogConf();
                appendLogConf.setCompressed(true);
                this.appendLog = new BufferedAppendLogImpl("log", filePath, appendLogConf);
            }
            this.fixSize = fixSize;
            this.stringRegion = new StringRegion(this.fixSize);
        }

        @Override
        public synchronized long append(String content) {
            if (this.readonly) {
                throw new UnsupportedOperationException();
            }
            long l = this.flushRegion0(false);
            this.stringRegion.list.add(content);
            return l;
        }

        private long flushRegion0(boolean force) {
            int listSize = this.stringRegion.list.size();
            if (listSize == this.fixSize || force) {
                byte[] bytes = Util.compress(JSONAccessor.impl().formatAsBytes(this.stringRegion));
                long l = this.appendLog.append(bytes);
                this.stringRegion = new StringRegion(this.fixSize);
                return l;
            }
            return ((BufferedAppendLogImpl)this.appendLog).getWritePosition();
        }

        @Override
        public void fsync() {
            if (this.readonly) {
                throw new UnsupportedOperationException();
            }
            this.flushRegion0(true);
            this.appendLog.fsync();
        }

        @Override
        public String filePath() {
            return this.appendLog.filePath();
        }

        @Override
        public void scan(StringLog.StringListener stringListener) {
            this.appendLog.scan((byte[] row, int offset, int length) -> {
                byte[] bytes = Util.decompress(row, offset, length);
                StringRegion region = JSONAccessor.impl().read(bytes, StringRegion.class);
                region.list.forEach(stringListener::onContent);
            });
        }

        @Override
        public void close() throws IOException {
            if (!this.readonly) {
                this.fsync();
            }
            this.appendLog.close();
        }

        static class StringRegion {
            List<String> list;

            public StringRegion(int size) {
                this.list = new ArrayList<String>(size);
            }

            public StringRegion() {
            }

            public List<String> getList() {
                return this.list;
            }

            public void setList(List<String> list) {
                this.list = list;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StringRegion)) {
                    return false;
                }
                StringRegion other = (StringRegion)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$list = this.getList();
                List<String> other$list = other.getList();
                return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
            }

            protected boolean canEqual(Object other) {
                return other instanceof StringRegion;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $list = this.getList();
                result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
                return result;
            }

            public String toString() {
                return "AppendLog.StringLogImpl.StringRegion(list=" + this.getList() + ")";
            }
        }
    }

    public static interface StringLog
    extends Closeable {
        public long append(String var1);

        default public void commit() {
            this.fsync();
        }

        public void fsync();

        public String filePath();

        public void scan(StringListener var1);

        public static interface StringListener {
            public void onContent(String var1);
        }
    }

    public static final class BufferedAppendLogImpl
    extends AppendLogFileImpl {
        private final AppendLogConf appendLogConf;
        private ByteBuffer byteBuffer;
        private long commitTime;
        private final long intervalMilli;
        private int commitRowCount;
        private volatile boolean closed = false;

        public BufferedAppendLogImpl(String tag, String filePath, AppendLogConf appendLogConf) {
            super(tag, filePath, 0x100000L * appendLogConf.getWalDiskSizeMb(), false, appendLogConf.isCompressed());
            this.appendLogConf = appendLogConf;
            this.byteBuffer = ByteBuffer.allocate(0x100000 * appendLogConf.getWalBufferSizeMb());
            this.intervalMilli = TimeUnit.SECONDS.toMillis(appendLogConf.getWalIntervalSec());
        }

        @Override
        public synchronized long append(byte[] bytes) {
            return this.append0(bytes, null);
        }

        private long append0(byte[] bytes, RowCapture rowCapture) {
            if (bytes == null || bytes.length == 0) {
                if (System.currentTimeMillis() - this.commitTime > this.intervalMilli && this.commitRowCount > 0 && !this.closed) {
                    this.commit();
                }
                return 0L;
            }
            if (this.closed) {
                throw new IllegalStateException("closed: " + this.filePath());
            }
            ++this.commitRowCount;
            byte[] rowBufferCache = this.construct(bytes);
            if (this.byteBuffer.limit() - this.byteBuffer.position() < rowBufferCache.length || System.currentTimeMillis() - this.commitTime > this.intervalMilli) {
                this.commit();
            }
            int b = this.byteBuffer.position();
            this.byteBuffer.put(rowBufferCache);
            int a = this.byteBuffer.position();
            if (rowCapture != null) {
                ByteBuffer buffer = this.byteBuffer.duplicate();
                buffer.position(b + 4).limit(a - 8);
                rowCapture.capture(buffer);
            }
            return rowBufferCache.length;
        }

        long appendInternal(byte[] bytes, RowCapture rowCapture) {
            return this.append0(bytes, rowCapture);
        }

        @Override
        public synchronized void commit() {
            this.fsync();
        }

        @Override
        public synchronized void fsync() throws DBOpeException {
            this.fsync0();
            this.byteBuffer = ByteBuffer.allocate(0x100000 * this.appendLogConf.getWalBufferSizeMb());
            this.commitTime = System.currentTimeMillis();
            this.commitRowCount = 0;
        }

        private void fsync0() {
            if (this.byteBuffer.position() == 0) {
                return;
            }
            try {
                super.appendDirect(this.byteBuffer.array(), 0, this.byteBuffer.position());
                super.fsync();
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public int freeSize() {
            int fileFreeSize = super.freeSize();
            return fileFreeSize - this.byteBuffer.position();
        }

        @Override
        public long freeSize4G() {
            long fileFreeSize = super.freeSize4G();
            return fileFreeSize - (long)this.byteBuffer.position();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.fsync();
            }
            finally {
                super.close();
                this.closed = true;
                this.byteBuffer = null;
            }
        }

        void scanOnMemory(AdvancedRowListener advancedRowListener) {
            ByteBuffer memory = this.memory();
            int startPosition = memory.position();
            while (true) {
                int rowLength = memory.getInt();
                memory.position(startPosition + 4 + rowLength);
                long checksum = memory.getLong();
                CRC32 crc32 = new CRC32();
                crc32.update(memory.array(), startPosition, 4 + rowLength);
                long doChecksum = crc32.getValue();
                if (doChecksum != checksum) {
                    throw new IllegalStateException("\u884c\u6570\u636e\u4e0d\u5bf9: " + checksum + "," + doChecksum);
                }
                int endPosition = memory.position();
                advancedRowListener.onRow(memory.array(), startPosition + 4, rowLength, startPosition, endPosition);
                if (endPosition >= memory.limit()) break;
                startPosition = endPosition;
            }
        }

        private ByteBuffer memory() {
            ByteBuffer buffer = this.byteBuffer.duplicate();
            return (ByteBuffer)((Buffer)buffer).limit(buffer.position()).position(0);
        }

        static interface RowCapture {
            public void capture(ByteBuffer var1);
        }
    }

    public static class AppendLogFileImpl
    implements AppendLog {
        private static final Logger log = LoggerFactory.getLogger(AppendLogFileImpl.class);
        private static final int RESERVE_SIZE = 1024;
        static final int CHECK_SUM_LENGTH = 8;
        static final int ROW_LENGTH = 4;
        private final String filePath;
        private final long size;
        private RandomAccessFile accessFile = null;
        private long writePosition;
        private final boolean readonly;
        private volatile boolean closed;
        private final FileHead fileHead;

        public AppendLogFileImpl(String tag, String path) {
            this(tag, path, 0L, true);
        }

        public AppendLogFileImpl(String tag, String path, long size) {
            this(tag, path, size, false);
        }

        public AppendLogFileImpl(String tag, String path, long size, boolean readonly) {
            this(tag, path, size, readonly, false);
        }

        public AppendLogFileImpl(String tag, String path, long size, boolean readonly, boolean compressed) {
            if (Util.isEmpty(tag)) {
                throw new IllegalArgumentException("tag: " + tag);
            }
            if (Util.isEmpty(path)) {
                throw new IllegalArgumentException("path: " + tag);
            }
            if (size > 0x100000000L) {
                throw new IllegalArgumentException("cannot exceed max file size: 4294967296");
            }
            this.filePath = path;
            this.size = size;
            this.readonly = readonly;
            String mode = readonly ? "r" : "rw";
            try {
                File file = new File(this.filePath);
                if (!file.exists()) {
                    this.accessFile = new RandomAccessFile(this.filePath, mode);
                    FileChannel channel = this.accessFile.getChannel();
                    this.fileHead = new FileHead(this.filePath, tag, compressed);
                    ByteBuffer buffer = new FileHeadFormat(this.fileHead).write();
                    channel.write(ByteBuffer.wrap(buffer.array()));
                    channel.force(true);
                    this.writePosition = 1024L;
                } else {
                    this.accessFile = new RandomAccessFile(this.filePath, mode);
                    FileChannel channel = this.accessFile.getChannel();
                    ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                    channel.read(byteBuffer);
                    byteBuffer.flip();
                    this.fileHead = FileHeadFormat.read(byteBuffer);
                    assert (this.fileHead != null);
                    if (!tag.equals(this.fileHead.getTag())) {
                        throw new IllegalStateException("file\u4e0d\u5408\u6cd5: " + this.filePath);
                    }
                    this.accessFile.seek(this.accessFile.length());
                    this.writePosition = this.accessFile.length();
                }
            }
            catch (Exception e) {
                if (this.accessFile != null) {
                    try {
                        this.accessFile.close();
                    }
                    catch (IOException ex) {
                        throw DBOpeException.from(e);
                    }
                }
                throw DBOpeException.from(e);
            }
        }

        @Override
        public synchronized long append(byte[] bytes) {
            byte[] ioBytes = this.construct(bytes);
            try {
                return this.appendDirect(ioBytes);
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        protected synchronized long appendDirect(byte[] bytes) throws IOException {
            return this.appendDirect(bytes, 0, bytes.length);
        }

        protected synchronized long appendDirect(byte[] bytes, int offset, int length) throws IOException {
            if (this.readonly) {
                throw DBOpeException.from("the file is readonly: " + this.filePath);
            }
            this.validateChecksum(bytes, offset, length);
            this.accessFile.seek(this.writePosition);
            this.accessFile.write(bytes, offset, length);
            this.writePosition += (long)length;
            return length;
        }

        private void validateChecksum(byte[] bytes, int offset, int length) {
            try {
                DataCorruptAssert.assertTrue(bytes.length > 0);
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, offset, length);
                int rowOffset = 0;
                while (true) {
                    int rowLength = byteBuffer.getInt();
                    byteBuffer.position(rowOffset + 4 + rowLength);
                    long checksum = byteBuffer.getLong();
                    CRC32 crc32 = new CRC32();
                    crc32.update(bytes, rowOffset, 4 + rowLength);
                    long doChecksum = crc32.getValue();
                    if (doChecksum != checksum) {
                        throw new IllegalStateException("\u884c\u6570\u636e\u4e0d\u5bf9: " + checksum + "," + doChecksum);
                    }
                    if ((rowOffset = rowOffset + 4 + rowLength + 8) < byteBuffer.limit()) {
                        byteBuffer.position(rowOffset);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                File file = new File(this.filePath + ".checksum.error");
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(bytes, offset, length);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        protected final byte[] construct(byte[] bytes) {
            int rowLength = bytes.length;
            ByteBuffer rowByteBuffer = ByteBuffer.allocate(4 + rowLength + 8);
            rowByteBuffer.putInt(rowLength);
            rowByteBuffer.put(bytes);
            CRC32 crc32 = new CRC32();
            crc32.update(rowByteBuffer.array(), 0, 4 + rowLength);
            long checksum = crc32.getValue();
            rowByteBuffer.putLong(checksum);
            return rowByteBuffer.array();
        }

        @Override
        public synchronized int freeSize() {
            return (int)(this.size - this.writePosition - 1024L);
        }

        @Override
        public long freeSize4G() {
            return this.size - this.writePosition - 1024L;
        }

        @Override
        public final synchronized void scan(RowListener rowListener) {
            try {
                this.scan0(rowListener);
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        private void scan0(RowListener rowListener) throws IOException {
            FileChannel channel = this.accessFile.getChannel();
            channel.position(1024L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            int rowLength = 0;
            ByteBuffer rowByteBuffer = null;
            try {
                int read;
                while ((read = channel.read(byteBuffer)) != -1) {
                    if (read != 4) {
                        throw DBOpeException.from("\u6587\u4ef6\u9519\u8bef!!! : " + this.filePath);
                    }
                    byteBuffer.flip();
                    rowLength = byteBuffer.getInt();
                    rowByteBuffer = ByteBuffer.allocate(4 + rowLength + 8);
                    rowByteBuffer.put(byteBuffer.array());
                    channel.read(rowByteBuffer);
                    rowByteBuffer.flip();
                    ByteBuffer slice = rowByteBuffer.slice();
                    slice.position(4 + rowLength);
                    long checksum = slice.getLong();
                    CRC32 crc32 = new CRC32();
                    crc32.update(rowByteBuffer.array(), 0, 4 + rowLength);
                    long doChecksum = crc32.getValue();
                    if (doChecksum != checksum) {
                        throw new IllegalStateException("\u884c\u6570\u636e\u4e0d\u5bf9: " + checksum + "," + doChecksum);
                    }
                    rowListener.onRow(rowByteBuffer.array(), 4, rowLength);
                    byteBuffer = ByteBuffer.allocate(4);
                }
                channel.position(this.writePosition);
            }
            catch (Exception e) {
                log.warn("file read position: " + channel.position() + ", file size: " + channel.size() + ", row: " + (4 + rowLength));
                log.error(e.getMessage(), (Throwable)e);
                throw DBOpeException.from(e);
            }
        }

        @Override
        public void advancedScan(long start, long end, AdvancedRowListener advancedRowListener) {
            try {
                this.advancedScan0(start, end, advancedRowListener);
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        private void advancedScan0(long start, long end, AdvancedRowListener advancedRowListener) throws IOException {
            FileChannel channel = this.accessFile.getChannel();
            channel.position(Math.max(1024L, start));
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            int rowLength = 0;
            ByteBuffer rowByteBuffer = null;
            try {
                int read;
                long rowStartPosition = channel.position();
                while ((read = channel.read(byteBuffer)) != -1) {
                    if (read != 4) {
                        throw DBOpeException.from("\u6587\u4ef6\u9519\u8bef!!! : " + this.filePath);
                    }
                    byteBuffer.flip();
                    rowLength = byteBuffer.getInt();
                    rowByteBuffer = ByteBuffer.allocate(4 + rowLength + 8);
                    rowByteBuffer.put(byteBuffer.array());
                    channel.read(rowByteBuffer);
                    long rowEndPosition = channel.position();
                    if (rowEndPosition > end) {
                        return;
                    }
                    rowByteBuffer.flip();
                    ByteBuffer slice = rowByteBuffer.slice();
                    slice.position(4 + rowLength);
                    long checksum = slice.getLong();
                    CRC32 crc32 = new CRC32();
                    crc32.update(rowByteBuffer.array(), 0, 4 + rowLength);
                    long doChecksum = crc32.getValue();
                    if (doChecksum != checksum) {
                        throw new IllegalStateException("\u884c\u6570\u636e\u4e0d\u5bf9: " + checksum + "," + doChecksum);
                    }
                    advancedRowListener.onRow(rowByteBuffer.array(), 4, rowLength, rowStartPosition, rowEndPosition);
                    rowStartPosition = channel.position();
                    byteBuffer.clear();
                }
                channel.position(this.writePosition);
            }
            catch (Exception e) {
                log.warn("file read position: " + channel.position() + ", file size: " + channel.size() + ", row: " + (4 + rowLength));
                log.error(e.getMessage(), (Throwable)e);
                throw DBOpeException.from(e);
            }
        }

        @Override
        public synchronized void fsync() {
            if (this.readonly) {
                throw DBOpeException.from("the file is readonly: " + this.filePath);
            }
            try {
                this.accessFile.getFD().sync();
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public String filePath() {
            return this.filePath;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                if (!this.readonly) {
                    this.fsync();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.accessFile.close();
                this.closed = true;
            }
        }

        @Override
        public boolean compressed() {
            return this.fileHead.compressed == 1;
        }

        public long getWritePosition() {
            return this.writePosition;
        }

        static class FileHead {
            public static final int size = 1024;
            private String fileName;
            private String tag;
            private long time;
            private byte compressed;

            FileHead() {
            }

            FileHead(String fileName, String tag) {
                this(fileName, tag, false);
            }

            FileHead(String fileName, String tag, boolean compressed) {
                this.tag = tag;
                this.time = System.currentTimeMillis();
                this.fileName = fileName;
                this.compressed = (byte)(compressed ? 1 : 0);
            }

            public String getFileName() {
                return this.fileName;
            }

            public String getTag() {
                return this.tag;
            }

            public long getTime() {
                return this.time;
            }

            public byte getCompressed() {
                return this.compressed;
            }

            public void setFileName(String fileName) {
                this.fileName = fileName;
            }

            public void setTag(String tag) {
                this.tag = tag;
            }

            public void setTime(long time) {
                this.time = time;
            }

            public void setCompressed(byte compressed) {
                this.compressed = compressed;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FileHead)) {
                    return false;
                }
                FileHead other = (FileHead)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getTime() != other.getTime()) {
                    return false;
                }
                if (this.getCompressed() != other.getCompressed()) {
                    return false;
                }
                String this$fileName = this.getFileName();
                String other$fileName = other.getFileName();
                if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                    return false;
                }
                String this$tag = this.getTag();
                String other$tag = other.getTag();
                return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FileHead;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $time = this.getTime();
                result = result * 59 + (int)($time >>> 32 ^ $time);
                result = result * 59 + this.getCompressed();
                String $fileName = this.getFileName();
                result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
                String $tag = this.getTag();
                result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
                return result;
            }

            public String toString() {
                return "AppendLog.AppendLogFileImpl.FileHead(fileName=" + this.getFileName() + ", tag=" + this.getTag() + ", time=" + this.getTime() + ", compressed=" + this.getCompressed() + ")";
            }
        }

        private static final class FileHeadFormat {
            private FileHead fileHead;
            private static final int TAG_LENGTH = 32;
            private static final int FILE_NAME_LENGTH = 128;
            private static final int TIME_LENGTH = 8;

            public FileHeadFormat(FileHead fileHead) {
                this.fileHead = fileHead;
            }

            public FileHeadFormat() {
            }

            public static FileHead read(ByteBuffer byteBuffer) {
                int position = byteBuffer.position();
                int limit = byteBuffer.limit();
                if (limit - position == 0) {
                    return null;
                }
                byte[] strBytes = new byte[32];
                byteBuffer.get(strBytes);
                String tag = new String(strBytes, StandardCharsets.UTF_8).trim();
                strBytes = new byte[128];
                byteBuffer.get(strBytes);
                String fileName = new String(strBytes, StandardCharsets.UTF_8).trim();
                long time = byteBuffer.getLong();
                byte compressed = byteBuffer.get();
                FileHead fileHead = new FileHead();
                fileHead.setTag(tag);
                fileHead.setFileName(fileName);
                fileHead.setTime(time);
                fileHead.setCompressed(compressed);
                return fileHead;
            }

            public ByteBuffer write() {
                int length;
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                byte[] tagBytes = this.fileHead.getTag().getBytes(StandardCharsets.UTF_8);
                for (length = tagBytes.length; length < 32; ++length) {
                    byteBuffer.put((byte)0);
                }
                byteBuffer.put(tagBytes);
                byte[] fileNameBytes = this.fileHead.getFileName().getBytes(StandardCharsets.UTF_8);
                if (length > 128) {
                    throw new IllegalArgumentException("file path is too long: 128");
                }
                for (length = fileNameBytes.length; length < 128; ++length) {
                    byteBuffer.put((byte)0);
                }
                byteBuffer.put(fileNameBytes);
                long time = this.fileHead.getTime();
                byteBuffer.putLong(time);
                byte compressed = this.fileHead.getCompressed();
                byteBuffer.put(compressed);
                return byteBuffer;
            }
        }
    }

    public static class AppendLogConf
    implements Model {
        private int walIntervalSec = 1;
        private int walBufferSizeMb = 10;
        private long walDiskSizeMb = 1024L;
        private boolean compressed = true;

        public int getWalIntervalSec() {
            return this.walIntervalSec;
        }

        public int getWalBufferSizeMb() {
            return this.walBufferSizeMb;
        }

        public long getWalDiskSizeMb() {
            return this.walDiskSizeMb;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public void setWalIntervalSec(int walIntervalSec) {
            this.walIntervalSec = walIntervalSec;
        }

        public void setWalBufferSizeMb(int walBufferSizeMb) {
            this.walBufferSizeMb = walBufferSizeMb;
        }

        public void setWalDiskSizeMb(long walDiskSizeMb) {
            this.walDiskSizeMb = walDiskSizeMb;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendLogConf)) {
                return false;
            }
            AppendLogConf other = (AppendLogConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWalIntervalSec() != other.getWalIntervalSec()) {
                return false;
            }
            if (this.getWalBufferSizeMb() != other.getWalBufferSizeMb()) {
                return false;
            }
            if (this.getWalDiskSizeMb() != other.getWalDiskSizeMb()) {
                return false;
            }
            return this.isCompressed() == other.isCompressed();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppendLogConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWalIntervalSec();
            result = result * 59 + this.getWalBufferSizeMb();
            long $walDiskSizeMb = this.getWalDiskSizeMb();
            result = result * 59 + (int)($walDiskSizeMb >>> 32 ^ $walDiskSizeMb);
            result = result * 59 + (this.isCompressed() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AppendLog.AppendLogConf(walIntervalSec=" + this.getWalIntervalSec() + ", walBufferSizeMb=" + this.getWalBufferSizeMb() + ", walDiskSizeMb=" + this.getWalDiskSizeMb() + ", compressed=" + this.isCompressed() + ")";
        }
    }

    public static interface RowListener {
        public void onRow(byte[] var1, int var2, int var3);
    }

    public static interface AdvancedRowListener {
        public void onRow(byte[] var1, int var2, int var3, long var4, long var6);
    }
}

