/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.delay;

import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheelTimer;
import com.ovopark.kernel.shared.stream.Publisher;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.kernel.shared.stream.Subscription;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingWheel
implements TimingWheelTimer {
    private static final Logger log = LoggerFactory.getLogger(TimingWheel.class);
    private final int wheelSize;
    private final ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock dataSLock = new ReleasableLock(this.dataReadWriteLock.readLock());
    private final ReleasableLock dataXLock = new ReleasableLock(this.dataReadWriteLock.writeLock());
    private final DelayQueue<Bucket> delayQueue = new DelayQueue();
    private final Wheel root;
    private final ExecutorService executorService;
    private final ExecutorService provider;
    private static final boolean DEBUG = Config.ConfigPriority.option().getBoolean("TIMING_WHEEL_DEBUG", false);

    public TimingWheel(String name) {
        this(name, 1, 20);
    }

    public TimingWheel(String name, int tickMs, int wheelSize) {
        this(name, tickMs, wheelSize, 1000);
    }

    public TimingWheel(String name, int tickMs, int wheelSize, int timeoutMs) {
        this(name, tickMs, wheelSize, timeoutMs, null);
    }

    @Deprecated
    public TimingWheel(String name, ExecutorService provider) {
        this(name, 1, 20, 1000, provider);
    }

    @Deprecated
    public TimingWheel(String name, int tickMs, int wheelSize, ExecutorService provider) {
        this(name, tickMs, wheelSize, 1000, provider);
    }

    @Deprecated
    public TimingWheel(String name, int tickMs, int wheelSize, int timeoutMs, ExecutorService provider) {
        this.wheelSize = wheelSize;
        this.root = new Wheel(tickMs, System.currentTimeMillis(), 0);
        this.executorService = Executors.newFixedThreadPool(1, Util.newThreadFactory(name));
        this.provider = provider;
        log.info("create a new time wheel: " + name + ",basic tickMs(ms): " + tickMs + ", wheelSize: " + wheelSize);
        this.executorService.execute(Util.catchRunnable(() -> {
            while (true) {
                try {
                    while (true) {
                        if (!this.advanceClock(timeoutMs) || !DEBUG) {
                            continue;
                        }
                        log.debug("found expired bucket: " + name);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }));
    }

    @Override
    public void shutdown() throws Exception {
        try {
            this.executorService.shutdown();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.root.shutdown();
    }

    @Override
    public void delay(DelayTask delayTask) {
        this.dataSLock.acquire();
        try {
            this.add0(delayTask);
        }
        finally {
            this.dataSLock.unlock();
        }
    }

    private void add0(DelayTask delayTask) {
        if (!this.root.add(delayTask)) {
            Runnable caughtRunnable = Util.catchRunnable(() -> delayTask.task().run());
            if (this.provider == null) {
                caughtRunnable.run();
            } else {
                this.provider.execute(caughtRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean advanceClock(long timeoutMs) throws InterruptedException {
        Bucket bucket = (Bucket)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket != null) {
            this.dataXLock.acquire();
            try {
                if (DEBUG) {
                    log.info("poll bucket: [" + bucket.wheel.level + ":" + bucket.index + "]");
                }
                while (bucket != null) {
                    DelayTask delayTask;
                    this.root.advanceClock(bucket.getExpirationMs().get());
                    int size = bucket.size();
                    for (int i = 0; i < size && (delayTask = bucket.poll()) != null; ++i) {
                        this.add0(delayTask);
                    }
                    bucket = (Bucket)this.delayQueue.poll();
                    if (bucket == null || !DEBUG) continue;
                    log.info("available: [" + bucket.wheel.level + ":" + bucket.index + "]");
                }
            }
            finally {
                this.dataXLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int size = 0;
        Wheel tmp = this.root;
        while (tmp != null) {
            size += (int)tmp.taskCount.get();
            tmp = tmp.overflowWheel;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(Consumer<DelayTask> delayTaskConsumer, int size) {
        this.dataXLock.acquire();
        try {
            int scanSize = 0;
            Wheel tmp = this.root;
            while (tmp != null) {
                for (Bucket bucket : tmp.buckets) {
                    for (DelayTask delayTask : bucket.delayTaskLinkedList) {
                        if (++scanSize > size) {
                            return;
                        }
                        delayTaskConsumer.accept(delayTask);
                    }
                }
                scanSize += (int)tmp.taskCount.get();
                tmp = tmp.overflowWheel;
            }
        }
        finally {
            this.dataXLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimingWheelTimer.SearchResult search(TimingWheelTimer.SearchPredicate searchPredicate) {
        TimingWheelTimer.SearchResult searchResult = new TimingWheelTimer.SearchResult();
        this.dataXLock.acquire();
        try {
            searchResult.setDelayTaskList(new ArrayList<DelayTask>());
            int scanSize = 0;
            Wheel tmp = this.root;
            while (tmp != null) {
                for (Bucket bucket : tmp.buckets) {
                    for (DelayTask delayTask : bucket.delayTaskLinkedList) {
                        ++scanSize;
                        if (searchPredicate.test(delayTask)) {
                            searchResult.getDelayTaskList().add(delayTask);
                        }
                        if (!searchPredicate.breakTest()) continue;
                        searchResult.setScanSize(scanSize);
                        TimingWheelTimer.SearchResult searchResult2 = searchResult;
                        return searchResult2;
                    }
                }
                tmp = tmp.overflowWheel;
            }
            searchResult.setScanSize(scanSize);
            TimingWheelTimer.SearchResult searchResult3 = searchResult;
            return searchResult3;
        }
        finally {
            this.dataXLock.unlock();
        }
    }

    @Override
    public Stream<DelayTask> stream() {
        return Stream.from(new Publisher<DelayTask>(){

            @Override
            public void subscribe(final Subscriber<? super DelayTask> subscriber) {
                Subscription subscription = new Subscription(){
                    volatile boolean cancelled;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void request(long n) {
                        TimingWheel.this.dataXLock.acquire();
                        try {
                            int scanSize = 0;
                            Wheel tmp = TimingWheel.this.root;
                            while (tmp != null) {
                                if (this.cancelled) {
                                    return;
                                }
                                for (Bucket bucket : tmp.buckets) {
                                    if (this.cancelled) {
                                        return;
                                    }
                                    for (DelayTask delayTask : bucket.delayTaskLinkedList) {
                                        if (this.cancelled) {
                                            return;
                                        }
                                        if ((long)(++scanSize) > n) {
                                            return;
                                        }
                                        subscriber.onNext(delayTask);
                                    }
                                }
                                tmp = tmp.overflowWheel;
                            }
                            if (this.cancelled) {
                                return;
                            }
                            subscriber.onComplete();
                        }
                        finally {
                            TimingWheel.this.dataXLock.unlock();
                        }
                    }

                    @Override
                    public void cancel() {
                        this.cancelled = true;
                        log.info("cancel");
                    }
                };
                subscriber.onSubscribe(subscription);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimingWheelTimer.TimingWheelStat stat() {
        this.dataXLock.acquire();
        try {
            TimingWheelTimer.TimingWheelStat timingWheelStat = new TimingWheelTimer.TimingWheelStat();
            timingWheelStat.setWheelSize(this.wheelSize);
            ArrayList<TimingWheelTimer.WheelStat> wheelStatList = new ArrayList<TimingWheelTimer.WheelStat>();
            TimingWheelTimer.WheelStat wheelStat = this.wheelStat(this.root, 0);
            wheelStatList.add(wheelStat);
            Wheel tmp = this.root;
            while (tmp.overflowWheel != null) {
                TimingWheelTimer.WheelStat stat = this.wheelStat(tmp.overflowWheel, tmp.overflowWheel.level);
                wheelStatList.add(stat);
                tmp = tmp.overflowWheel;
            }
            timingWheelStat.setWheelStatList(wheelStatList);
            TimingWheelTimer.TimingWheelStat timingWheelStat2 = timingWheelStat;
            return timingWheelStat2;
        }
        finally {
            this.dataXLock.unlock();
        }
    }

    private TimingWheelTimer.WheelStat wheelStat(Wheel wheel, int level) {
        TimingWheelTimer.WheelStat wheelStat = new TimingWheelTimer.WheelStat();
        wheelStat.setLevel(level);
        wheelStat.setStartMs(wheel.startMs);
        wheelStat.setTickMs(wheel.tickMs);
        wheelStat.setInterval(wheel.interval);
        wheelStat.setCurrentTime(wheel.currentTime);
        wheelStat.setCurrentTimeStr(Util.formatTime(Util.dateTime(wheelStat.getCurrentTime()), "yyyy-MM-dd HH:mm:ss.SSS"));
        wheelStat.setStartMsStr(Util.formatTime(Util.dateTime(wheelStat.getStartMs()), "yyyy-MM-dd HH:mm:ss.SSS"));
        wheelStat.setEndMsStr(Util.formatTime(Util.dateTime(wheelStat.getStartMs() + wheelStat.getInterval()), "yyyy-MM-dd HH:mm:ss.SSS"));
        wheelStat.setSumTaskCount(wheel.taskCount.get());
        ArrayList<TimingWheelTimer.BucketStat> bucketStatList = new ArrayList<TimingWheelTimer.BucketStat>();
        for (Bucket bucket : wheel.buckets) {
            TimingWheelTimer.BucketStat bucketStat = new TimingWheelTimer.BucketStat();
            bucketStat.setSize(bucket.size());
            bucketStatList.add(bucketStat);
        }
        wheelStat.setBucketStatList(bucketStatList);
        return wheelStat;
    }

    private class Wheel {
        private final long startMs;
        private final long tickMs;
        private final long interval;
        private volatile long currentTime;
        private final AtomicLong taskCount = new AtomicLong(0L);
        private final Bucket[] buckets;
        private Wheel overflowWheel;
        private final int level;

        public Wheel(long tickMs, long startMs, int level) {
            this.tickMs = tickMs;
            this.startMs = startMs;
            this.interval = tickMs * (long)TimingWheel.this.wheelSize;
            this.buckets = new Bucket[TimingWheel.this.wheelSize];
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Bucket(i, this);
            }
            this.currentTime = startMs;
            this.level = level;
        }

        boolean add(DelayTask delayTask) {
            long triggerTime = delayTask.triggerTimeMs();
            if (triggerTime < this.currentTime + this.tickMs) {
                return false;
            }
            if (triggerTime < this.currentTime + this.interval) {
                long virtualId = triggerTime / this.tickMs;
                Bucket bucket = this.buckets[(int)(virtualId % (long)TimingWheel.this.wheelSize)];
                bucket.add(delayTask);
                if (bucket.setExpirationMs(virtualId * this.tickMs)) {
                    TimingWheel.this.delayQueue.offer(bucket);
                }
                return true;
            }
            if (this.level > 7) {
                log.warn("adjust tickMs=1ms\uff0cwheelSize=20 , to include larger time: " + delayTask.taskId() + "(" + Util.formatTime(Util.dateTime(triggerTime), new String[0]) + "), wheel time from " + this.currentTime + " > " + (this.currentTime + this.interval));
                throw new IllegalArgumentException(delayTask.taskId() + ": " + Util.formatTime(Util.dateTime(triggerTime), new String[0]) + ", exceed max level(" + this.level + "): " + Util.formatTime(Util.dateTime(this.currentTime), new String[0]) + " > " + Util.formatTime(Util.dateTime(this.currentTime + this.interval), new String[0]));
            }
            if (this.overflowWheel == null) {
                this.overflowWheel = new Wheel(this.interval, this.currentTime, this.level + 1);
            }
            return this.overflowWheel.add(delayTask);
        }

        void advanceClock(long timeMs) {
            if (timeMs >= this.currentTime + this.tickMs) {
                long preCurrentTime = this.currentTime;
                this.currentTime = timeMs - timeMs % this.tickMs;
                if (DEBUG) {
                    log.info("wheel(" + this.level + ") currentTime: " + preCurrentTime + " -> " + this.currentTime);
                }
                if (this.overflowWheel != null) {
                    this.overflowWheel.advanceClock(this.currentTime);
                }
            }
        }

        void shutdown() {
            for (Bucket bucket : this.buckets) {
                bucket.shutdown();
            }
            if (this.overflowWheel != null) {
                this.overflowWheel.shutdown();
            }
        }
    }

    private class Bucket
    implements Delayed {
        final int index;
        final Wheel wheel;
        private final AtomicLong expirationMs = new AtomicLong(-1L);
        private final LinkedList<DelayTask> delayTaskLinkedList = new LinkedList();
        private final ReentrantLock lock = new ReentrantLock();

        public Bucket(int index, Wheel wheel) {
            this.index = index;
            this.wheel = wheel;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expirationMs.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.expirationMs.get(), ((Bucket)o).expirationMs.get());
        }

        void add(DelayTask delayTask) {
            this.lock.lock();
            try {
                this.delayTaskLinkedList.add(delayTask);
                this.wheel.taskCount.incrementAndGet();
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean setExpirationMs(long expirationMs) {
            long preValue = this.expirationMs.getAndSet(expirationMs);
            if (preValue != expirationMs) {
                if (DEBUG) {
                    log.info("bucket[" + this.wheel.level + ":" + this.index + "](" + this.wheel.currentTime + ") changed: " + preValue + " -> " + expirationMs + ", rest size: " + this.size());
                }
                return true;
            }
            return false;
        }

        synchronized DelayTask poll() {
            this.lock.lock();
            try {
                DelayTask delayTask = this.delayTaskLinkedList.poll();
                if (delayTask != null) {
                    this.wheel.taskCount.decrementAndGet();
                }
                DelayTask delayTask2 = delayTask;
                return delayTask2;
            }
            finally {
                this.lock.unlock();
            }
        }

        int size() {
            this.lock.lock();
            try {
                int n = this.delayTaskLinkedList.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        void shutdown() {
            this.delayTaskLinkedList.clear();
        }

        public AtomicLong getExpirationMs() {
            return this.expirationMs;
        }
    }
}

