/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.stream.log;

import com.ovopark.kernel.shared.Util;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Trace {
    private static final String TRACE = " [TRACE:%s:%s] ";
    private static final String TRACE_PATTERN = ".+(\\s\\[TRACE:%s:([^\\]]*)\\]\\s).+";
    private final String placeholder;
    private final String placeholderPattern;
    private final Pattern pattern;
    private static final String FULL_CONTENT = " [TRACE:FULL_CONTENT] ";
    private static final String FULL_CONTENT_PATTERN = ".+(\\s\\[TRACE:FULL_CONTENT\\]\\s).+";
    private static final Trace FULL_CONTENT_TRACE = new Trace(" [TRACE:FULL_CONTENT] ", ".+(\\s\\[TRACE:FULL_CONTENT\\]\\s).+");
    private static final String IGNORE = " [TRACE:IGNORE] ";
    private static final String IGNORE_PATTERN = ".+(\\s\\[TRACE:IGNORE\\]\\s).+";
    private static final Trace IGNORE_TRACE = new Trace(" [TRACE:IGNORE] ", ".+(\\s\\[TRACE:IGNORE\\]\\s).+");
    private static final Trace URL_TRACE = Trace.from("URL");
    private static final Trace DATA_SIZE_TRACE = Trace.from("SIZE");

    private Trace(String tag) {
        this(String.format(TRACE, tag, "%s"), String.format(TRACE_PATTERN, tag));
    }

    private Trace(String placeholder, String placeholderPattern) {
        this.placeholder = placeholder;
        this.placeholderPattern = placeholderPattern;
        this.pattern = Pattern.compile(placeholderPattern);
    }

    public static Trace from(String tag) {
        return new Trace(tag);
    }

    public static Trace fullContent() {
        return FULL_CONTENT_TRACE;
    }

    public static Trace ignore() {
        return IGNORE_TRACE;
    }

    public static Trace url() {
        return URL_TRACE;
    }

    static Trace size() {
        return DATA_SIZE_TRACE;
    }

    public static boolean ignore(String content) {
        return Trace.ignore().matches(content);
    }

    public static String content(String content) {
        Result result = Trace.size().parse(content);
        if (result.matches()) {
            String matchPart = result.matchPart();
            String trace = result.trace();
            String c = content.substring(content.lastIndexOf(matchPart) + matchPart.length() + Integer.valueOf(trace));
            return c;
        }
        return null;
    }

    private String tagText(String ... traceId) {
        return String.format(this.placeholder, traceId);
    }

    public Tag tag(String ... traceId) {
        return new TagImpl(this, traceId);
    }

    public Tag tag(String traceId) {
        return new TagImpl(this, new String[]{traceId});
    }

    public Result parse(String content) {
        Matcher matcher = this.pattern.matcher(content);
        if (matcher.matches()) {
            if (matcher.groupCount() == 1) {
                return new ResultImpl(true, null, matcher.group(1));
            }
            if (matcher.groupCount() > 1) {
                return new ResultImpl(true, matcher.group(2), matcher.group(1));
            }
        }
        return new ResultImpl(false, null, null);
    }

    public boolean matches(String content) {
        return this.pattern.matcher(content).matches();
    }

    public static interface Result {
        public boolean matches();

        public String trace();

        public String matchPart();

        public TracePart parse(String var1);

        default public TracePart parse() {
            return this.parse(":");
        }
    }

    private static class TagImpl
    implements Tag {
        private final Trace trace;
        private final String[] traceId;
        private TagImpl parent;

        public TagImpl(Trace trace, String[] traceId) {
            this.trace = trace;
            this.traceId = traceId;
        }

        @Override
        public Tag link(Tag t) {
            if (t == null) {
                return this;
            }
            if (((TagImpl)t).parent != null) {
                throw new IllegalStateException();
            }
            ((TagImpl)t).parent = this;
            return t;
        }

        private String trace0() {
            if (this.parent != null) {
                return this.parent.trace0() + this.trace.tagText(this.traceId);
            }
            return this.trace.tagText(this.traceId);
        }

        @Override
        public String trace(String content) {
            String tag = (this.parent == null ? "" : this.parent.trace0()) + this.trace.tagText(this.traceId);
            return " > " + Trace.size().tagText(new String[]{"" + (tag.length() + 1)}) + tag + " " + content;
        }
    }

    private static class ResultImpl
    implements Result {
        private final boolean matches;
        private final String traceId;
        private final String matchPart;

        public ResultImpl(boolean matches, String traceId, String matchPart) {
            this.matches = matches;
            this.traceId = traceId;
            this.matchPart = matchPart;
        }

        @Override
        public boolean matches() {
            return this.matches;
        }

        @Override
        public String trace() {
            return this.traceId;
        }

        @Override
        public String matchPart() {
            return this.matchPart;
        }

        @Override
        public TracePart parse(String split) {
            if (!this.matches || Util.isEmpty(this.traceId)) {
                return null;
            }
            return new TracePartImpl(split, this.traceId);
        }
    }

    private static class TracePartImpl
    implements TracePart {
        private final String split;
        private final String part;

        TracePartImpl(String split, String part) {
            this.split = split;
            this.part = part;
        }

        @Override
        public String split() {
            return this.split;
        }

        @Override
        public String trace() {
            return this.part;
        }

        @Override
        public String[] parts() {
            return this.part.split(this.split);
        }

        @Override
        public TracePart next(String traceId) {
            return new TracePartImpl(this.split, this.part + this.split + traceId);
        }

        @Override
        public TracePart next(String ... traceId) {
            return new TracePartImpl(this.split, this.part + this.split + String.join((CharSequence)this.split, traceId));
        }

        @Override
        public boolean lk(String traceId) {
            return this.part.contains(traceId);
        }

        @Override
        public boolean lk(int level, String traceId) {
            return this.op(level, p -> p != null && p.contains(traceId));
        }

        private <T> T op(int level, Function<String, T> func) {
            String[] parts = this.parts();
            if (level < parts.length) {
                String p = parts[level];
                return func.apply(p);
            }
            return func.apply(null);
        }

        @Override
        public boolean eq(String traceId) {
            return this.part.contains(this.split + traceId + this.split);
        }

        @Override
        public boolean eq(int level, String traceId) {
            return this.op(level, p -> p != null && p.equals(traceId));
        }

        @Override
        public TracePart parent() {
            String[] parts = this.parts();
            if (parts.length > 1) {
                return new TracePartImpl(this.split, String.join((CharSequence)this.split, Arrays.copyOfRange(parts, 0, parts.length - 1)));
            }
            return null;
        }

        @Override
        public TracePart root() {
            String[] parts = this.parts();
            if (parts.length > 0) {
                return new TracePartImpl(this.split, parts[0]);
            }
            return null;
        }

        @Override
        public String part() {
            String[] parts = this.parts();
            return parts[parts.length - 1];
        }

        @Override
        public int level() {
            String[] parts = this.parts();
            return parts.length - 1;
        }

        @Override
        public Iterator<String> iterator() {
            final String[] parts = this.parts();
            return new Iterator(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < parts.length;
                }

                public String next() {
                    return parts[this.index++];
                }
            };
        }
    }

    public static interface TracePart
    extends Iterable<String> {
        public String split();

        public String[] parts();

        public String trace();

        public TracePart next(String var1);

        public TracePart next(String ... var1);

        public boolean lk(String var1);

        public boolean lk(int var1, String var2);

        public boolean eq(String var1);

        public boolean eq(int var1, String var2);

        public TracePart parent();

        public TracePart root();

        public String part();

        public int level();
    }

    public static interface Tag {
        public Tag link(Tag var1);

        public String trace(String var1);
    }
}

