package com.ovopark.module.shared.es7x;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public interface ElasticsearchManager {


    String writeIndex(String alias);

    String writeIndex(String alias,boolean refresh);

    List<String> backingIndex(String alias, int limit);

    List<String> backingIndex(String alias, int limit, boolean refresh);

    List<String> backingIndex(String alias, Comparator<String> comparator, int limit);

    List<String> backingIndex(String alias, Comparator<String> comparator, int limit, boolean refresh);

    List<String> backingIndex(String alias, Predicate<String> filter );

    List<String> backingIndex(String alias, Predicate<String> filter, boolean refresh);

    Entry get(String alias,String key);

    interface AliasIndexRefreshListener{

        Entry on(String alias, List<ElasticsearchOperations.AliasIndex> aliasIndexList);

    }

    @Data
    class Alias implements Model {

        private String alias;

        private BackingIndex write;

        private List<BackingIndex> backingIndexList;

        private Map<String,Entry> entryMap=new ConcurrentHashMap<>();

    }

    @Data
    class BackingIndex implements Model {

        private String index;

        private boolean write;

    }

    @Data
    class Entry{

        String key;

        Object object;

    }
}
