package com.ovopark.module.shared.es7x;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

abstract public class ElasticsearchManagerProxy implements ElasticsearchManager{

    
    abstract protected ElasticsearchManager manager();

    @Override
    public String writeIndex(String alias) {
        return manager().writeIndex(alias);
    }

    @Override
    public String writeIndex(String alias, boolean refresh) {
        return manager().writeIndex(alias,refresh);
    }

    @Override
    public List<String> backingIndex(String alias, int limit) {
        return manager().backingIndex(alias,limit);
    }

    @Override
    public List<String> backingIndex(String alias, int limit, boolean refresh) {
        return manager().backingIndex(alias,limit,refresh);
    }

    @Override
    public List<String> backingIndex(String alias, Comparator<String> comparator, int limit) {
        return manager().backingIndex(alias,comparator,limit);
    }

    @Override
    public List<String> backingIndex(String alias, Comparator<String> comparator, int limit, boolean refresh) {
        return manager().backingIndex(alias,comparator,limit,refresh);
    }

    @Override
    public List<String> backingIndex(String alias, Predicate<String> filter) {
        return manager().backingIndex(alias,filter);
    }

    @Override
    public List<String> backingIndex(String alias, Predicate<String> filter, boolean refresh) {
        return manager().backingIndex(alias,filter,refresh);
    }

    @Override
    public Entry get(String alias, String key) {
        return manager().get(alias,key);
    }
}
