package com.ovopark.module.shared.es7x;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.kv.CacheService;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

import static com.ovopark.kernel.shared.Util.isEmpty;
import static com.ovopark.kernel.shared.Util.log;

public class SimpleElasticsearchManager implements ElasticsearchManager{

    private final ElasticsearchOperations elasticsearchOperations;

    final private Comparator<String> comparator;

    final private List<AliasIndexRefreshListener> aliasIndexRefreshListenerList;

    public SimpleElasticsearchManager(ElasticsearchOperations elasticsearchOperations,Comparator<String> comparator,List<AliasIndexRefreshListener> aliasIndexRefreshListenerList) {
        this.elasticsearchOperations = elasticsearchOperations;
        this.comparator=comparator;
        this.aliasIndexRefreshListenerList=isEmpty(aliasIndexRefreshListenerList)?List.of():aliasIndexRefreshListenerList;
    }

    final private CacheService<String,Object> C=new CacheService.MapCacheService<>(true, new CacheService.MapCacheService.RemovedCallBack() {
        @Override
        public void call(CacheService.MapCacheService.Entry entry, long l, long l1, long l2) {

        }
    });

    @Override
    public String writeIndex(String alias) {
        return writeIndex(alias,false);
    }

    @Override
    public String writeIndex(String alias, boolean refresh) {
        Alias als = refreshAlias(alias, refresh);
        return als.getWrite().getIndex();
    }

    protected Alias refreshAlias(String alias, boolean refresh) {
        Alias als = (Alias) C.updateAndGet("writeIndex:" + alias, new Function<Object, Object>() {
            @Override
            public Object apply(Object s) {
                if (refresh || s == null) {
                    Alias als = new Alias();
                    List<ElasticsearchOperations.AliasIndex> aliasIndexList = elasticsearchOperations.backingIndex(alias);
                    List<BackingIndex> backingIndexList = new ArrayList<>(aliasIndexList.size());
                    BackingIndex write = null;
                    for (ElasticsearchOperations.AliasIndex aliasIndex : aliasIndexList) {
                        BackingIndex backingIndex = new BackingIndex();
                        backingIndex.setIndex(aliasIndex.getIndex());
                        backingIndex.setWrite(aliasIndex.isWrite());
                        backingIndexList.add(backingIndex);
                        if (aliasIndex.isWrite()) {
                            write = backingIndex;
                            log.info("found write index, refresh alias: " + alias + ", write index: " + backingIndex.getIndex());
                        }
                    }
                    als.setWrite(write);
                    backingIndexList.sort((o1, o2) -> comparator.compare(o1.getIndex(),o2.getIndex()));
                    als.setBackingIndexList(backingIndexList);
                    s = als;
                    log.info("refresh alias: " + alias + ", write index: "
                            + (als.getWrite()==null?null:als.getWrite().getIndex())
                            +", limit : "+ JSONAccessor.impl().format(backingIndexList.stream().limit(2).toList()));
                    for (AliasIndexRefreshListener aliasIndexRefreshListener : aliasIndexRefreshListenerList) {
                        try {
                            Entry entry = aliasIndexRefreshListener.on(alias, aliasIndexList);
                            if (entry==null) {
                                continue;
                            }
                            als.getEntryMap().put(entry.getKey(),entry);
                        } catch (Exception e) {
                            log.error(e.getMessage(),e);
                        }
                    }
                }
                return s;
            }
        }, 1, TimeUnit.SECONDS);
        return als;
    }

    @Override
    public List<String> backingIndex(String alias, int limit) {
        return backingIndex(alias,limit,false);
    }

    @Override
    public List<String> backingIndex(String alias, int limit, boolean refresh) {
        Alias als = refreshAlias(alias, refresh);
        return als.getBackingIndexList().stream()
                .map(BackingIndex::getIndex)
                .limit(limit)
                .toList()
                ;
    }

    @Override
    public List<String> backingIndex(String alias, Comparator<String> comparator, int limit) {
        return backingIndex(alias,comparator,limit,false);
    }

    @Override
    public List<String> backingIndex(String alias, Comparator<String> comparator, int limit, boolean refresh) {
        Alias als = refreshAlias(alias, refresh);
        return als.getBackingIndexList().stream()
                .map(BackingIndex::getIndex)
                .sorted(comparator)
                .limit(limit)
                .toList()
                ;
    }

    @Override
    public List<String> backingIndex(String alias, Predicate<String> filter) {
        return backingIndex(alias,filter,false);
    }

    @Override
    public List<String> backingIndex(String alias, Predicate<String> filter, boolean refresh) {
        Alias als = refreshAlias(alias, refresh);
        return als.getBackingIndexList().stream()
                .map(BackingIndex::getIndex)
                .filter(filter)
                .toList()
                ;
    }

    @Override
    public Entry get(String alias, String key) {
        Alias als = refreshAlias(alias, false);
        if (als==null) {
            return null;
        }
        return als.getEntryMap().get(key);
    }
}
