package com.ovopark.module.shared.es7x;

import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.Model;

import java.io.Serializable;

public interface Document<T extends Serializable>  extends Model {

    String ES_PREFIX= Config.ConfigPriority.option().getString("OVOPARK_ES_INDEX_PREFIX","");

    T id();

    void id(T id);

    void id(String id);

    void docIndexName(String index);

    default void ver(long ver){}

    default void primaryTerm(long primaryTerm){}

    default long primaryTerm(){return -1L;}

    default void seqNo(long seqNo){}

    default long seqNo(){return -1L;}

}
