/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.es7x;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.es7x.ElasticsearchManager;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import com.ovopark.module.shared.es7x.ElasticsearchOperationsImpl;
import com.ovopark.module.shared.es7x.ElasticsearchProperties;
import com.ovopark.module.shared.es7x.SimpleElasticsearchManager;
import com.ovopark.module.shared.es7x.SimpleILMElasticsearchManager;
import com.ovopark.module.shared.es7x.SpringElasticsearchManager;
import com.ovopark.module.shared.es7x.SpringILMElasticsearchManager;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class ElasticsearchConfig {
    @Bean(value={"ES_JSONAccessor"})
    public JSONAccessor esJSONAccessor() {
        final ObjectMapper objectMapper = new ObjectMapper();
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new JsonSerializer<LocalDateTime>(this){

            public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeNumber(value.toInstant(Util.GMT_08).toEpochMilli());
            }
        });
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JsonDeserializer<LocalDateTime>(this){

            public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                long longValue = p.getLongValue();
                return Util.dateTime((long)longValue);
            }
        });
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        objectMapper.registerModule((Module)javaTimeModule).registerModule((Module)new ParameterNamesModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return new JSONAccessor(){

            public String format(Object object) {
                try {
                    return objectMapper.writeValueAsString(object);
                }
                catch (JsonProcessingException e) {
                    throw Util.convert2RuntimeException((Throwable)e);
                }
            }

            public <T> T read(String text, Class<T> type) {
                try {
                    return (T)objectMapper.readValue(text.getBytes(StandardCharsets.UTF_8), type);
                }
                catch (IOException e) {
                    throw Util.convert2RuntimeException((Throwable)e);
                }
            }

            public <T> T read(String text, final JSONAccessor.TypeReference<T> typeReference) {
                try {
                    return (T)objectMapper.readValue(text.getBytes(StandardCharsets.UTF_8), new TypeReference<T>(this){

                        public Type getType() {
                            return typeReference.getType();
                        }
                    });
                }
                catch (IOException e) {
                    throw Util.convert2RuntimeException((Throwable)e);
                }
            }

            public Map read(String text) {
                return this.read(text, Map.class);
            }
        };
    }

    @Bean
    public RestHighLevelClient elasticsearchClient(final ElasticsearchProperties elasticsearchProperties) {
        List<String> uris = elasticsearchProperties.getUris();
        HttpHost[] httpHosts = uris.stream().map(uri -> new HttpHost(uri.split(":")[0], Integer.parseInt(uri.split(":")[1]))).toList().toArray(new HttpHost[0]);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(elasticsearchProperties.getUsername(), elasticsearchProperties.getPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                return httpClientBuilder;
            }
        });
        RestHighLevelClient restHighLevelClient = new RestHighLevelClient(restClientBuilder);
        return restHighLevelClient;
    }

    @Bean
    public ElasticsearchOperations elasticsearchOperations() {
        return new ElasticsearchOperationsImpl();
    }

    @Primary
    @Bean
    public SpringElasticsearchManager springElasticsearchManager(ElasticsearchOperations elasticsearchOperations, List<ElasticsearchManager.AliasIndexRefreshListener> aliasIndexRefreshListenerList) {
        SimpleElasticsearchManager simpleElasticsearchManager = new SimpleElasticsearchManager(elasticsearchOperations, Comparator.naturalOrder(), aliasIndexRefreshListenerList);
        return new SpringElasticsearchManager(simpleElasticsearchManager);
    }

    @Bean
    public SpringILMElasticsearchManager springILMElasticsearchManager(ElasticsearchOperations elasticsearchOperations, List<ElasticsearchManager.AliasIndexRefreshListener> aliasIndexRefreshListenerList) {
        SimpleILMElasticsearchManager simpleILMElasticsearchManager = new SimpleILMElasticsearchManager(elasticsearchOperations, aliasIndexRefreshListenerList);
        return new SpringILMElasticsearchManager(simpleILMElasticsearchManager);
    }
}

