/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.es7x;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticsearchOperationsImpl
implements ElasticsearchOperations {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchOperationsImpl.class);
    @Autowired
    private RestHighLevelClient elasticsearchClient;
    @Resource(name="ES_JSONAccessor")
    private JSONAccessor jsonAccessor;

    @Override
    public <T extends Serializable> void save(String index, Document<T> model) {
        block4: {
            try {
                boolean idIsNull = model.id() == null;
                IndexResponse indexResponse = this.elasticsearchClient.index(new IndexRequest(index).source(this.jsonAccessor.read(this.jsonAccessor.format(model))).id(idIsNull ? null : String.valueOf(model.id())), RequestOptions.DEFAULT);
                DocWriteResponse.Result result = indexResponse.getResult();
                if (result == DocWriteResponse.Result.CREATED) {
                    model.id(indexResponse.getId());
                    model.docIndexName(indexResponse.getIndex());
                    model.ver(indexResponse.getVersion());
                    model.seqNo(indexResponse.getSeqNo());
                    model.primaryTerm(indexResponse.getPrimaryTerm());
                    break block4;
                }
                if (result == DocWriteResponse.Result.UPDATED || result == DocWriteResponse.Result.NOOP) {
                    model.docIndexName(indexResponse.getIndex());
                    model.ver(indexResponse.getVersion());
                    model.seqNo(indexResponse.getSeqNo());
                    model.primaryTerm(indexResponse.getPrimaryTerm());
                    break block4;
                }
                throw new IllegalStateException("create error: " + JSONAccessor.impl().format(model));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public <T extends Serializable> ElasticsearchOperations.BulkSaveResponse bulkSave(String index, List<? extends Document<T>> modelList) {
        BulkRequest bulkRequest = new BulkRequest();
        for (Document<T> document : modelList) {
            boolean idIsNull = document.id() == null;
            IndexRequest indexRequest = new IndexRequest(index).source(this.jsonAccessor.read(this.jsonAccessor.format(document))).id(idIsNull ? null : String.valueOf(document.id()));
            bulkRequest.add(indexRequest);
        }
        ElasticsearchOperations.BulkSaveResponse bulkSaveResponse = new ElasticsearchOperations.BulkSaveResponse();
        try {
            BulkResponse bulkResponse = this.elasticsearchClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            BulkItemResponse[] items = bulkResponse.getItems();
            for (int i = 0; i < items.length; ++i) {
                BulkItemResponse item = items[i];
                if (item.getFailure() != null) {
                    bulkSaveResponse.fail(i);
                    continue;
                }
                bulkSaveResponse.success(i, item.getId(), item.getIndex());
                modelList.get(i).id(item.getId());
                modelList.get(i).docIndexName(item.getIndex());
            }
            return bulkSaveResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public <T extends Serializable> void update(String index, Document<T> model) {
        this.update0(index, model, false);
    }

    private <T extends Serializable> void update0(String index, Document<T> model, boolean upsert) {
        if (!upsert && model.id() == null) {
            throw new RuntimeException("id is missing: null , index: " + index);
        }
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.id(model.id() == null ? null : String.valueOf(model.id()));
        updateRequest.index(index);
        if (upsert) {
            updateRequest.doc(this.jsonAccessor.read(this.jsonAccessor.format(model)));
            updateRequest.docAsUpsert(true);
        } else {
            updateRequest.doc(this.jsonAccessor.read(this.jsonAccessor.format(model)));
        }
        updateRequest.retryOnConflict(3);
        if (model.primaryTerm() > 0L) {
            updateRequest.setIfPrimaryTerm(model.primaryTerm());
        }
        if (model.seqNo() > 0L) {
            updateRequest.setIfSeqNo(model.seqNo());
        }
        try {
            UpdateResponse response = this.elasticsearchClient.update(updateRequest, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = response.getResult();
            if (result == DocWriteResponse.Result.NOT_FOUND) {
                throw new RuntimeException("id is missing: " + String.valueOf(model.id()) + " , index: " + index);
            }
            if (result == DocWriteResponse.Result.CREATED) {
                model.docIndexName(response.getIndex());
                model.primaryTerm(response.getPrimaryTerm());
                model.seqNo(response.getSeqNo());
                model.ver(response.getVersion());
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
        catch (VersionConflictEngineException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ElasticsearchException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public <T extends Serializable> void upsert(String index, Document<T> model) {
        this.update0(index, model, true);
    }

    @Override
    public void updatePartOfDoc(String index, String id, Map<String, Object> data) {
        if (Util.isEmpty((CharSequence)id)) {
            throw new RuntimeException("id is missing: null , index: " + index);
        }
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.id(id);
        updateRequest.index(index);
        updateRequest.doc(data);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse response = this.elasticsearchClient.update(updateRequest, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = response.getResult();
            if (result == DocWriteResponse.Result.NOT_FOUND) {
                throw new RuntimeException("id is missing: " + id + " , index: " + index);
            }
            if (result == DocWriteResponse.Result.CREATED) {
                return;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
        catch (VersionConflictEngineException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ElasticsearchException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public void updatePartOfDoc(String index, String id, Supplier<Script> scriptSupplier) {
        block4: {
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.id(id);
            updateRequest.index(index);
            updateRequest.script(scriptSupplier.get());
            updateRequest.retryOnConflict(3);
            try {
                UpdateResponse response = this.elasticsearchClient.update(updateRequest, RequestOptions.DEFAULT);
                DocWriteResponse.Result result = response.getResult();
                if (result == DocWriteResponse.Result.NOT_FOUND) {
                    throw new RuntimeException("id is missing: " + id + " , index: " + index);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException((Throwable)e);
            }
            catch (ElasticsearchException e) {
                if (e.status() != RestStatus.NOT_FOUND) break block4;
                throw new RuntimeException("id is missing: " + id + " , index: " + index);
            }
        }
    }

    @Override
    public void updatePartOfDocInMultiIndex(String id, Supplier<Script> scriptSupplier, String ... alias) {
        if (Util.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("id is empty: " + id);
        }
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(alias);
        updateByQueryRequest.setQuery((QueryBuilder)new TermQueryBuilder("_id", id));
        updateByQueryRequest.setScript(scriptSupplier.get());
        updateByQueryRequest.setConflicts("proceed");
        try {
            BulkByScrollResponse response = this.elasticsearchClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
            if (response.isTimedOut()) {
                throw new RuntimeException("timeout: " + id);
            }
            List searchFailures = response.getSearchFailures();
            List bulkFailures = response.getBulkFailures();
            if (Util.isNotEmpty((Collection)searchFailures)) {
                ScrollableHitSource.SearchFailure first = (ScrollableHitSource.SearchFailure)searchFailures.getFirst();
                log.error(String.valueOf(first.getStatus()) + " , searchFailures: " + first.getNodeId() + ":" + first.getShardId() + ":" + first.getIndex(), (Object)first);
            }
            if (Util.isNotEmpty((Collection)bulkFailures)) {
                throw new RuntimeException("update error: " + id);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ElasticsearchOperations.BulkUpdateResponse updatePartOfDocInMultiIndex(List<String> idList, Supplier<Script> scriptSupplier, String ... alias) {
        if (Util.isEmpty(idList)) {
            throw new IllegalArgumentException("id is empty");
        }
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(alias);
        updateByQueryRequest.setQuery((QueryBuilder)QueryBuilders.termsQuery((String)"_id", idList));
        updateByQueryRequest.setScript(scriptSupplier.get());
        updateByQueryRequest.setConflicts("proceed");
        try {
            BulkByScrollResponse response = this.elasticsearchClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
            if (response.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            ElasticsearchOperations.BulkUpdateResponse bulkUpdateResponse = new ElasticsearchOperations.BulkUpdateResponse();
            List searchFailures = response.getSearchFailures();
            List bulkFailures = response.getBulkFailures();
            if (Util.isNotEmpty((Collection)searchFailures)) {
                ScrollableHitSource.SearchFailure first = (ScrollableHitSource.SearchFailure)searchFailures.getFirst();
                log.error(String.valueOf(first.getStatus()) + " , searchFailures: " + first.getNodeId() + ":" + first.getShardId() + ":" + first.getIndex(), (Object)first);
            }
            for (BulkItemResponse.Failure failure : bulkFailures) {
                bulkUpdateResponse.fail(failure.getId());
            }
            return bulkUpdateResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ElasticsearchOperations.BulkUpdateResponse updatePartOfDocInMultiIndex(Supplier<BoolQueryBuilder> querySupplier, Supplier<Script> scriptSupplier, String ... alias) {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(alias);
        updateByQueryRequest.setQuery((QueryBuilder)querySupplier.get());
        updateByQueryRequest.setScript(scriptSupplier.get());
        updateByQueryRequest.setConflicts("proceed");
        try {
            BulkByScrollResponse response = this.elasticsearchClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
            if (response.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            ElasticsearchOperations.BulkUpdateResponse bulkUpdateResponse = new ElasticsearchOperations.BulkUpdateResponse();
            List searchFailures = response.getSearchFailures();
            List bulkFailures = response.getBulkFailures();
            if (Util.isNotEmpty((Collection)searchFailures)) {
                ScrollableHitSource.SearchFailure first = (ScrollableHitSource.SearchFailure)searchFailures.getFirst();
                log.error(String.valueOf(first.getStatus()) + " , searchFailures: " + first.getNodeId() + ":" + first.getShardId() + ":" + first.getIndex(), (Object)first);
            }
            for (BulkItemResponse.Failure failure : bulkFailures) {
                bulkUpdateResponse.fail(failure.getId());
            }
            return bulkUpdateResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ElasticsearchOperations.BulkDeleteResponse deleteDocInMultiIndex(Supplier<BoolQueryBuilder> querySupplier, String ... alias) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(alias);
        deleteByQueryRequest.setQuery((QueryBuilder)querySupplier.get());
        deleteByQueryRequest.setConflicts("proceed");
        try {
            BulkByScrollResponse response = this.elasticsearchClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            if (response.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            ElasticsearchOperations.BulkDeleteResponse bulkDeleteResponse = new ElasticsearchOperations.BulkDeleteResponse();
            List searchFailures = response.getSearchFailures();
            List bulkFailures = response.getBulkFailures();
            if (Util.isNotEmpty((Collection)searchFailures)) {
                ScrollableHitSource.SearchFailure first = (ScrollableHitSource.SearchFailure)searchFailures.getFirst();
                log.error(String.valueOf(first.getStatus()) + " , searchFailures: " + first.getNodeId() + ":" + first.getShardId() + ":" + first.getIndex(), (Object)first);
            }
            for (BulkItemResponse.Failure failure : bulkFailures) {
                bulkDeleteResponse.fail(failure.getId());
            }
            return bulkDeleteResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ElasticsearchOperations.BulkUpdateResponse updatePartOfDocInMultiIndex(UpdateByQueryRequest updateByQueryRequest) {
        try {
            updateByQueryRequest.setConflicts("proceed");
            BulkByScrollResponse response = this.elasticsearchClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
            if (response.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            ElasticsearchOperations.BulkUpdateResponse bulkUpdateResponse = new ElasticsearchOperations.BulkUpdateResponse();
            bulkUpdateResponse.setTotal(response.getTotal());
            bulkUpdateResponse.setUpdated(response.getUpdated());
            bulkUpdateResponse.setVersionConflicts(response.getVersionConflicts());
            List searchFailures = response.getSearchFailures();
            List bulkFailures = response.getBulkFailures();
            if (Util.isNotEmpty((Collection)searchFailures)) {
                ScrollableHitSource.SearchFailure first = (ScrollableHitSource.SearchFailure)searchFailures.getFirst();
                log.error(String.valueOf(first.getStatus()) + " , searchFailures: " + first.getNodeId() + ":" + first.getShardId() + ":" + first.getIndex(), (Object)first);
            }
            for (BulkItemResponse.Failure failure : bulkFailures) {
                bulkUpdateResponse.fail(failure.getId());
            }
            return bulkUpdateResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ElasticsearchOperations.BulkDeleteResponse bulkDeleteInMultiIndex(List<String> ids, String ... alias) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(alias);
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.termsQuery((String)"_id", ids));
        deleteByQueryRequest.setConflicts("proceed");
        try {
            BulkByScrollResponse response = this.elasticsearchClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            if (response.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            ElasticsearchOperations.BulkDeleteResponse bulkDeleteResponse = new ElasticsearchOperations.BulkDeleteResponse();
            List searchFailures = response.getSearchFailures();
            List bulkFailures = response.getBulkFailures();
            if (Util.isNotEmpty((Collection)searchFailures)) {
                ScrollableHitSource.SearchFailure first = (ScrollableHitSource.SearchFailure)searchFailures.getFirst();
                log.error(String.valueOf(first.getStatus()) + " , searchFailures: " + first.getNodeId() + ":" + first.getShardId() + ":" + first.getIndex(), (Object)first);
            }
            if (Util.isNotEmpty((Collection)bulkFailures)) {
                for (BulkItemResponse.Failure bulkFailure : bulkFailures) {
                    bulkDeleteResponse.fail(bulkFailure.getId());
                }
            }
            return bulkDeleteResponse;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public <M extends Document<?>> M get(String index, String id, Class<M> model) {
        GetRequest getRequest = new GetRequest(index, id);
        try {
            GetResponse response = this.elasticsearchClient.get(getRequest, RequestOptions.DEFAULT);
            if (response.isExists()) {
                String source = response.getSourceAsString();
                Document read = (Document)this.jsonAccessor.read(source, model);
                read.id(response.getId());
                return (M)read;
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public <M extends Document<?>> M getInMultiIndex(String id, Class<M> model, String ... alias) {
        SearchRequest searchRequest = new SearchRequest(alias);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)id));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        List<M> list = this.list(searchRequest, model);
        return (M)(Util.isEmpty(list) ? null : (Document)list.getFirst());
    }

    @Override
    public <M extends Document<?>> List<M> list(SearchRequest searchRequest, Class<M> model) {
        try {
            SearchResponse searchResponse = this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            RestStatus status = searchResponse.status();
            if (status != RestStatus.OK) {
                throw new RuntimeException("error: " + String.valueOf(status));
            }
            SearchHits hits = searchResponse.getHits();
            ArrayList<Document> list = new ArrayList<Document>();
            for (SearchHit hit : hits) {
                String source = hit.getSourceAsString();
                Document read = (Document)this.jsonAccessor.read(source, model);
                read.id(hit.getId());
                read.docIndexName(hit.getIndex());
                read.ver(hit.getVersion());
                read.seqNo(hit.getSeqNo());
                read.primaryTerm(hit.getPrimaryTerm());
                list.add(read);
            }
            return list;
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public <M extends Document<?>> PageModel<M> page(SearchRequest searchRequest, Class<M> model) {
        try {
            SearchResponse searchResponse = this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            RestStatus status = searchResponse.status();
            if (status != RestStatus.OK) {
                throw new RuntimeException("error: " + String.valueOf(status));
            }
            SearchHits hits = searchResponse.getHits();
            ArrayList<Document> list = new ArrayList<Document>();
            for (SearchHit hit : hits) {
                String source = hit.getSourceAsString();
                Document read = (Document)this.jsonAccessor.read(source, model);
                read.id(hit.getId());
                read.docIndexName(hit.getIndex());
                read.ver(hit.getVersion());
                read.seqNo(hit.getSeqNo());
                read.primaryTerm(hit.getPrimaryTerm());
                list.add(read);
            }
            PageModel pageModel = new PageModel();
            pageModel.setTotal(hits.getTotalHits().value);
            pageModel.setData(list);
            return pageModel;
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public long count(CountRequest countRequest) {
        try {
            CountResponse countResponse = this.elasticsearchClient.count(countRequest, RequestOptions.DEFAULT);
            RestStatus status = countResponse.status();
            if (status != RestStatus.OK) {
                throw new RuntimeException("error: " + String.valueOf(status));
            }
            return countResponse.getCount();
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) {
        try {
            SearchResponse searchResponse = this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.isTimedOut()) {
                throw new RuntimeException("timeout");
            }
            RestStatus status = searchResponse.status();
            if (status != RestStatus.OK) {
                throw new RuntimeException("error: " + String.valueOf(status));
            }
            return searchResponse;
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ElasticsearchOperations.BulkDeleteResponse bulkDelete(String index, List<String> ids) {
        BulkRequest bulkRequest = new BulkRequest();
        for (String id : ids) {
            bulkRequest.add(new DeleteRequest(index, id));
        }
        try {
            BulkItemResponse[] items;
            ElasticsearchOperations.BulkDeleteResponse bulkDeleteResponse = new ElasticsearchOperations.BulkDeleteResponse();
            BulkResponse bulkResponse = this.elasticsearchClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            for (BulkItemResponse item : items = bulkResponse.getItems()) {
                if (item.getFailure() == null) continue;
                bulkDeleteResponse.fail(item.getId());
            }
            return bulkDeleteResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public List<ElasticsearchOperations.AliasIndex> backingIndex(String alias) {
        ArrayList<ElasticsearchOperations.AliasIndex> aliasIndexList = new ArrayList<ElasticsearchOperations.AliasIndex>();
        try {
            GetAliasesRequest getAliasesRequest = new GetAliasesRequest();
            getAliasesRequest.aliases(new String[]{alias});
            GetAliasesResponse aliasesResponse = this.elasticsearchClient.indices().getAlias(getAliasesRequest, RequestOptions.DEFAULT);
            Map aliases = aliasesResponse.getAliases();
            for (Map.Entry entry : aliases.entrySet()) {
                String index = (String)entry.getKey();
                ElasticsearchOperations.AliasIndex aliasIndex = new ElasticsearchOperations.AliasIndex();
                aliasIndex.setIndex(index);
                for (AliasMetadata aliasMetadata : (Set)entry.getValue()) {
                    if (aliasMetadata.writeIndex() == null || !aliasMetadata.writeIndex().booleanValue()) continue;
                    aliasIndex.setWrite(true);
                }
                aliasIndexList.add(aliasIndex);
            }
            return aliasIndexList;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public SearchResponse scroll(SearchScrollRequest searchScrollRequest) {
        try {
            return this.elasticsearchClient.scroll(searchScrollRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest) {
        try {
            return this.elasticsearchClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    @Override
    public String format(Object object) {
        return this.jsonAccessor.format(object);
    }

    @Override
    public Map<String, Object> read(String json) {
        return this.jsonAccessor.read(json);
    }

    @Override
    public Map<String, Object> convert(Object object) {
        return this.read(this.format(object));
    }
}

