package com.ovopark.module.shared.es7x;

import com.ovopark.module.shared.PageModel;
import lombok.Data;
import org.elasticsearch.action.search.*;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface ElasticsearchOperations {

    /**
     * PUT : _doc RT
     * @param index
     * @param model
     * @param <T>
     */
    <T extends Serializable> void save(String index, Document<T> model);

    /**
     * PUT : _doc RT
     * @param index
     * @param modelList
     * @param <T>
     */
    <T extends Serializable> BulkSaveResponse bulkSave(String index, List<? extends Document<T>> modelList);

    /**
     * PUT : _doc RT
     * @param index
     * @param model
     * @param <T>
     */
    <T extends Serializable> void update(String index, Document<T> model);

    /**
     * PUT : _doc RT
     * @param index
     * @param model
     * @param <T>
     */
    <T extends Serializable> void upsert(String index, Document<T> model);

    /**
     * PUT : _doc RT
     * @param index
     * @param id
     * @param data
     */
    void updatePartOfDoc(String index, String id, Map<String,Object> data);



    /**
     * _update RT
     * @param index
     * @param id
     * @param scriptSupplier
     */
    void updatePartOfDoc(String index,String id, Supplier<Script> scriptSupplier);

    /**
     * _update_by_query NRT
     *
     * @param id
     * @param scriptSupplier
     * @param alias
     */
    void updatePartOfDocInMultiIndex(String id, Supplier<Script> scriptSupplier, String... alias);


    /**
     * _update_by_query NRT
     *
     * @param idList
     * @param scriptSupplier
     * @param alias
     */
    BulkUpdateResponse updatePartOfDocInMultiIndex(List<String> idList, Supplier<Script> scriptSupplier, String... alias);

    /**
     * _update_by_query NRT
     *
     * @param scriptSupplier
     * @param alias
     */
    BulkUpdateResponse updatePartOfDocInMultiIndex(Supplier<BoolQueryBuilder> querySupplier, Supplier<Script> scriptSupplier, String... alias);


    /**
     * _update_by_query NRT
     * @param updateByQueryRequest
     */
    BulkUpdateResponse updatePartOfDocInMultiIndex(UpdateByQueryRequest updateByQueryRequest);


    /**
     * _delete_by_query NRT
     *
     * @param ids
     * @param alias
     * @return
     */
    BulkDeleteResponse bulkDeleteInMultiIndex(List<String> ids, String... alias);

    /**
     * _delete_by_query NRT
     *
     * @param alias
     */
    BulkDeleteResponse deleteDocInMultiIndex(Supplier<BoolQueryBuilder> querySupplier, String... alias);

    /**
     * GET: _doc RT
     * @param index real index , not an alias !!!
     * @param id
     * @param model
     * @return
     * @param <M>
     */
    <M extends Document<?>> M get(String index, String id,Class<M> model);

    /**
     * GET: _mget RT
     * @param indexOrAlias real index  /  alias
     * @param model
     * @param ids
     * @return
     * @param <M>
     */
    <M extends Document<?>> BulkGetResponse<M> mget(String indexOrAlias, Class<M> model, String... ids);

    /**
     * _search NRT
     *
     * @param <M>
     * @param id
     * @param model
     * @param alias
     * @return
     */
    <M extends Document<?>> M getInMultiIndex(String id, Class<M> model, String... alias);

    String format(Object object);

    Map<String,Object> read(String json);

    Map<String,Object> convert(Object object);

    <M extends Document<?>> List<M> list(SearchRequest searchRequest,Class<M> model);

    <M extends Document<?>> PageModel<M> page(SearchRequest searchRequest,Class<M> model);

    long count(CountRequest countRequest);

    SearchResponse search(SearchRequest searchRequest);

    /**
     * DELETE: _doc RT
     * @param index
     * @param ids
     */
    BulkDeleteResponse bulkDelete(String index, List<String> ids);

    List<AliasIndex> backingIndex(String alias);

    SearchResponse scroll(SearchScrollRequest searchScrollRequest);

    ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest);

    @Data
    class AliasIndex{

        private String index;

        private boolean write;

    }

    @Data
    class BulkSaveResponse{

        List<Integer> fail=new ArrayList<>();

        Map<Integer,String> success=new HashMap<>();

        Map<Integer,String> docIndexNameMap=new HashMap<>();

        public void success(int index, String id){
            success.put(index,id);
        }

        public void success(int index, String id,String docIndexName){
            success(index,id);
            docIndexNameMap.put(index,docIndexName);
        }

        public void fail(int index){
            fail.add(index);
        }

    }

    @Data
    class BulkUpdateResponse{

        private long total;

        private long updated;

        private long versionConflicts;

        List<String> fail=new ArrayList<>();

        public void fail(String id){
            fail.add(id);
        }
    }

    @Data
    class BulkDeleteResponse{

        List<String> fail=new ArrayList<>();

        public void fail(String id){
            fail.add(id);
        }
    }

    @Data
    class BulkGetResponse<M>{

        List<String> fail=new ArrayList<>();

        List<M> list;

    }

}
