/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.es7x;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.module.shared.es7x.ElasticsearchManager;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public class SimpleElasticsearchManager
implements ElasticsearchManager {
    private final ElasticsearchOperations elasticsearchOperations;
    private final Comparator<String> comparator;
    private final List<ElasticsearchManager.AliasIndexRefreshListener> aliasIndexRefreshListenerList;
    private final CacheService<String, Object> C = new CacheService.MapCacheService(true, new CacheService.MapCacheService.RemovedCallBack(this){

        public void call(CacheService.MapCacheService.Entry entry, long l, long l1, long l2) {
        }
    });

    public SimpleElasticsearchManager(ElasticsearchOperations elasticsearchOperations, Comparator<String> comparator, List<ElasticsearchManager.AliasIndexRefreshListener> aliasIndexRefreshListenerList) {
        this.elasticsearchOperations = elasticsearchOperations;
        this.comparator = comparator;
        this.aliasIndexRefreshListenerList = Util.isEmpty(aliasIndexRefreshListenerList) ? List.of() : aliasIndexRefreshListenerList;
    }

    @Override
    public String writeIndex(String alias) {
        return this.writeIndex(alias, false);
    }

    @Override
    public String writeIndex(String alias, boolean refresh) {
        ElasticsearchManager.Alias als = this.refreshAlias(alias, refresh);
        return als.getWrite().getIndex();
    }

    protected ElasticsearchManager.Alias refreshAlias(final String alias, final boolean refresh) {
        ElasticsearchManager.Alias als = (ElasticsearchManager.Alias)this.C.updateAndGet((Comparable)((Object)("writeIndex:" + alias)), (Function)new Function<Object, Object>(){

            @Override
            public Object apply(Object s) {
                if (refresh || s == null) {
                    ElasticsearchManager.Alias als = new ElasticsearchManager.Alias();
                    List<ElasticsearchOperations.AliasIndex> aliasIndexList = SimpleElasticsearchManager.this.elasticsearchOperations.backingIndex(alias);
                    ArrayList<ElasticsearchManager.BackingIndex> backingIndexList = new ArrayList<ElasticsearchManager.BackingIndex>(aliasIndexList.size());
                    ElasticsearchManager.BackingIndex write = null;
                    for (ElasticsearchOperations.AliasIndex aliasIndex : aliasIndexList) {
                        ElasticsearchManager.BackingIndex backingIndex = new ElasticsearchManager.BackingIndex();
                        backingIndex.setIndex(aliasIndex.getIndex());
                        backingIndex.setWrite(aliasIndex.isWrite());
                        backingIndexList.add(backingIndex);
                        if (!aliasIndex.isWrite()) continue;
                        write = backingIndex;
                        Util.log.info("found write index, refresh alias: " + alias + ", write index: " + backingIndex.getIndex());
                    }
                    als.setWrite(write);
                    backingIndexList.sort((o1, o2) -> SimpleElasticsearchManager.this.comparator.compare(o1.getIndex(), o2.getIndex()));
                    als.setBackingIndexList(backingIndexList);
                    s = als;
                    Util.log.info("refresh alias: " + alias + ", write index: " + (als.getWrite() == null ? null : als.getWrite().getIndex()) + ", limit : " + JSONAccessor.impl().format(backingIndexList.stream().limit(2L).toList()));
                    for (ElasticsearchManager.AliasIndexRefreshListener aliasIndexRefreshListener : SimpleElasticsearchManager.this.aliasIndexRefreshListenerList) {
                        try {
                            ElasticsearchManager.Entry entry = aliasIndexRefreshListener.on(alias, aliasIndexList);
                            if (entry == null) continue;
                            als.getEntryMap().put(entry.getKey(), entry);
                        }
                        catch (Exception e) {
                            Util.log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                return s;
            }
        }, 1L, TimeUnit.SECONDS);
        return als;
    }

    @Override
    public List<String> backingIndex(String alias, int limit) {
        return this.backingIndex(alias, limit, false);
    }

    @Override
    public List<String> backingIndex(String alias, int limit, boolean refresh) {
        ElasticsearchManager.Alias als = this.refreshAlias(alias, refresh);
        return als.getBackingIndexList().stream().map(ElasticsearchManager.BackingIndex::getIndex).limit(limit).toList();
    }

    @Override
    public List<String> backingIndex(String alias, Comparator<String> comparator, int limit) {
        return this.backingIndex(alias, comparator, limit, false);
    }

    @Override
    public List<String> backingIndex(String alias, Comparator<String> comparator, int limit, boolean refresh) {
        ElasticsearchManager.Alias als = this.refreshAlias(alias, refresh);
        return als.getBackingIndexList().stream().map(ElasticsearchManager.BackingIndex::getIndex).sorted(comparator).limit(limit).toList();
    }

    @Override
    public List<String> backingIndex(String alias, Predicate<String> filter) {
        return this.backingIndex(alias, filter, false);
    }

    @Override
    public List<String> backingIndex(String alias, Predicate<String> filter, boolean refresh) {
        ElasticsearchManager.Alias als = this.refreshAlias(alias, refresh);
        return als.getBackingIndexList().stream().map(ElasticsearchManager.BackingIndex::getIndex).filter(filter).toList();
    }

    @Override
    public ElasticsearchManager.Entry get(String alias, String key) {
        ElasticsearchManager.Alias als = this.refreshAlias(alias, false);
        if (als == null) {
            return null;
        }
        return als.getEntryMap().get(key);
    }
}

