/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.es7x;

import com.ovopark.kernel.shared.OnlyTest;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.es7x.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;

public interface ElasticsearchOperations {
    public <T extends Serializable> void save(String var1, Document<T> var2);

    public <T extends Serializable> BulkSaveResponse bulkSave(String var1, List<? extends Document<T>> var2);

    public <T extends Serializable> void update(String var1, Document<T> var2);

    public <T extends Serializable> void upsert(String var1, Document<T> var2);

    public void updatePartOfDoc(String var1, String var2, Map<String, Object> var3);

    public void updatePartOfDoc(String var1, String var2, Supplier<Script> var3);

    public void updatePartOfDocInMultiIndex(String var1, Supplier<Script> var2, String ... var3);

    public BulkUpdateResponse updatePartOfDocInMultiIndex(List<String> var1, Supplier<Script> var2, String ... var3);

    public BulkUpdateResponse updatePartOfDocInMultiIndex(Supplier<BoolQueryBuilder> var1, Supplier<Script> var2, String ... var3);

    public BulkUpdateResponse updatePartOfDocInMultiIndex(UpdateByQueryRequest var1);

    public BulkDeleteResponse bulkDeleteInMultiIndex(List<String> var1, String ... var2);

    public BulkDeleteResponse deleteDocInMultiIndex(Supplier<BoolQueryBuilder> var1, String ... var2);

    public <M extends Document<?>> M get(String var1, String var2, Class<M> var3);

    @OnlyTest
    public <M extends Document<?>> BulkGetResponse<M> mget(String var1, Class<M> var2, String ... var3);

    public <M extends Document<?>> M getInMultiIndex(String var1, Class<M> var2, String ... var3);

    public String format(Object var1);

    public Map<String, Object> read(String var1);

    public Map<String, Object> convert(Object var1);

    public <M extends Document<?>> List<M> list(SearchRequest var1, Class<M> var2);

    public <M extends Document<?>> PageModel<M> page(SearchRequest var1, Class<M> var2);

    public long count(CountRequest var1);

    public SearchResponse search(SearchRequest var1);

    public BulkDeleteResponse bulkDelete(String var1, List<String> var2);

    public List<AliasIndex> backingIndex(String var1);

    public SearchResponse scroll(SearchScrollRequest var1);

    public ClearScrollResponse clearScroll(ClearScrollRequest var1);

    public boolean createIndexAtTemplate(String var1);

    public boolean deleteIndexIfExists(String var1);

    public static class BulkGetResponse<M> {
        List<String> fail = new ArrayList<String>();
        List<M> list;

        public List<String> getFail() {
            return this.fail;
        }

        public List<M> getList() {
            return this.list;
        }

        public void setFail(List<String> fail) {
            this.fail = fail;
        }

        public void setList(List<M> list) {
            this.list = list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkGetResponse)) {
                return false;
            }
            BulkGetResponse other = (BulkGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$fail = this.getFail();
            List<String> other$fail = other.getFail();
            if (this$fail == null ? other$fail != null : !((Object)this$fail).equals(other$fail)) {
                return false;
            }
            List<M> this$list = this.getList();
            List<M> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulkGetResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $fail = this.getFail();
            result = result * 59 + ($fail == null ? 43 : ((Object)$fail).hashCode());
            List<M> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchOperations.BulkGetResponse(fail=" + String.valueOf(this.getFail()) + ", list=" + String.valueOf(this.getList()) + ")";
        }
    }

    public static class BulkDeleteResponse {
        List<String> fail = new ArrayList<String>();

        public void fail(String id) {
            this.fail.add(id);
        }

        public List<String> getFail() {
            return this.fail;
        }

        public void setFail(List<String> fail) {
            this.fail = fail;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkDeleteResponse)) {
                return false;
            }
            BulkDeleteResponse other = (BulkDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$fail = this.getFail();
            List<String> other$fail = other.getFail();
            return !(this$fail == null ? other$fail != null : !((Object)this$fail).equals(other$fail));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulkDeleteResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $fail = this.getFail();
            result = result * 59 + ($fail == null ? 43 : ((Object)$fail).hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchOperations.BulkDeleteResponse(fail=" + String.valueOf(this.getFail()) + ")";
        }
    }

    public static class BulkUpdateResponse {
        private long total;
        private long updated;
        private long versionConflicts;
        List<String> fail = new ArrayList<String>();

        public void fail(String id) {
            this.fail.add(id);
        }

        public long getTotal() {
            return this.total;
        }

        public long getUpdated() {
            return this.updated;
        }

        public long getVersionConflicts() {
            return this.versionConflicts;
        }

        public List<String> getFail() {
            return this.fail;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public void setUpdated(long updated) {
            this.updated = updated;
        }

        public void setVersionConflicts(long versionConflicts) {
            this.versionConflicts = versionConflicts;
        }

        public void setFail(List<String> fail) {
            this.fail = fail;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkUpdateResponse)) {
                return false;
            }
            BulkUpdateResponse other = (BulkUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            if (this.getUpdated() != other.getUpdated()) {
                return false;
            }
            if (this.getVersionConflicts() != other.getVersionConflicts()) {
                return false;
            }
            List<String> this$fail = this.getFail();
            List<String> other$fail = other.getFail();
            return !(this$fail == null ? other$fail != null : !((Object)this$fail).equals(other$fail));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulkUpdateResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            long $updated = this.getUpdated();
            result = result * 59 + (int)($updated >>> 32 ^ $updated);
            long $versionConflicts = this.getVersionConflicts();
            result = result * 59 + (int)($versionConflicts >>> 32 ^ $versionConflicts);
            List<String> $fail = this.getFail();
            result = result * 59 + ($fail == null ? 43 : ((Object)$fail).hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchOperations.BulkUpdateResponse(total=" + this.getTotal() + ", updated=" + this.getUpdated() + ", versionConflicts=" + this.getVersionConflicts() + ", fail=" + String.valueOf(this.getFail()) + ")";
        }
    }

    public static class BulkSaveResponse {
        List<Integer> fail = new ArrayList<Integer>();
        Map<Integer, String> success = new HashMap<Integer, String>();
        Map<Integer, String> docIndexNameMap = new HashMap<Integer, String>();

        public void success(int index, String id) {
            this.success.put(index, id);
        }

        public void success(int index, String id, String docIndexName) {
            this.success(index, id);
            this.docIndexNameMap.put(index, docIndexName);
        }

        public void fail(int index) {
            this.fail.add(index);
        }

        public List<Integer> getFail() {
            return this.fail;
        }

        public Map<Integer, String> getSuccess() {
            return this.success;
        }

        public Map<Integer, String> getDocIndexNameMap() {
            return this.docIndexNameMap;
        }

        public void setFail(List<Integer> fail) {
            this.fail = fail;
        }

        public void setSuccess(Map<Integer, String> success) {
            this.success = success;
        }

        public void setDocIndexNameMap(Map<Integer, String> docIndexNameMap) {
            this.docIndexNameMap = docIndexNameMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkSaveResponse)) {
                return false;
            }
            BulkSaveResponse other = (BulkSaveResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$fail = this.getFail();
            List<Integer> other$fail = other.getFail();
            if (this$fail == null ? other$fail != null : !((Object)this$fail).equals(other$fail)) {
                return false;
            }
            Map<Integer, String> this$success = this.getSuccess();
            Map<Integer, String> other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            Map<Integer, String> this$docIndexNameMap = this.getDocIndexNameMap();
            Map<Integer, String> other$docIndexNameMap = other.getDocIndexNameMap();
            return !(this$docIndexNameMap == null ? other$docIndexNameMap != null : !((Object)this$docIndexNameMap).equals(other$docIndexNameMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulkSaveResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $fail = this.getFail();
            result = result * 59 + ($fail == null ? 43 : ((Object)$fail).hashCode());
            Map<Integer, String> $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            Map<Integer, String> $docIndexNameMap = this.getDocIndexNameMap();
            result = result * 59 + ($docIndexNameMap == null ? 43 : ((Object)$docIndexNameMap).hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchOperations.BulkSaveResponse(fail=" + String.valueOf(this.getFail()) + ", success=" + String.valueOf(this.getSuccess()) + ", docIndexNameMap=" + String.valueOf(this.getDocIndexNameMap()) + ")";
        }
    }

    public static class AliasIndex {
        private String index;
        private boolean write;

        public String getIndex() {
            return this.index;
        }

        public boolean isWrite() {
            return this.write;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public void setWrite(boolean write) {
            this.write = write;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliasIndex)) {
                return false;
            }
            AliasIndex other = (AliasIndex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isWrite() != other.isWrite()) {
                return false;
            }
            String this$index = this.getIndex();
            String other$index = other.getIndex();
            return !(this$index == null ? other$index != null : !this$index.equals(other$index));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AliasIndex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isWrite() ? 79 : 97);
            String $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : $index.hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchOperations.AliasIndex(index=" + this.getIndex() + ", write=" + this.isWrite() + ")";
        }
    }
}

