package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.SharedResponse;

import java.io.IOException;
import java.io.OutputStream;

import static com.ovopark.kernel.shared.Util.utf8;

public class DefaultLANAccessHandler implements LANAccessHandler{

    final JSONAccessor jsonAccessor;

    public DefaultLANAccessHandler(JSONAccessor jsonAccessor) {
        this.jsonAccessor = jsonAccessor;
    }

    @Override
    public Result handle(SharedRequest<?> request, SharedResponse<?> response) {
        BaseResult<?> baseResult=BaseResult.noPrivilege();
        try {
            response.setHeader("Content-Type","application/json;charset=utf-8");
            OutputStream outputStream = response.getOutputStream();
            outputStream.write(utf8(jsonAccessor.format(baseResult)));
            outputStream.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return LANAccessHandler.Result.STOP;
    }
}
