package com.ovopark.module.shared.spring;

import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.kernel.shared.vfile.LemonEngine;
import com.ovopark.module.shared.BaseResult;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

import static com.ovopark.kernel.shared.Util.*;

@Slf4j
@RestController("com.ovopark.module.shared.spring.EngineEndpoint")
@RequestMapping("/module-shared/engine")
public class EngineEndpoint {


    final static KVEngine.TtlFunc<String> ttlFunc=KVEngine.newTtl(EngineEndpoint.class.getName());

    @Data
    static class Context{

        final String contextId;

        public Context(String contextId) {
            this.contextId = contextId;
        }

        String nextStartKey;

    }

    @GetMapping("/next")
    @ResponseBody
    public BaseResult<ListRes> next(
            final @RequestParam(value = "contextId") String contextId
            , final @RequestParam(value = "engine") String engine
            , final @RequestParam(value = "initStartKey",required = false) String initStartKey
            , final @RequestParam(value = "num",required = false,defaultValue = "10") int num
            , final @RequestParam(value = "reversed",required = false) boolean reversed
            , final @RequestParam(value = "regex",required = false) String regex
            , final @RequestParam(value = "getSumIf",required = false) boolean getSumIf
    ){
//        Session session = Session.getOrCreate().get();
//        if (session==null) {
//            return BaseResult.noPrivilege();
//        }

        Pattern pattern;
        if (isNotEmpty(regex)) {
            pattern=Pattern.compile(regex);
        } else {
            pattern = null;
        }

        LemonEngine lemonEngine = LemonEngine.mgr().get(engine);

        if (lemonEngine==null) {
            return BaseResult.error(null,"cannot find engine: "+engine);
        }

        KVEngine.PutResult<String, Context> putResult = ttlFunc.ttlAndGet(contextId, new KVEngine.Upset<String, Context, Context>() {
            @Override
            public Context apply(KVEngine.GetResult<String, Context> getResult) {
                if (getResult.exists()) {
                    return getResult.value();
                }
                Context c = new Context(contextId);
                c.setNextStartKey(initStartKey);
                return c;
            }
        }, 60, TimeUnit.SECONDS);

        Context context = putResult.value();

        ListRes res = lock(EngineEndpoint.class.getName() + ":contextId:" + contextId, new Callable<ListRes>() {
            @Override
            public ListRes call() throws Exception {

                ListRes listRes =new ListRes();
                listRes.setContextCreated(putResult.created());
                String nextStartKey = context.nextStartKey;
                listRes.setStartKey(nextStartKey);

                final int n=Math.min(num,1000);
                List<LemonEngine.GetResult> resultList;
                if (reversed) {
                    resultList = lemonEngine.searchBefore(nextStartKey, false, n, k -> pattern == null || pattern.matcher(k).matches());
                }
                else {
                    resultList = lemonEngine.searchAfter(nextStartKey, false, n, k -> pattern == null || pattern.matcher(k).matches());
                }

                if (getSumIf) {
                    listRes.setSum(lemonEngine.count());
                }
                else {
                    listRes.setSum(-1);
                }

                if (isEmpty(resultList)) {
                    context.setNextStartKey(null);
                    return listRes;
                }
                String next=null;
                List<Map<String,Map<String,Object>>> list=new ArrayList<>();
                for (LemonEngine.GetResult getResult : resultList) {
                    Map<String,Map<String,Object>> data=new HashMap<>();
                    Map map = getResult.value();
                    data.put(getResult.key(),map);
                    list.add(data);
                    next=getResult.key();
                }
                context.setNextStartKey(next);
                listRes.setList(list);
                return listRes;
            }
        });

        return BaseResult.success(res);
    }


    @GetMapping("/get")
    @ResponseBody
    public BaseResult<GetRes> get(
            final @RequestParam(value = "engine") String engine
            , final @RequestParam(value = "key") String key){
//        Session session = Session.getOrCreate().get();
//        if (session==null) {
//            return BaseResult.noPrivilege();
//        }

        LemonEngine lemonEngine = LemonEngine.mgr().get(engine);
        if (lemonEngine==null) {
            return BaseResult.error(null,"cannot find engine: "+engine);
        }
        GetRes getRes =new GetRes();
        LemonEngine.GetResult getResult = lemonEngine.get(key);
        if (!getResult.exists()) {
            getRes.setExists(false);
            return BaseResult.success(getRes);
        }
        getRes.setExists(true);
        getRes.setData(getResult.value());
        return BaseResult.success(getRes);
    }

    @GetMapping("/listEngine")
    @ResponseBody
    public BaseResult<List<String>> listEngine(){
//        Session session = Session.getOrCreate().get();
//        if (session==null) {
//            return BaseResult.noPrivilege();
//        }
        return BaseResult.success(LemonEngine.mgr().list());
    }




    @Data
    public static class ListRes implements Model {

        boolean contextCreated;

        private String startKey;

        int sum;

        List<Map<String, Map<String, Object>>> list;


    }

    @Data
    public static class GetRes implements Model {

        private boolean exists;

        Map<String, Object> data;


    }


}
