/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.spring.MapStructProxy;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.SessionStruct;
import com.ovopark.module.shared.spring.rbac.SessionToken;
import com.ovopark.module.shared.spring.rbac.SessionUsersPojo;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshExpiredException;
import com.ovopark.privilege.api.UserApi;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.sso.api.TokenApi;
import com.ovopark.sso.model.TokenValue;
import feign.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionServiceFeignImpl
implements SessionService {
    private static final Logger log = LoggerFactory.getLogger(SessionServiceFeignImpl.class);
    @Autowired
    private TokenApi tokenApi;
    @Autowired
    private UserApi userApi;
    private final SessionStruct sessionStruct = MapStructProxy.getMapper(SessionStruct.class);
    @Autowired
    private JSONAccessor jsonAccessor;

    @Override
    public SessionToken parseNewToken(String newToken) throws TokenRefreshException, TokenInvalidException, TokenRefreshExpiredException {
        com.ovopark.sso.model.BaseResult responseEntity = this.tokenApi.parseToken(newToken, new Request.Options());
        return this.parseToken0(newToken, (com.ovopark.sso.model.BaseResult<TokenValue>)responseEntity);
    }

    private SessionToken parseToken0(String newToken, com.ovopark.sso.model.BaseResult<TokenValue> responseEntity) {
        if (responseEntity == null || responseEntity.getIsError().booleanValue() || responseEntity.getData() == null) {
            log.warn("\u8c03\u7528sso\u5931\u8d25 {}", (Object)newToken);
            if (responseEntity != null && responseEntity.getIsError().booleanValue()) {
                if ("9990001".equals(responseEntity.getCode())) {
                    throw new TokenInvalidException();
                }
                if ("9990002".equals(responseEntity.getCode())) {
                    throw new TokenRefreshException();
                }
                if ("9990003".equals(responseEntity.getCode()) || "9990008".equals(responseEntity.getCode())) {
                    throw new TokenRefreshExpiredException();
                }
                log.warn("\u8c03\u7528sso\u5931\u8d25 {}", (Object)this.jsonAccessor.format(responseEntity));
            }
            return null;
        }
        TokenValue data = (TokenValue)responseEntity.getData();
        return this.sessionStruct.of(data);
    }

    @Override
    public SessionToken parseAccessToken(String accessToken) throws TokenRefreshException, TokenInvalidException, TokenRefreshExpiredException {
        com.ovopark.sso.model.BaseResult responseEntity = this.tokenApi.parseMcpToken(accessToken, new Request.Options());
        return this.parseToken0(accessToken, (com.ovopark.sso.model.BaseResult<TokenValue>)responseEntity);
    }

    @Override
    public SessionUsersPojo getUsersById(Integer userId) {
        BaseResult baseResult = this.userApi.getUsersById(userId);
        if (!baseResult.getIsError().booleanValue()) {
            UsersPojo data = (UsersPojo)baseResult.getData();
            return this.sessionStruct.of(data);
        }
        return null;
    }
}

