package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.spring.SharedConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import({SharedConfig.class , SessionConfig.class})
public class LANConfig {

    @Bean(name = "default_lanAccessHandler")
    @ConditionalOnMissingBean(LANAccessHandler.class)
    public LANAccessHandler lanAccessHandler(JSONAccessor jsonAccessor){
        return new DefaultLANAccessHandler(jsonAccessor);
    }


    @Bean(name = "default_lanResource")
    @RefreshScope
    @ConfigurationProperties("shared.jdk8.module.lan")
    @ConditionalOnMissingBean(LANResource.class)
    public LANResourceImpl lanResource(){
        return new LANResourceImpl();
    }





}
