package com.ovopark.module.shared.spring;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.spring.nacos.EnhancedNacosConfig;
import com.ovopark.module.shared.spring.rbac.SimpleTokenHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import({EnhancedNacosConfig.class})
public class SharedConfig {


    @Bean(name = "default_jsonAccessor")
    @ConditionalOnMissingBean(JSONAccessor.class)
    @ConditionalOnClass({com.fasterxml.jackson.databind.ObjectMapper.class})
    public JSONAccessor jsonAccessor(){
        return new JacksonProviderImpl().get();
    }


    @Bean(name = "default_springConfigRegister")
    public SpringConfigRegister springConfigRegister(){
        return new SpringConfigRegister();
    }

    @Bean
    public FunctionRegisterInSpring functionRegisterInSpring(){
        return new FunctionRegisterInSpring();
    }

    @Bean(name = "default_simpleTokenHandler")
    public SimpleTokenHandler simpleTokenHandler(JSONAccessor jsonAccessor){
        return new SimpleTokenHandler(jsonAccessor);
    }

    @Bean(name = "default_NoOpFunctionRegister")
    @ConditionalOnMissingBean(FunctionRegister.class)
    public NoOpFunctionRegister noOpFunctionRegister(){
        return new NoOpFunctionRegister();
    }

}
