/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.module.shared.spring.SharedConfig;
import com.ovopark.module.shared.spring.rbac.SessionClientImpl;
import com.ovopark.module.shared.spring.rbac.SessionClientResource;
import com.ovopark.module.shared.spring.rbac.SessionClientResourceImpl;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.SessionServiceFeignImpl;
import com.ovopark.module.shared.spring.rbac.SessionServiceFeignProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={SharedConfig.class})
public class SessionConfig {
    @Bean(name={"default_sessionServiceFeignImpl"})
    @ConditionalOnMissingBean(value={SessionService.SessionServiceProvider.class})
    public SessionServiceFeignImpl sessionServiceFeignImpl() {
        return new SessionServiceFeignImpl();
    }

    @Bean(name={"default_sessionServiceFeignProvider"})
    @ConditionalOnMissingBean(value={SessionService.SessionServiceProvider.class})
    public SessionServiceFeignProvider sessionServiceFeignProvider() {
        return new SessionServiceFeignProvider();
    }

    @Bean(name={"default_sessionClient"})
    public SessionClientImpl sessionClient() {
        return new SessionClientImpl();
    }

    @RefreshScope
    @Bean(name={"default_sessionClientResourceImpl"})
    @ConfigurationProperties(value="shared.jdk8.module.session.client")
    @ConditionalOnMissingBean(value={SessionClientResource.class})
    public SessionClientResourceImpl sessionClientResourceImpl() {
        return new SessionClientResourceImpl();
    }
}

