/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.spring.SharedConfig;
import com.ovopark.module.shared.spring.rbac.DefaultLANAccessHandler;
import com.ovopark.module.shared.spring.rbac.LANAccessHandler;
import com.ovopark.module.shared.spring.rbac.LANResource;
import com.ovopark.module.shared.spring.rbac.LANResourceImpl;
import com.ovopark.module.shared.spring.rbac.SessionConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={SharedConfig.class, SessionConfig.class})
public class LANConfig {
    @Bean(name={"default_lanAccessHandler"})
    @ConditionalOnMissingBean(value={LANAccessHandler.class})
    public LANAccessHandler lanAccessHandler(JSONAccessor jsonAccessor) {
        return new DefaultLANAccessHandler(jsonAccessor);
    }

    @Bean(name={"default_lanResource"})
    @RefreshScope
    @ConfigurationProperties(value="shared.jdk8.module.lan")
    @ConditionalOnMissingBean(value={LANResource.class})
    public LANResourceImpl lanResource() {
        return new LANResourceImpl();
    }
}

