package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.sso.model.TokenValue;

public interface SessionService {

    SessionToken parseNewToken(String newToken) throws TokenRefreshException,TokenInvalidException,TokenRefreshExpiredException;

    //MCP
    default SessionToken parseAccessToken(String accessToken) throws TokenRefreshException,TokenInvalidException,TokenRefreshExpiredException{
        throw new UnsupportedOperationException();
    }

    SessionUsersPojo getUsersById(Integer userId);


    interface SessionServiceProvider extends ServiceProvider<SessionService> {

    }



}
