/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.CacheStat;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.FunctionRegister;
import com.ovopark.module.shared.spring.InfoCollector;
import com.ovopark.module.shared.spring.ResourceAccess;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionClientImpl
implements SessionClient,
FunctionRegister {
    private static final Logger log = LoggerFactory.getLogger(SessionClientImpl.class);
    @Autowired
    private SessionService.SessionServiceProvider serviceProvider;
    @Autowired
    private JSONAccessor jsonAccessor;
    public static final CacheStat cacheStat = CacheStat.cacheStat();

    @Override
    public Session session(SharedRequest<?> request) throws TokenInvalidException, TokenRefreshException, TokenRefreshExpiredException {
        Session session = Session.getOrCreate().get();
        if (session != null) {
            return session;
        }
        session = ResourceAccess.getOrCreate().session(request, this.jsonAccessor);
        if (session != null) {
            long l = cacheStat.hit();
            if (l % 100L == 0L) {
                InfoCollector.getOrCreate().put("SESSION_CLIENT_GATEWAY_TOKEN_HIT_COUNT", String.valueOf(l));
            }
            return session;
        }
        long l = cacheStat.miss();
        if (l % 100L == 0L) {
            InfoCollector.getOrCreate().put("SESSION_CLIENT_GATEWAY_TOKEN_MISS_COUNT", String.valueOf(l));
        }
        return ResourceAccess.getOrCreate().session(request, this.serviceProvider);
    }

    @Override
    public void register() {
        log.info("SESSION_CLIENT_ENABLED > true");
        InfoCollector.getOrCreate().put("SESSION_CLIENT_ENABLED", "true");
    }
}

