/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring;

import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.kernel.shared.vfile.LemonEngine;
import com.ovopark.module.shared.BaseResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.ovopark.module.shared.spring.EngineEndpoint")
@RequestMapping(value={"/module-shared/engine"})
public class EngineEndpoint {
    private static final Logger log = LoggerFactory.getLogger(EngineEndpoint.class);
    static final KVEngine.TtlFunc<String> ttlFunc = KVEngine.newTtl((String)EngineEndpoint.class.getName());

    @GetMapping(value={"/next"})
    @ResponseBody
    public BaseResult<ListRes> next(final @RequestParam(value="contextId") String contextId, @RequestParam(value="engine") String engine, final @RequestParam(value="initStartKey", required=false) String initStartKey, final @RequestParam(value="num", required=false, defaultValue="10") int num, final @RequestParam(value="reversed", required=false) boolean reversed, @RequestParam(value="regex", required=false) String regex, final @RequestParam(value="getSumIf", required=false) boolean getSumIf) {
        final Pattern pattern = Util.isNotEmpty((CharSequence)regex) ? Pattern.compile(regex) : null;
        final LemonEngine lemonEngine = LemonEngine.mgr().get(engine);
        if (lemonEngine == null) {
            return BaseResult.error(null, (String)("cannot find engine: " + engine));
        }
        final KVEngine.PutResult putResult = ttlFunc.ttlAndGet((Comparable)((Object)contextId), (KVEngine.Upset)new KVEngine.Upset<String, Context, Context>(){

            public Context apply(KVEngine.GetResult<String, Context> getResult) {
                if (getResult.exists()) {
                    return (Context)getResult.value();
                }
                Context c = new Context(contextId);
                c.setNextStartKey(initStartKey);
                return c;
            }
        }, 60L, TimeUnit.SECONDS);
        final Context context = (Context)putResult.value();
        ListRes res = (ListRes)Util.lock((Comparable)((Object)(EngineEndpoint.class.getName() + ":contextId:" + contextId)), (Callable)new Callable<ListRes>(){

            @Override
            public ListRes call() throws Exception {
                ListRes listRes = new ListRes();
                listRes.setContextCreated(putResult.created());
                String nextStartKey = context.nextStartKey;
                listRes.setStartKey(nextStartKey);
                int n = Math.min(num, 1000);
                List resultList = reversed ? lemonEngine.searchBefore(nextStartKey, false, n, k -> pattern == null || pattern.matcher((CharSequence)k).matches()) : lemonEngine.searchAfter(nextStartKey, false, n, k -> pattern == null || pattern.matcher((CharSequence)k).matches());
                if (getSumIf) {
                    listRes.setSum(lemonEngine.count());
                } else {
                    listRes.setSum(-1);
                }
                if (Util.isEmpty((Collection)resultList)) {
                    context.setNextStartKey(null);
                    return listRes;
                }
                String next = null;
                ArrayList<Map<String, Map<String, Object>>> list = new ArrayList<Map<String, Map<String, Object>>>();
                for (LemonEngine.GetResult getResult : resultList) {
                    HashMap<String, Map> data = new HashMap<String, Map>();
                    Map map = getResult.value();
                    data.put(getResult.key(), map);
                    list.add(data);
                    next = getResult.key();
                }
                context.setNextStartKey(next);
                listRes.setList(list);
                return listRes;
            }
        });
        return BaseResult.success((Object)res);
    }

    @GetMapping(value={"/get"})
    @ResponseBody
    public BaseResult<GetRes> get(@RequestParam(value="engine") String engine, @RequestParam(value="key") String key) {
        LemonEngine lemonEngine = LemonEngine.mgr().get(engine);
        if (lemonEngine == null) {
            return BaseResult.error(null, (String)("cannot find engine: " + engine));
        }
        GetRes getRes = new GetRes();
        LemonEngine.GetResult getResult = lemonEngine.get(key);
        if (!getResult.exists()) {
            getRes.setExists(false);
            return BaseResult.success((Object)getRes);
        }
        getRes.setExists(true);
        getRes.setData(getResult.value());
        return BaseResult.success((Object)getRes);
    }

    @GetMapping(value={"/listEngine"})
    @ResponseBody
    public BaseResult<List<String>> listEngine() {
        return BaseResult.success((Object)LemonEngine.mgr().list());
    }

    @GetMapping(value={"/disk"})
    public String disk(@RequestParam(value="engine") String engine) throws Exception {
        LemonEngine lemonEngine = LemonEngine.mgr().get(engine);
        if (lemonEngine == null) {
            return "cannot find engine: " + engine;
        }
        String result = Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + " , ver: " + 5 + "." + 5;
        result = result + "\r\n" + lemonEngine.disk();
        return result;
    }

    static class Context {
        final String contextId;
        String nextStartKey;

        public Context(String contextId) {
            this.contextId = contextId;
        }

        public String getContextId() {
            return this.contextId;
        }

        public String getNextStartKey() {
            return this.nextStartKey;
        }

        public void setNextStartKey(String nextStartKey) {
            this.nextStartKey = nextStartKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contextId = this.getContextId();
            String other$contextId = other.getContextId();
            if (this$contextId == null ? other$contextId != null : !this$contextId.equals(other$contextId)) {
                return false;
            }
            String this$nextStartKey = this.getNextStartKey();
            String other$nextStartKey = other.getNextStartKey();
            return !(this$nextStartKey == null ? other$nextStartKey != null : !this$nextStartKey.equals(other$nextStartKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contextId = this.getContextId();
            result = result * 59 + ($contextId == null ? 43 : $contextId.hashCode());
            String $nextStartKey = this.getNextStartKey();
            result = result * 59 + ($nextStartKey == null ? 43 : $nextStartKey.hashCode());
            return result;
        }

        public String toString() {
            return "EngineEndpoint.Context(contextId=" + this.getContextId() + ", nextStartKey=" + this.getNextStartKey() + ")";
        }
    }

    public static class ListRes
    implements Model {
        boolean contextCreated;
        private String startKey;
        int sum;
        List<Map<String, Map<String, Object>>> list;

        public boolean isContextCreated() {
            return this.contextCreated;
        }

        public String getStartKey() {
            return this.startKey;
        }

        public int getSum() {
            return this.sum;
        }

        public List<Map<String, Map<String, Object>>> getList() {
            return this.list;
        }

        public void setContextCreated(boolean contextCreated) {
            this.contextCreated = contextCreated;
        }

        public void setStartKey(String startKey) {
            this.startKey = startKey;
        }

        public void setSum(int sum) {
            this.sum = sum;
        }

        public void setList(List<Map<String, Map<String, Object>>> list) {
            this.list = list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListRes)) {
                return false;
            }
            ListRes other = (ListRes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isContextCreated() != other.isContextCreated()) {
                return false;
            }
            if (this.getSum() != other.getSum()) {
                return false;
            }
            String this$startKey = this.getStartKey();
            String other$startKey = other.getStartKey();
            if (this$startKey == null ? other$startKey != null : !this$startKey.equals(other$startKey)) {
                return false;
            }
            List<Map<String, Map<String, Object>>> this$list = this.getList();
            List<Map<String, Map<String, Object>>> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ListRes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isContextCreated() ? 79 : 97);
            result = result * 59 + this.getSum();
            String $startKey = this.getStartKey();
            result = result * 59 + ($startKey == null ? 43 : $startKey.hashCode());
            List<Map<String, Map<String, Object>>> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        public String toString() {
            return "EngineEndpoint.ListRes(contextCreated=" + this.isContextCreated() + ", startKey=" + this.getStartKey() + ", sum=" + this.getSum() + ", list=" + this.getList() + ")";
        }
    }

    public static class GetRes
    implements Model {
        private boolean exists;
        Map<String, Object> data;

        public boolean isExists() {
            return this.exists;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setExists(boolean exists) {
            this.exists = exists;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRes)) {
                return false;
            }
            GetRes other = (GetRes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExists() != other.isExists()) {
                return false;
            }
            Map<String, Object> this$data = this.getData();
            Map<String, Object> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetRes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExists() ? 79 : 97);
            Map<String, Object> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "EngineEndpoint.GetRes(exists=" + this.isExists() + ", data=" + this.getData() + ")";
        }
    }
}

