/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.SharedLocale;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.TokenUtils;
import com.ovopark.module.shared.spring.rbac.ClientInfo;
import com.ovopark.module.shared.spring.rbac.SessionImpl;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.SessionToken;
import com.ovopark.module.shared.spring.rbac.SessionUsersPojo;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.UserInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceAccess {
    private static final Logger log = LoggerFactory.getLogger(ResourceAccess.class);
    private static final ResourceAccess INSTANCE = new ResourceAccess();

    private ResourceAccess() {
    }

    public static ResourceAccess getOrCreate() {
        return INSTANCE;
    }

    public boolean isFromWAN(SharedRequest<?> request) {
        String header = request.getHeader("X-Request-Gateway");
        if (log.isDebugEnabled()) {
            log.info("OK , we found gateway route head: " + header);
        }
        return Util.isNotEmpty((CharSequence)header);
    }

    public Session session(SharedRequest<?> request, JSONAccessor jsonAccessor) {
        return this.session(request, (arg_0, arg_1) -> ((JSONAccessor)jsonAccessor).read(arg_0, arg_1));
    }

    public Session session(SharedRequest<?> request, SessionDeserializer sessionDeserializer) {
        String str = request.getHeader("X-Ovo-Authorization-utf8");
        if (Util.isNotEmpty((CharSequence)str)) {
            if (log.isDebugEnabled()) {
                log.info("OK , we found gateway token, to deserialize value: " + str);
            }
            try {
                str = URLDecoder.decode(str, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                throw Util.convert2RuntimeException((Throwable)e);
            }
            return sessionDeserializer.read(str, SessionImpl.class);
        }
        str = request.getHeader("X-Ovo-Authorization");
        if (Util.isNotEmpty((CharSequence)str)) {
            if (log.isDebugEnabled()) {
                log.info("OK , we found gateway token, to deserialize value: " + str);
            }
            return sessionDeserializer.read(str, SessionImpl.class);
        }
        return null;
    }

    public Session session(SharedRequest<?> request, SessionService.SessionServiceProvider serviceProvider) {
        String newAuthenticator = request.getHeader("Ovo-Authorization");
        String oldAuthenticator = request.getHeader("authenticator");
        String channel = request.getHeader("Ovo-Channel");
        String mcpAuthenticator = request.getHeader("Ovo-Access-Token");
        if (Util.isEmpty((CharSequence)newAuthenticator) && Util.isEmpty((CharSequence)oldAuthenticator) && Util.isEmpty((CharSequence)mcpAuthenticator)) {
            if (log.isDebugEnabled()) {
                log.info("OK , cannot found any token in the head.");
            }
            return null;
        }
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setRemoteIp(this.remoteIp(request));
        clientInfo.setPlatform(this.platform(request));
        clientInfo.setChannel(channel);
        UserInfo user = new UserInfo();
        SessionImpl session = new SessionImpl();
        session.setClientInfo(clientInfo);
        session.setUserInfo(user);
        SessionService sessionService = (SessionService)serviceProvider.get();
        if (Util.isNotEmpty((CharSequence)newAuthenticator) || Util.isNotEmpty((CharSequence)mcpAuthenticator)) {
            if (log.isDebugEnabled()) {
                log.info("OK , found Ovo-Authorization | Ovo-Access-Token token in the head: " + newAuthenticator + " | " + mcpAuthenticator);
            }
            SessionToken tokenValue = null;
            String[] auths = null;
            String token = null;
            if (Util.isNotEmpty((CharSequence)newAuthenticator)) {
                auths = newAuthenticator.split(" ");
                token = auths[0];
                tokenValue = sessionService.parseNewToken(token);
            } else if (Util.isNotEmpty((CharSequence)mcpAuthenticator)) {
                auths = mcpAuthenticator.split(" ");
                token = auths[0];
                tokenValue = sessionService.parseAccessToken(token);
            }
            if (tokenValue == null) {
                throw new IllegalArgumentException("token is missing, mcp(" + Util.isNotEmpty((CharSequence)mcpAuthenticator) + ") ???: " + token);
            }
            if (auths.length > 1) {
                clientInfo.setClient(auths[1]);
            }
            if (auths.length > 2) {
                clientInfo.setVersion(auths[2]);
            }
            if (auths.length > 3) {
                clientInfo.setLang(auths[3]);
                if ("ENGLISH".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(Locale.US);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                } else if ("TRADITIONAL_CHINESE".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(Locale.TRADITIONAL_CHINESE);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                } else if ("INDONESIA".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(SharedLocale.IN_ID);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                } else if ("JAPANESE".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(Locale.JAPAN);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                } else if ("ITALIAN".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(Locale.ITALY);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                } else if ("THAI".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(SharedLocale.TH_TH);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                } else if ("VIETNAMESE".equalsIgnoreCase(auths[3])) {
                    clientInfo.setLocale(SharedLocale.VI_VN);
                    clientInfo.setLocaleString(clientInfo.getLocale().toString());
                }
            }
            if (auths.length > 4) {
                try {
                    clientInfo.setTimeZone(TimeZone.getTimeZone(auths[4]));
                }
                catch (Exception e) {
                    log.info("--------------TimeZone translate faied, timeZone:" + auths[4]);
                }
            }
            if (auths.length > 5) {
                clientInfo.setDeviceName(auths[5]);
            }
            if (auths.length > 6) {
                clientInfo.setDeviceSerialNo(auths[6]);
            }
            user.setUserId(tokenValue.getUserId());
            user.setUserName(tokenValue.getUserName());
            user.setGroupId(tokenValue.getGroupId());
            user.setIsAgency(tokenValue.getIsAgency());
            user.setIsAccountUser(tokenValue.getIsAccountUser());
            session.setBackendToken(newAuthenticator);
        } else if (Util.isNotEmpty((CharSequence)oldAuthenticator)) {
            SessionUsersPojo users;
            String userIdStr;
            if (log.isDebugEnabled()) {
                log.info("OK , found authenticator token in the head: " + oldAuthenticator);
            }
            if (Util.isEmpty((CharSequence)(userIdStr = TokenUtils.getUserId(oldAuthenticator)))) {
                throw new TokenInvalidException("token is invalid ???: " + oldAuthenticator);
            }
            if (!Util.isEmpty((CharSequence)userIdStr) && (users = sessionService.getUsersById(Integer.parseInt(userIdStr))) != null) {
                if (Util.compare2((Comparable)users.getIsDel(), (Comparable)Integer.valueOf(1)) == 0 || Util.compare2((Comparable)users.getIsFrozen(), (Comparable)Integer.valueOf(1)) == 0 || users.getValidateDate() != null && users.getValidateDate().isBefore(LocalDateTime.now())) {
                    throw new TokenInvalidException("token is invalid ???: " + oldAuthenticator);
                }
                user.setUserId(users.getId());
                user.setUserName(users.getUserName());
                user.setGroupId(users.getGroupId());
                user.setIsAgency(users.getIsAgency());
                user.setIsAccountUser(0);
            }
            session.setBackendToken(oldAuthenticator);
        }
        return session;
    }

    public String platform(SharedRequest<?> request) {
        String userAgent = request.getHeader("User-Agent");
        String platform = null;
        platform = userAgent != null ? (userAgent.contains("Android") || userAgent.contains("okhttp") ? "Android" : (userAgent.contains("iOS") || userAgent.contains("iPhone") ? "iOS" : "web")) : "unknown";
        return platform;
    }

    public String remoteIp(SharedRequest<?> request) {
        String realIp = request.getHeader("X-Real-IP");
        String remoteIp = request.getHeader("x-forwarded-for");
        if (Util.isNotEmpty((CharSequence)realIp)) {
            // empty if block
        }
        if (Util.isNotEmpty((CharSequence)remoteIp)) {
            if (remoteIp.contains(",")) {
                remoteIp = remoteIp.split(",")[0].trim();
            }
            return remoteIp;
        }
        remoteIp = request.getHeader("x-forwarded-for");
        if (Util.isNotEmpty((CharSequence)remoteIp)) {
            String[] ips;
            for (String ip : ips = remoteIp.split(",")) {
                if ("null".equalsIgnoreCase(ip)) continue;
                return ip;
            }
        }
        return request.getRemoteAddr();
    }

    public static interface SessionDeserializer {
        public <T extends Session> Session read(String var1, Class<T> var2);
    }
}

