/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.nacos;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClientConfiguration;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.ovopark.kernel.shared.Util;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(value="com.ovopark.module.shared.spring.nacos.EnhancedNacosConfig")
@AutoConfigureBefore(value={NacosDiscoveryClientConfiguration.class})
@ConditionalOnClass(value={NacosRegistrationCustomizer.class})
public class EnhancedNacosConfig {
    private static final Logger log = LoggerFactory.getLogger(EnhancedNacosConfig.class);
    @Autowired
    private Environment environment;

    @ConditionalOnMissingBean
    @Bean
    public NacosRegistrationCustomizer nacosRegistrationCustomizer() {
        return new NacosRegistrationCustomizer(){

            public void customize(NacosRegistration registration) {
                try {
                    Map metadata = registration.getMetadata();
                    metadata.put("_startup_", Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]));
                    metadata.put("_source_key_", NacosRegistrationCustomizer.class.getSimpleName());
                    metadata.put("_shared_ver_", "5.7");
                    File file = new File("/var/run/secrets/kubernetes.io/serviceaccount/token");
                    if (file.exists() && Util.read((File)file).length > 0) {
                        metadata.put("_k8s_", "true");
                    } else {
                        metadata.put("_k8s_", "false");
                    }
                }
                catch (Exception e) {
                    log.warn("cannot set metadata: " + e.getMessage(), (Throwable)e);
                }
            }
        };
    }
}

