/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.SharedResponse;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import java.io.IOException;
import java.io.OutputStream;

public class SimpleTokenHandler
implements TokenHandler {
    final JSONAccessor jsonAccessor;

    public SimpleTokenHandler(JSONAccessor jsonAccessor) {
        this.jsonAccessor = jsonAccessor;
    }

    @Override
    public void handleInvalid(SharedRequest<?> request, SharedResponse<?> response) {
        BaseResult baseResult = BaseResult.invalidToken();
        try {
            response.setHeader("Content-Type", "application/json;charset=utf-8");
            OutputStream outputStream = response.getOutputStream();
            outputStream.write(Util.utf8((String)this.jsonAccessor.format((Object)baseResult)));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleRefresh(SharedRequest<?> request, SharedResponse<?> response) {
        BaseResult baseResult = BaseResult.expiredToken();
        try {
            response.setHeader("Content-Type", "application/json;charset=utf-8");
            OutputStream outputStream = response.getOutputStream();
            outputStream.write(Util.utf8((String)this.jsonAccessor.format((Object)baseResult)));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleRefreshExpired(SharedRequest<?> request, SharedResponse<?> response) {
        BaseResult baseResult = BaseResult.refreshExpiredToken();
        try {
            response.setHeader("Content-Type", "application/json;charset=utf-8");
            OutputStream outputStream = response.getOutputStream();
            outputStream.write(Util.utf8((String)this.jsonAccessor.format((Object)baseResult)));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

