package com.ovopark.module.shared.spring.nacos;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClientConfiguration;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.Ver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import java.io.File;
import java.time.LocalDateTime;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.formatTime;


@Slf4j
@Configuration(value = "com.ovopark.module.shared.spring.nacos.EnhancedNacosConfig")
@AutoConfigureBefore({NacosDiscoveryClientConfiguration.class})
@ConditionalOnClass(NacosRegistrationCustomizer.class)
public class EnhancedNacosConfig {

    @Autowired
    private Environment environment;

//    @Bean
//    @ConditionalOnMissingBean
//    @ConditionalOnProperty(value = "spring.cloud.nacos.discovery.watch.enabled",
//            matchIfMissing = true)
//    public NacosWatch nacosWatch(NacosServiceManager nacosServiceManager
//            , NacosDiscoveryProperties nacosDiscoveryProperties) {
//        log.info("enhance nacos metadata");
//        //原来的元数据全部不变
//        Map<String, String> metadata = nacosDiscoveryProperties.getMetadata();
//        if(metadata==null){
//            metadata = new HashMap<>();
//            nacosDiscoveryProperties.setMetadata(metadata);
//        }
//        metadata.put("startup", formatTime(LocalDateTime.now()));
//        metadata.put("k8s", environment.getProperty("K8S_CONTAINER","false") );
//        return new NacosWatch(nacosServiceManager,nacosDiscoveryProperties);
//    }

    @ConditionalOnMissingBean
    @Bean
    public NacosRegistrationCustomizer nacosRegistrationCustomizer(){
        return new NacosRegistrationCustomizer() {
            @Override
            public void customize(NacosRegistration registration) {
                try {
                    Map<String, String> metadata = registration.getMetadata();
                    metadata.put("_startup_", formatTime(LocalDateTime.now()));
                    metadata.put("_source_key_", NacosRegistrationCustomizer.class.getSimpleName());
                    metadata.put("_shared_ver_", Ver.main+"."+Ver.min);

                    File file = new File("/var/run/secrets/kubernetes.io/serviceaccount/token");
                    if (file.exists() && Util.read(file).length>0) {
                        metadata.put("_k8s_", "true");
                    }
                    else {
                        metadata.put("_k8s_", "false");
                    }
                }
                catch (Exception e){
                    log.warn("cannot set metadata: "+e.getMessage(),e);
                }
            }
        };
    }

}
