/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String sendJsonToOtherServer(String url, Object data) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)data), Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendJsonToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostToOtherServer(String url, Map<String, Object> params) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostToOtherServerWithAuth(String url, Map<String, Object> params, String authenticator) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpPost.setHeader("authenticator", authenticator);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendGetToOtherServer(String url) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendGetToOtherServerWithAuth(String url, String authenticator) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Content-type", "application/json; charset=utf-8");
            httpGet.setHeader("authenticator", authenticator);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJsonToOtherServerDefault(String url, Map<String, String> map) {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(url);
        if (map != null && map.size() > 0) {
            NameValuePair[] nameValuePair = new NameValuePair[map.size()];
            int i = 0;
            for (String key : map.keySet()) {
                NameValuePair nameValuePairTmp;
                nameValuePair[i] = nameValuePairTmp = new NameValuePair();
                nameValuePair[i].setName(key);
                nameValuePair[i].setValue(map.get(key));
                ++i;
            }
            post.setRequestBody(nameValuePair);
        }
        post.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        HttpConnectionManagerParams managerParams = client.getHttpConnectionManager().getParams();
        managerParams.setConnectionTimeout(60000);
        managerParams.setSoTimeout(60000);
        try {
            int code = client.executeMethod((HttpMethod)post);
            if (code == 200) {
                String string = post.getResponseBodyAsString();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    public static String sendPostStr(String url, String param) {
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(3000).build();
            CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(param, Charset.forName("UTF-8")));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                EntityUtils.consume((HttpEntity)entity);
                response.close();
                return result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

