/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ovopark.shoppaper.model.JPush;
import com.ovopark.shoppaper.model.JPushAccount;
import com.ovopark.shoppaper.model.MessageBody;
import com.ovopark.shoppaper.model.MessageObject;
import com.ovopark.shoppaper.model.PushNotificationParameter;
import com.ovopark.shoppaper.utils.StringsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPushMessageUtil {
    private boolean apnsProduction = false;
    private static JPushMessageUtil instance = null;
    protected static final Logger LOG = LoggerFactory.getLogger(JPushMessageUtil.class);

    public static void sendPush(PushNotificationParameter param) {
        String masterSecret;
        if (instance == null) {
            instance = new JPushMessageUtil();
        }
        if (!StringsUtils.isBlank(masterSecret = JPushAccount.getMasterSecret(param.getJpush().getAppKey()))) {
            JPushClient jpushClient = new JPushClient(masterSecret, param.getJpush().getAppKey(), 3);
            PushPayload payload = null;
            if (param.getMessageType().equals(JPush.MASSAGE_TYPE_BROAD)) {
                payload = instance.buildPushObject_all_all_alert(param.getMessage());
            } else if (param.getMessageType().equals(JPush.MASSAGE_TYPE_NOTIFY)) {
                if (param.getBody() != null) {
                    payload = instance.buildPushObject_android_and_ios(param.getJpush().getPushAlias(), param.getMessage(), param.getTitle(), param.getBadge(), param.getBody());
                } else {
                    if (JPush.DEVICE_ANDROID == param.getJpush().getDeviceType()) {
                        payload = instance.buildPushObject_android_alais_alertWithTitle(param.getJpush().getPushAlias(), param.getMessage(), param.getTitle());
                    }
                    if (JPush.DEVICE_IOS == param.getJpush().getDeviceType()) {
                        payload = instance.buildPushObject_ios_alais_alertWithTitle(param.getJpush().getPushAlias(), param.getMessage());
                    }
                }
            } else {
                payload = JPush.MASSAGE_TYPE_MSG == param.getMessageType() ? JPushMessageUtil.buildPushObject_messageWithExtras(param.getJpush().getPushAlias(), param.getMsgParam()) : instance.buildPushObject_all_tags_alert(param.getJpush().getPushTag(), param.getMessage());
            }
            try {
                LOG.info("\u8bf7\u6c42\u4fe1\u606f result - " + payload);
                PushResult result = jpushClient.sendPush(payload);
                LOG.info("Got result - " + result);
            }
            catch (APIConnectionException e) {
                LOG.error("Connection error. Should retry later. ", (Throwable)e);
            }
            catch (APIRequestException e) {
                LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
                LOG.info("HTTP Status: " + e.getStatus());
                LOG.info("Error Code: " + e.getErrorCode());
                LOG.info("Error Message: " + e.getErrorMessage());
                LOG.info("Msg ID: " + e.getMsgId());
            }
        } else {
            LOG.info("jpush key-secret not configged, app key:" + param.getJpush().getAppKey());
        }
    }

    private PushPayload buildPushObject_all_all_alert(String msg) {
        return PushPayload.alertAll((String)msg);
    }

    private PushPayload buildPushObject_all_tags_alert(String tag, String msg) {
        if (StringsUtils.isBlank(msg)) {
            msg = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.tag((String[])new String[]{tag})).setNotification(Notification.alert((Object)msg)).build();
    }

    private PushPayload buildPushObject_android_alais_alertWithTitle(String alais, String msg, String title) {
        if (StringsUtils.isBlank(msg)) {
            msg = "";
        }
        if (StringsUtils.isBlank(title)) {
            title = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.alias((String[])new String[]{alais})).setNotification(Notification.android((String)msg, (String)title, null)).build();
    }

    private PushPayload buildPushObject_ios_alais_alertWithTitle(String alais, String msg) {
        if (StringsUtils.isBlank(msg)) {
            msg = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.tag((String[])new String[]{alais})).setNotification(Notification.ios((Object)msg, null)).build();
    }

    private PushPayload buildPushObject_android_and_ios(String alais, String msg, String title, Integer badge, MessageBody body) {
        if (StringsUtils.isBlank(msg)) {
            msg = "";
        }
        if (StringsUtils.isBlank(title)) {
            title = "";
        }
        if (body == null) {
            body = new MessageBody();
        }
        Gson gson = new Gson();
        JsonParser paser = new JsonParser();
        JsonObject jsonMsgBody = paser.parse(gson.toJson((Object)body)).getAsJsonObject();
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias((String[])new String[]{alais})).setNotification(Notification.newBuilder().setAlert((Object)msg).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(title).setUriActivity("com.kedacom.ovopark.ui.PushClickActivity").setUriAction("com.kedacom.ovopark.ui.PushClickActivity").addExtra("content", jsonMsgBody)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().incrBadge(badge != null ? badge : 1).setSound((Object)"default").setMutableContent(true).addExtra("content", jsonMsgBody)).build()).build()).setOptions(Options.newBuilder().setApnsProduction(this.apnsProduction).build()).build();
    }

    public static PushPayload buildPushObject_messageWithExtras(String alais, MessageObject msgParam) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.newBuilder().addAudienceTarget(AudienceTarget.alias((String[])new String[]{alais})).build()).setMessage(Message.newBuilder().setMsgContent(JSONObject.toJSONString((Object)msgParam)).build()).build();
    }
}

