/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {
    public static String getPinYin(String src) {
        char[] t1 = null;
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        String t4 = "";
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; ++i) {
                if (PinyinUtil.isChinese(t1[i])) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray((char)t1[i], (HanyuPinyinOutputFormat)t3);
                    if (t2 == null || t2.length <= 0) continue;
                    t4 = t4 + t2[0];
                    continue;
                }
                t4 = t4 + Character.toString(t1[i]).toLowerCase();
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return t4;
    }

    public static boolean isChinese(char c) {
        return Character.toString(c).matches("[\\u4E00-\\u9FA5]+");
    }

    public static boolean isContainChinese(String s) {
        boolean flat = false;
        for (int i = 0; i < s.length() && !(flat = PinyinUtil.isChinese(s.charAt(i))); ++i) {
        }
        return flat;
    }

    public static String getPinYinHeadChar(String str) {
        String convert = "";
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? convert + pinyinArray[0].charAt(0) : convert + word;
        }
        return convert.toUpperCase();
    }

    public static boolean isLatinStr(String s) {
        boolean flat = true;
        for (int i = 0; i < s.length() && (flat = PinyinUtil.isLatinLetter(s.charAt(i))); ++i) {
        }
        return flat;
    }

    public static boolean isLatinLetter(char c) {
        return 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c;
    }

    public static String getCnASCII(String cnStr) {
        StringBuffer strBuf = new StringBuffer();
        byte[] bGBK = cnStr.getBytes();
        for (int i = 0; i < bGBK.length; ++i) {
            strBuf.append(Integer.toHexString(bGBK[i] & 0xFF));
        }
        return strBuf.toString();
    }
}

