/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils.oss;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.ovopark.shoppaper.utils.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OssHelper {
    private static final Logger log = LoggerFactory.getLogger(OssHelper.class);
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String accessUrl;
    private static String roleArn;
    private static String authAccessKeyId;
    private static String authAccessKeySecret;
    private static String region;

    public static String getCircle(String imageUrl) {
        if (!StringUtils.isEmpty((Object)imageUrl)) {
            Map<String, String> map = OssHelper.getImageInfo(imageUrl);
            if (map.get("ImageHeight") != null && map.get("ImageWidth") != null) {
                if (Integer.parseInt(map.get("ImageHeight")) > Integer.parseInt(map.get("ImageWidth"))) {
                    return imageUrl + "?x-oss-process=image/circle,r_" + map.get("ImageWidth");
                }
                return imageUrl + "?x-oss-process=image/circle,r_" + map.get("ImageHeight");
            }
            return imageUrl;
        }
        return null;
    }

    public static String getSquare(String imageUrl) {
        if (!StringUtils.isEmpty((Object)imageUrl)) {
            Map<String, String> map = OssHelper.getImageInfo(imageUrl);
            if (map.get("ImageHeight") != null && map.get("ImageWidth") != null) {
                if (Integer.parseInt(map.get("ImageHeight")) > Integer.parseInt(map.get("ImageWidth"))) {
                    return imageUrl + "?x-oss-process=image/crop,x_0,y_0,w_" + map.get("ImageWidth") + ",h_" + map.get("ImageWidth") + ",g_center";
                }
                return imageUrl + "?x-oss-process=image/crop,x_0,y_0,w_" + map.get("ImageHeight") + ",h_" + map.get("ImageHeight") + ",g_center";
            }
            return imageUrl;
        }
        return null;
    }

    public static Map<String, String> getImageInfo(String url) {
        HashMap<String, String> result = new HashMap<String, String>();
        String json = HttpUtils.sendGetToOtherServer(url + "?x-oss-process=image/info");
        if (!StringUtils.isEmpty((Object)json)) {
            Map value;
            Map map = (Map)JSONObject.parseObject((String)json, Map.class);
            if (map.get("ImageHeight") != null) {
                value = (Map)JSONObject.parseObject((String)map.get("ImageHeight").toString(), Map.class);
                result.put("ImageHeight", value.get("value").toString());
            }
            if (map.get("ImageWidth") != null) {
                value = (Map)JSONObject.parseObject((String)map.get("ImageWidth").toString(), Map.class);
                result.put("ImageWidth", value.get("value").toString());
            }
            return result;
        }
        return null;
    }

    public static String uploadFile(File file) {
        String newFileName = OssHelper.genImageName(file.getName());
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFile(InputStream inputStream, String ext) {
        String newFileName = OssHelper.genImageName(ext);
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(inputStream, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadOriginFile(InputStream inputStream, String ext) {
        String imagePath = OssHelper.getImagePath(ext);
        OssHelper.putObject(inputStream, ext, imagePath);
        return imagePath;
    }

    public static String uploadFileNew(InputStream inputStream, String ext) {
        String newFileName = OssHelper.genImageName(ext);
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(inputStream, newFileName, imagePath);
        return accessUrl + "/" + imagePath;
    }

    public static String uploadFile(File file, String ext) {
        if (StringUtils.isEmpty((Object)ext)) {
            ext = "jpg";
        }
        String newFileName = OssHelper.genImageName(file.getName());
        if (!StringUtils.isEmpty((Object)ext)) {
            newFileName = newFileName.substring(0, newFileName.lastIndexOf(".") + 1) + ext;
        }
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFile(byte[] file) {
        String newFileName = OssHelper.genImageName(OssHelper.getRandomString(32) + ".jpg");
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFileWithName(File file, String fileName) {
        String newFileName = OssHelper.genImageName(file.getName());
        if (!StringUtils.isEmpty((Object)fileName)) {
            newFileName = fileName;
        }
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String uploadLocalFile(String localFilePath) {
        String newFileName = OssHelper.genImageName(localFilePath.substring(localFilePath.lastIndexOf("/") + 1));
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(new File(localFilePath), newFileName, imagePath);
        return imagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream downLoadFile(String imagePath) {
        OSSClient client = null;
        InputStream input = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            OSSObject image = client.getObject(ossBucketName, imagePath);
            if (image != null) {
                input = image.getObjectContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFile(String imagePath, String localPath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            client.getObject(new GetObjectRequest(imagePath.substring(7, imagePath.lastIndexOf("oss-cn-hangzhou") - 1), imagePath.substring(imagePath.lastIndexOf("aliyuncs.com/") + 13)), new File(localPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    public static void deleteFile(String filePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            client.deleteObject(ossBucketName, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String bucketName, String key) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            if (key.indexOf("http") != -1) {
                key = OssHelper.getFileNameByUrl(key);
            }
            client.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    public static boolean doesObjectExist(String key) {
        OSSClient client = null;
        boolean result = false;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            if (key.indexOf("http") != -1) {
                key = OssHelper.getFileNameByUrl(key);
            }
            result = client.doesObjectExist(ossBucketName, key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return result;
    }

    private static String getFileNameByUrl(String fileUrl) {
        int beginIndex = fileUrl.indexOf(accessUrl);
        int endIndex = fileUrl.indexOf("?");
        int endIndex2 = fileUrl.indexOf("@!");
        if (beginIndex == -1) {
            return null;
        }
        if (endIndex != -1) {
            return fileUrl.substring(beginIndex + accessUrl.length(), endIndex);
        }
        if (endIndex2 != -1) {
            return fileUrl.substring(beginIndex + accessUrl.length(), endIndex2);
        }
        return fileUrl.substring(beginIndex + accessUrl.length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOssPolicy() {
        OSSClient client = null;
        String dir = "front";
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = client.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", accessKeyId);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", accessUrl);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            String string = JSONObject.toJSONString(respMap);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
        return null;
    }

    public static AssumeRoleResponse getStsPolicy() {
        String roleSessionName = "session-name";
        String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        try {
            DefaultProfile.addEndpoint((String)"", (String)"", (String)ossBucketName, (String)ossEndPoint);
            DefaultProfile profile = DefaultProfile.getProfile((String)region, (String)authAccessKeyId, (String)authAccessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            return response;
        }
        catch (Exception e) {
            System.out.println("Failed\uff1a" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(File file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            FileInputStream input = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(byte[] file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)new ByteArrayInputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(InputStream input, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, input, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    private static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }

    public static String genImageName(String suffix) {
        String extName = suffix.substring(suffix.lastIndexOf("."));
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    public static String getImagePath(String imageName) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String format = df.format(LocalDateTime.now());
        return format + "/" + imageName;
    }

    public static String getOssBucketName() {
        return ossBucketName;
    }

    public static String getOssEndPoint() {
        return ossEndPoint;
    }

    public static String getAccessUrl() {
        return accessUrl;
    }

    static {
        accessKeyId = "VlIWf14iFwijpUGZ";
        accessKeySecret = "8nJA7UYmX9GpxnsiORR56SA5MkoiqH";
        ossEndPoint = "http://oss-cn-hangzhou.aliyuncs.com";
        ossBucketName = "ovopark";
        accessUrl = "http://ovopark.oss-cn-hangzhou.aliyuncs.com";
    }
}

