/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils.redis;

import com.ovopark.shoppaper.utils.redis.Cache;
import com.ovopark.shoppaper.utils.redis.IDataLoader;

public abstract class BaseCacheFactory
implements Cache {
    public <T> T get(String cacheName, Object key, IDataLoader iLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = iLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    public <T> T get(String cacheName, Object key, Class<? extends IDataLoader> iLoaderClass) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            try {
                IDataLoader dataLoader = iLoaderClass.newInstance();
                data = dataLoader.load();
                this.put(cacheName, key, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }
}

