/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StringsUtils {
    public static List<String> stringToList(String strArr) {
        return Arrays.stream(strArr.split(",")).map(s -> s.trim()).collect(Collectors.toList());
    }

    public static String ListToString(List list, String sign) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List list1 = list.stream().map(x -> x + "").collect(Collectors.toList());
        return list1.stream().collect(Collectors.joining(","));
    }

    public static String tripSign(String str) {
        return str.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
    }

    public static String addSign(String str, int line, String sign) {
        String regex = "\\S{" + line + "}(?!$)";
        String result = str.replaceAll(regex, "$0" + sign);
        return result;
    }

    public static void main(String[] args) {
        System.out.println("mac\u8f6c\u6362:" + StringsUtils.addSign("2002afb63177", 2, ":"));
    }

    public static List<Integer> StringToList(String content, String split) {
        ArrayList<Integer> reuslt = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)content)) {
            String[] arr;
            for (String obj : arr = content.split(split)) {
                if (StringUtils.isEmpty((Object)obj) || reuslt.contains(Integer.parseInt(obj.trim()))) continue;
                reuslt.add(Integer.parseInt(obj.trim()));
            }
        }
        return reuslt;
    }

    public static List<String> String2List(String content, String split) {
        ArrayList<String> reuslt = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)content)) {
            String[] arr;
            for (String obj : arr = content.split(split)) {
                if (StringUtils.isEmpty((Object)obj)) continue;
                reuslt.add(obj);
            }
        }
        return reuslt;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringsUtils.join(collection.iterator(), separator);
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(first);
        }
        StringBuffer buf = new StringBuffer(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = StringsUtils.getCardinalityMap(a);
        Map mapb = StringsUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.min(StringsUtils.getFreq(obj, mapa), StringsUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer count = (Integer)freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public static Map getCardinalityMap(Collection coll) {
        HashMap count = new HashMap();
        for (Object obj : coll) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, new Integer(1));
                continue;
            }
            count.put(obj, new Integer(c + 1));
        }
        return count;
    }

    private static class ObjectUtils {
        public static final Null NULL = new Null();

        public static Object defaultIfNull(Object object, Object defaultValue) {
            return object != null ? object : defaultValue;
        }

        public static boolean equals(Object object1, Object object2) {
            if (object1 == object2) {
                return true;
            }
            if (object1 == null || object2 == null) {
                return false;
            }
            return object1.equals(object2);
        }

        public static int hashCode(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        public static String identityToString(Object object) {
            if (object == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            ObjectUtils.identityToString(buffer, object);
            return buffer.toString();
        }

        public static void identityToString(StringBuffer buffer, Object object) {
            if (object == null) {
                throw new NullPointerException("Cannot get the toString of a null identity");
            }
            buffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
        }

        public static StringBuffer appendIdentityToString(StringBuffer buffer, Object object) {
            if (object == null) {
                return null;
            }
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            return buffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
        }

        public static String toString(Object obj) {
            return obj == null ? "" : obj.toString();
        }

        public static String toString(Object obj, String nullStr) {
            return obj == null ? nullStr : obj.toString();
        }

        public static Object min(Comparable c1, Comparable c2) {
            if (c1 != null && c2 != null) {
                return c1.compareTo(c2) < 1 ? c1 : c2;
            }
            return c1 != null ? c1 : c2;
        }

        public static Object max(Comparable c1, Comparable c2) {
            if (c1 != null && c2 != null) {
                return c1.compareTo(c2) >= 0 ? c1 : c2;
            }
            return c1 != null ? c1 : c2;
        }

        public static class Null
        implements Serializable {
            private static final long serialVersionUID = 7092611880189329093L;

            Null() {
            }

            private Object readResolve() {
                return NULL;
            }
        }
    }
}

