/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ovopark.shoppaper.utils.oss.OssHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(QrCodeUtil.class);
    private static final Map<EncodeHintType, ErrorCorrectionLevel> encodeMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
    private static final Map<DecodeHintType, ErrorCorrectionLevel> decodeMap = new HashMap<DecodeHintType, ErrorCorrectionLevel>();
    private static final String charset = "UTF-8";
    private static final String format = "png";
    private static final int size = 150;
    private static final int size1 = 200;

    public static String createQRCode3(String url) throws WriterException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)new MultiFormatWriter().encode(new String(url.getBytes(charset), charset), BarcodeFormat.QR_CODE, 200, 200, encodeMap), (String)format, (OutputStream)os);
        byte[] bytes = os.toByteArray();
        ByteArrayInputStream ips = new ByteArrayInputStream(bytes);
        String picUrl = OssHelper.uploadFileNew(ips, ".png");
        try {
            ((InputStream)ips).close();
        }
        catch (IOException e) {
            log.error("\u3010\u751f\u6210\u4e8c\u7ef4\u7801\u56fe\u7247\u4e0a\u4f20\u5230OSS\u3011:\u4e0a\u4f20\u5b57\u8282\u6d41\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        return picUrl;
    }
}

