/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shoppaper.utils.redis;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ovopark.shoppaper.utils.redis.Redis;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisFactory
implements Redis {
    private static final Logger log = LoggerFactory.getLogger(RedisFactory.class);
    private static JedisPool jedisPool = null;
    private static JedisPool jedisPool2nd = null;
    private static int default_db = 0;
    private static ShardedJedisPool shardedJedisPool = null;

    public static RedisFactory createRedis() {
        return CoCoRedis.instance.init();
    }

    public static void loadConfig(Map<String, String> map) {
        try {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(Integer.valueOf(map.get("rMaxTotal")).intValue());
            config.setMaxIdle(Integer.valueOf(map.get("rMaxIdle")).intValue());
            config.setMaxWaitMillis(Long.valueOf(map.get("rMaxWith")).longValue());
            config.setMinEvictableIdleTimeMillis(Long.valueOf(map.get("rMinEvict")).longValue());
            config.setMaxIdle(Integer.valueOf(map.get("rMinidle")).intValue());
            config.setNumTestsPerEvictionRun(Integer.valueOf(map.get("rNumTests")).intValue());
            config.setTestOnBorrow(Boolean.valueOf(map.get("rTestOnB")).booleanValue());
            config.setTestOnReturn(Boolean.valueOf(map.get("rTestOnReturn")).booleanValue());
            config.setTestWhileIdle(Boolean.valueOf(map.get("rTestWhileIdle")).booleanValue());
            config.setTimeBetweenEvictionRunsMillis((long)Integer.valueOf(map.get("rTimeBetweenEvict")).intValue());
            config.setBlockWhenExhausted(Boolean.valueOf(map.get("rBlocakWhen")).booleanValue());
            jedisPool = new JedisPool((GenericObjectPoolConfig)config, map.get("rHost"), Integer.valueOf(map.get("rPort")).intValue(), 10000, map.get("rPassword"));
            log.info("\u521d\u59cb\u5316Redis\u8fde\u63a5\u6c60success");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316Redis\u8fde\u63a5\u6c60 \u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static synchronized JedisPool getJedisPool() {
        return jedisPool;
    }

    public static synchronized JedisPool getJedisPool2nd() {
        return jedisPool2nd;
    }

    public static synchronized Jedis getJedis(JedisPool jedisPool) {
        try {
            if (jedisPool != null) {
                Jedis resource = jedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis\u7f13\u5b58\u83b7\u53d6Jedis\u5b9e\u4f8b \u51fa\u9519\uff01", (Throwable)e);
            return null;
        }
    }

    public static synchronized Jedis getJedis2nd() {
        try {
            if (jedisPool2nd != null) {
                Jedis resource = jedisPool2nd.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis\u7f13\u5b58\u83b7\u53d6Jedis2nd\u5b9e\u4f8b \u51fa\u9519\uff01", (Throwable)e);
            return null;
        }
    }

    public static ShardedJedis getShardedJedis() {
        try {
            if (shardedJedisPool != null) {
                ShardedJedis resource = shardedJedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis\u7f13\u5b58\u83b7\u53d6shardedJedis\u5b9e\u4f8b \u51fa\u9519\uff01", (Throwable)e);
            return null;
        }
    }

    public static void closeResource(JedisPool jedisPool, Jedis jedis) throws Exception {
        if (jedisPool == null) {
            throw new Exception("This redis haden't been configed, please check your configuration files.");
        }
        if (jedis != null) {
            jedisPool.returnResource(jedis);
        }
    }

    public static void closeResource(ShardedJedis shardedJedis) {
        if (shardedJedis != null) {
            shardedJedisPool.returnResource(shardedJedis);
        }
    }

    @Override
    public boolean set(JedisPool jedisPool, Object key, String value) throws Exception {
        return this.set(jedisPool, key, value, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(JedisPool jedisPool, Object key, String value, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set(key.toString().toLowerCase(), value);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public boolean set(JedisPool jedisPool, Object key, String value, String nxxx, String expx, long time) throws Exception {
        return this.set(jedisPool, key, value, nxxx, expx, time, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(JedisPool jedisPool, Object key, String value, String nxxx, String expx, long time, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set(key.toString().toLowerCase(), value, nxxx, expx, time);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> boolean setPoJo(JedisPool jedisPool, Object key, Object pojo) throws Exception {
        return this.setPoJo(jedisPool, key, pojo, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean setPoJo(JedisPool jedisPool, Object key, Object pojo, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = new Gson().toJson(pojo);
                jedis.set(key.toString().toLowerCase(), json);
            }
            boolean json = true;
            return json;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> boolean setPoJo(JedisPool jedisPool, Object key, Object pojo, String nxxx, String expx, long time) throws Exception {
        return this.setPoJo(jedisPool, key, pojo, nxxx, expx, time, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean setPoJo(JedisPool jedisPool, Object key, Object pojo, String nxxx, String expx, long time, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = new Gson().toJson(pojo);
                jedis.set(key.toString().toLowerCase(), json, nxxx, expx, time);
            }
            boolean json = true;
            return json;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> boolean setlist(JedisPool jedisPool, Object key, List<T> list) throws Exception {
        return this.setlist(jedisPool, key, list, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean setlist(JedisPool jedisPool, Object key, List<T> list, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = new Gson().toJson(list);
                jedis.set(key.toString().toLowerCase(), json);
            }
            boolean json = true;
            return json;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> boolean setlist(JedisPool jedisPool, Object key, List<T> list, String nxxx, String expx, long time) throws Exception {
        return this.setlist(jedisPool, key, list, nxxx, expx, time, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean setlist(JedisPool jedisPool, Object key, List<T> list, String nxxx, String expx, long time, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = new Gson().toJson(list);
                jedis.set(key.toString().toLowerCase(), json, nxxx, expx, time);
            }
            boolean json = true;
            return json;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public Object get(JedisPool jedisPool, Object key) throws Exception {
        return this.get(jedisPool, key, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(JedisPool jedisPool, Object key, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String string = jedis.get(key.toString().toLowerCase());
                return string;
            }
            Object var5_6 = null;
            return var5_6;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c\u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> T get(JedisPool jedisPool, Object key, Class<T> clazz) throws Exception {
        return this.get(jedisPool, key, clazz, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(JedisPool jedisPool, Object key, Class<T> clazz, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Object object = new Gson().fromJson(jedis.get(key.toString().toLowerCase()), clazz);
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            T t = null;
            return t;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> List<T> getList(JedisPool jedisPool, Object key) throws Exception {
        return this.getList(jedisPool, key, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getList(JedisPool jedisPool, Object key, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                List list = (List)new Gson().fromJson(jedis.get(key.toString().toLowerCase()), new TypeToken<List<T>>(){}.getType());
                return list;
            }
            List<T> list = null;
            return list;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            List<T> list = null;
            return list;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public boolean setHashSet(JedisPool jedisPool, Object key, String ... members) throws Exception {
        return this.setHashSet(jedisPool, key, default_db, members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setHashSet(JedisPool jedisPool, Object key, int index, String ... members) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.sadd(key.toString().toLowerCase(), members);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u7684set\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public Set<String> getHashSet(JedisPool jedisPool, Object key) throws Exception {
        return this.getHashSet(jedisPool, key, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getHashSet(JedisPool jedisPool, Object key, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Set set = jedis.smembers(key.toString().toLowerCase());
                return set;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u7684Set\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public boolean isHashSetMember(JedisPool jedisPool, Object key, Object value) throws Exception {
        return this.isHashSetMember(jedisPool, key, value, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHashSetMember(JedisPool jedisPool, Object key, Object value, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                boolean bl = jedis.sismember(key.toString().toLowerCase(), (String)value);
                return bl;
            }
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u67e5\u8be2key\u503c \u3010" + key + "\u3011\u7684set\u4e2d\u662f\u5426\u5b58\u5728\u6307\u5b9a\u5143\u7d20\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
        return false;
    }

    @Override
    public Long getHashSetSize(JedisPool jedisPool, Object key) throws Exception {
        return this.getHashSetSize(jedisPool, key, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getHashSetSize(JedisPool jedisPool, Object key, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.scard(key.toString().toLowerCase());
                return l;
            }
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u67e5\u8be2key\u503c \u3010" + key + "\u3011\u7684set\u7684size\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setExpireForKey(JedisPool jedisPool, Object key, Long millisecondsTimestamp, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.pexpireAt(key.toString().toLowerCase(), millisecondsTimestamp.longValue());
                return l;
            }
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u67e5\u8be2key\u503c \u3010" + key + "\u3011\u7684set\u7684size\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long removeFormHashSet(JedisPool jedisPool, Object key, int index, String ... members) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.srem(key.toString().toLowerCase(), members);
                return l;
            }
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u67e5\u8be2key\u503c \u3010" + key + "\u3011\u7684set\u7684size\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
        return 0L;
    }

    @Override
    public Long del(JedisPool jedisPool, Object key) throws Exception {
        return this.del(jedisPool, key, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(JedisPool jedisPool, Object key, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.del(key.toString().toLowerCase());
                return l;
            }
            Long l = 0L;
            return l;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u5220\u9664key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public Set<String> keys(JedisPool jedisPool, String pattern) throws Exception {
        return this.keys(jedisPool, pattern, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keys(JedisPool jedisPool, String pattern, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Set set = jedis.keys(pattern);
                return set;
            }
            Set<String> set = null;
            return set;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6pattern\u503c\u3010" + pattern + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Set<String> set = null;
            return set;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public boolean setExpire(JedisPool jedisPool, Object key, String value, int time) throws Exception {
        return this.setExpire(jedisPool, key, value, time, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setExpire(JedisPool jedisPool, Object key, String value, int time, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set(key.toString().toLowerCase(), value);
                jedis.expire(key.toString().toLowerCase(), time);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> boolean setPoJoExpire(JedisPool jedisPool, Object key, Object pojo, int time) throws Exception {
        return this.setPoJoExpire(jedisPool, key, pojo, time, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean setPoJoExpire(JedisPool jedisPool, Object key, Object pojo, int time, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = new Gson().toJson(pojo);
                jedis.set(key.toString().toLowerCase(), json);
                jedis.expire(key.toString().toLowerCase(), time);
            }
            boolean json = true;
            return json;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public <T> boolean setlistExpire(JedisPool jedisPool, Object key, List<T> list, int time) throws Exception {
        return this.setPoJoExpire(jedisPool, key, list, time, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean setlistExpire(JedisPool jedisPool, Object key, List<T> list, int time, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = new Gson().toJson(list);
                jedis.set(key.toString().toLowerCase(), json);
                jedis.expire(key.toString().toLowerCase(), time);
            }
            boolean json = true;
            return json;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    @Override
    public Long ttl(JedisPool jedisPool, Object key) throws Exception {
        return this.ttl(jedisPool, key, default_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long ttl(JedisPool jedisPool, Object key, int index) throws Exception {
        Jedis jedis = RedisFactory.getJedis(jedisPool);
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.ttl(key.toString().toLowerCase());
                return l;
            }
            Long l = 0L;
            return l;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u5269\u4f59\u751f\u5b58\u65f6\u95f4\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            RedisFactory.closeResource(jedisPool, jedis);
        }
    }

    private static enum CoCoRedis {
        instance;

        private RedisFactory factory = new RedisFactory();

        private RedisFactory init() {
            return this.factory;
        }
    }
}

