/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import cn.hutool.core.collection.CollectionUtil;
import com.ovopark.check.common.ID;
import com.ovopark.check.core.CheckTaskRecordStatusEnum;
import com.ovopark.check.core.CheckTemplateRewardRule;
import com.ovopark.check.core.CheckTemplateStandardRule;
import com.ovopark.check.core.InspectionGroup;
import com.ovopark.check.core.InspectionItem;
import com.ovopark.check.core.RuledInspectionItem;
import com.ovopark.check.core.ScoreRule;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CheckTemplate
implements ID,
Serializable {
    private static final long serialVersionUID = -3332981582861777524L;
    private Integer id;
    private Integer version;
    private String name;
    private List<ScoreRule> rules;
    private Integer scoreType;
    private Integer revertScoreDisplay;
    private List<RuledInspectionItem> inspectionItems;
    private CheckTemplateRewardRule rewardRule;
    private List<InspectionGroup> inspectionGroups;
    @Deprecated
    private Integer isQualified;
    private CheckTaskRecordStatusEnum defaultRecordStatus = CheckTaskRecordStatusEnum.UNKNOWN;
    private CheckTemplateStandardRule checkTemplateStandardRule;

    public ScoreRule getScoreRule(Integer inspectionItemId) {
        Optional<ScoreRule> first = this.rules.stream().filter(e -> {
            for (RuledInspectionItem inspectionItem : e.getInspectionItems()) {
                if (!inspectionItem.getId().equals(inspectionItemId)) continue;
                return true;
            }
            return false;
        }).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        throw new RuntimeException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89c4\u5219");
    }

    public List<InspectionItem> getInspectionItems() {
        return this.inspectionGroups.stream().flatMap(inspectionGroup -> inspectionGroup.getItems().stream()).collect(Collectors.toList());
    }

    public boolean isHealthy() {
        return CollectionUtil.isNotEmpty(this.getInspectionItems()) && CollectionUtil.isNotEmpty(this.getInspectionGroups());
    }

    public String toString() {
        return "CheckTemplate{id=" + this.id + ", version=" + this.version + ", name='" + this.name + '\'' + ", inspectionGroups=" + this.inspectionGroups + '}';
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<ScoreRule> getRules() {
        return this.rules;
    }

    public Integer getScoreType() {
        return this.scoreType;
    }

    public Integer getRevertScoreDisplay() {
        return this.revertScoreDisplay;
    }

    public CheckTemplateRewardRule getRewardRule() {
        return this.rewardRule;
    }

    public List<InspectionGroup> getInspectionGroups() {
        return this.inspectionGroups;
    }

    @Deprecated
    public Integer getIsQualified() {
        return this.isQualified;
    }

    public CheckTaskRecordStatusEnum getDefaultRecordStatus() {
        return this.defaultRecordStatus;
    }

    public CheckTemplateStandardRule getCheckTemplateStandardRule() {
        return this.checkTemplateStandardRule;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRules(List<ScoreRule> rules) {
        this.rules = rules;
    }

    public void setScoreType(Integer scoreType) {
        this.scoreType = scoreType;
    }

    public void setRevertScoreDisplay(Integer revertScoreDisplay) {
        this.revertScoreDisplay = revertScoreDisplay;
    }

    public void setInspectionItems(List<RuledInspectionItem> inspectionItems) {
        this.inspectionItems = inspectionItems;
    }

    public void setRewardRule(CheckTemplateRewardRule rewardRule) {
        this.rewardRule = rewardRule;
    }

    public void setInspectionGroups(List<InspectionGroup> inspectionGroups) {
        this.inspectionGroups = inspectionGroups;
    }

    @Deprecated
    public void setIsQualified(Integer isQualified) {
        this.isQualified = isQualified;
    }

    public void setDefaultRecordStatus(CheckTaskRecordStatusEnum defaultRecordStatus) {
        this.defaultRecordStatus = defaultRecordStatus;
    }

    public void setCheckTemplateStandardRule(CheckTemplateStandardRule checkTemplateStandardRule) {
        this.checkTemplateStandardRule = checkTemplateStandardRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckTemplate)) {
            return false;
        }
        CheckTemplate other = (CheckTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ScoreRule> this$rules = this.getRules();
        List<ScoreRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        Integer this$scoreType = this.getScoreType();
        Integer other$scoreType = other.getScoreType();
        if (this$scoreType == null ? other$scoreType != null : !((Object)this$scoreType).equals(other$scoreType)) {
            return false;
        }
        Integer this$revertScoreDisplay = this.getRevertScoreDisplay();
        Integer other$revertScoreDisplay = other.getRevertScoreDisplay();
        if (this$revertScoreDisplay == null ? other$revertScoreDisplay != null : !((Object)this$revertScoreDisplay).equals(other$revertScoreDisplay)) {
            return false;
        }
        List<InspectionItem> this$inspectionItems = this.getInspectionItems();
        List<InspectionItem> other$inspectionItems = other.getInspectionItems();
        if (this$inspectionItems == null ? other$inspectionItems != null : !((Object)this$inspectionItems).equals(other$inspectionItems)) {
            return false;
        }
        CheckTemplateRewardRule this$rewardRule = this.getRewardRule();
        CheckTemplateRewardRule other$rewardRule = other.getRewardRule();
        if (this$rewardRule == null ? other$rewardRule != null : !((Object)this$rewardRule).equals(other$rewardRule)) {
            return false;
        }
        List<InspectionGroup> this$inspectionGroups = this.getInspectionGroups();
        List<InspectionGroup> other$inspectionGroups = other.getInspectionGroups();
        if (this$inspectionGroups == null ? other$inspectionGroups != null : !((Object)this$inspectionGroups).equals(other$inspectionGroups)) {
            return false;
        }
        Integer this$isQualified = this.getIsQualified();
        Integer other$isQualified = other.getIsQualified();
        if (this$isQualified == null ? other$isQualified != null : !((Object)this$isQualified).equals(other$isQualified)) {
            return false;
        }
        CheckTaskRecordStatusEnum this$defaultRecordStatus = this.getDefaultRecordStatus();
        CheckTaskRecordStatusEnum other$defaultRecordStatus = other.getDefaultRecordStatus();
        if (this$defaultRecordStatus == null ? other$defaultRecordStatus != null : !this$defaultRecordStatus.equals(other$defaultRecordStatus)) {
            return false;
        }
        CheckTemplateStandardRule this$checkTemplateStandardRule = this.getCheckTemplateStandardRule();
        CheckTemplateStandardRule other$checkTemplateStandardRule = other.getCheckTemplateStandardRule();
        return !(this$checkTemplateStandardRule == null ? other$checkTemplateStandardRule != null : !((Object)this$checkTemplateStandardRule).equals(other$checkTemplateStandardRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ScoreRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        Integer $scoreType = this.getScoreType();
        result = result * 59 + ($scoreType == null ? 43 : ((Object)$scoreType).hashCode());
        Integer $revertScoreDisplay = this.getRevertScoreDisplay();
        result = result * 59 + ($revertScoreDisplay == null ? 43 : ((Object)$revertScoreDisplay).hashCode());
        List<InspectionItem> $inspectionItems = this.getInspectionItems();
        result = result * 59 + ($inspectionItems == null ? 43 : ((Object)$inspectionItems).hashCode());
        CheckTemplateRewardRule $rewardRule = this.getRewardRule();
        result = result * 59 + ($rewardRule == null ? 43 : ((Object)$rewardRule).hashCode());
        List<InspectionGroup> $inspectionGroups = this.getInspectionGroups();
        result = result * 59 + ($inspectionGroups == null ? 43 : ((Object)$inspectionGroups).hashCode());
        Integer $isQualified = this.getIsQualified();
        result = result * 59 + ($isQualified == null ? 43 : ((Object)$isQualified).hashCode());
        CheckTaskRecordStatusEnum $defaultRecordStatus = this.getDefaultRecordStatus();
        result = result * 59 + ($defaultRecordStatus == null ? 43 : $defaultRecordStatus.hashCode());
        CheckTemplateStandardRule $checkTemplateStandardRule = this.getCheckTemplateStandardRule();
        result = result * 59 + ($checkTemplateStandardRule == null ? 43 : ((Object)$checkTemplateStandardRule).hashCode());
        return result;
    }
}

