/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CheckTaskSourceEnum;
import com.ovopark.check.core.CheckTaskTypeEnum;

public class CheckConvertor {
    public static Integer convertCheckType(CheckTaskTypeEnum type, CheckTaskSourceEnum source) {
        if (CheckTaskSourceEnum.PLAN == source) {
            if (type.getCode() == 0) {
                return 10;
            }
            if (type.getCode() == 1) {
                return 11;
            }
            if (type.getCode() == 12) {
                return 17;
            }
        }
        if (CheckTaskSourceEnum.TASK == source && type.getCode() == 0) {
            return 15;
        }
        return type.getCode();
    }

    public static Integer getSourceType(CheckTask task) {
        int sourceType = 8;
        switch (CheckConvertor.convertCheckType(task.getType(), task.getSource())) {
            case 2: {
                sourceType = 1;
                break;
            }
            case 1: 
            case 5: {
                sourceType = 9;
                break;
            }
            case 10: {
                sourceType = 14;
                break;
            }
            case 11: {
                sourceType = 13;
                break;
            }
            case 15: {
                sourceType = 15;
                break;
            }
            case 12: {
                sourceType = 12;
                break;
            }
            case 17: {
                sourceType = 17;
                break;
            }
        }
        return sourceType;
    }

    public static CheckTaskTypeEnum getCheckTypeFromDb(Integer checkType) {
        if (checkType == 10) {
            return CheckTaskTypeEnum.LIVE_CHECK;
        }
        if (checkType == 11) {
            return CheckTaskTypeEnum.REMOTE_CHECK;
        }
        if (checkType == 17) {
            return CheckTaskTypeEnum.SELF_CHECK;
        }
        if (checkType == 15) {
            return CheckTaskTypeEnum.LIVE_CHECK;
        }
        return CheckTaskTypeEnum.of(checkType);
    }

    public static CheckTaskSourceEnum getCheckSourceFromDb(Integer checkType) {
        if (checkType == 10) {
            return CheckTaskSourceEnum.of(1);
        }
        if (checkType == 11) {
            return CheckTaskSourceEnum.of(1);
        }
        if (checkType == 17) {
            return CheckTaskSourceEnum.of(1);
        }
        if (checkType == 15) {
            return CheckTaskSourceEnum.of(2);
        }
        return CheckTaskSourceEnum.of(0);
    }

    public static int getBaseSourceType(Integer sourceType) {
        switch (sourceType) {
            case 13: {
                return 9;
            }
            case 14: 
            case 15: {
                return 8;
            }
            case 17: {
                return 12;
            }
        }
        return sourceType;
    }

    public static Double calMoney(Integer moneyType, Double money) {
        if (moneyType != null && money != null) {
            if (moneyType == 0) {
                return money;
            }
            return -money.doubleValue();
        }
        return 0.0;
    }
}

