/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator;

import cn.hutool.core.collection.CollectionUtil;
import com.ovopark.check.core.Score;
import com.ovopark.check.core.calculator.FinalSideEffect;
import com.ovopark.check.core.calculator.Group;
import com.ovopark.check.core.calculator.InspectionRecord;
import com.ovopark.check.core.calculator.InspectionStatusEnum;
import com.ovopark.check.core.calculator.ScoreCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class CustomScoreCalculator
extends ScoreCalculator {
    private final List<Group> groups;
    private List<FinalSideEffect> finalSideEffects;
    private List<InspectionRecord> records;
    private Integer scoreType;

    public CustomScoreCalculator(List<Group> groups, Integer scoreType) {
        this.groups = groups;
        this.scoreType = scoreType;
        for (Group group : groups) {
            group.setCustomScoreCalculator(this);
        }
    }

    private void pollute(List<Group> groups, List<InspectionRecord> records) {
        for (Group group : groups) {
            group.matchAndSeparate(records);
        }
    }

    public void addSideEffect(FinalSideEffect sideEffect) {
        if (this.finalSideEffects == null) {
            this.finalSideEffects = new ArrayList<FinalSideEffect>();
        }
        this.finalSideEffects.add(sideEffect);
    }

    @Override
    public ScoreCalculator feed(List<InspectionRecord> records) {
        this.finalSideEffects = null;
        this.records = records;
        this.pollute(this.groups, records);
        return this;
    }

    @Override
    public Score calculate(boolean verbose) {
        if (CollectionUtils.isEmpty(this.records)) {
            throw new IllegalStateException("Calculator: please call method ScoreCalculator#feed before cal");
        }
        Score score = new Score();
        List<Score> groupScores = this.groups.stream().map(Group::getScore).collect(Collectors.toList());
        groupScores = groupScores.stream().filter(e -> e.getId() != -1).collect(Collectors.toList());
        score.setChildren(groupScores);
        double all = groupScores.stream().mapToDouble(Score::getTotalScore).sum();
        score.setTotalScore(all);
        score.setSketchyScore(this.sumScore(this.records, InspectionRecord::getScore));
        double finalRedudence = 0.0;
        double finalReturnRedudence = 0.0;
        if (CollectionUtil.isNotEmpty(this.finalSideEffects)) {
            for (FinalSideEffect sf : this.finalSideEffects) {
                if (sf.getGroupId() == -1) continue;
                Score groupScore = score.getScore(sf.getGroupId(), Score.Level.GROUP);
                double gs = groupScore.getScore() - sf.getRedudence();
                groupScore.setScore(Math.max(gs, 0.0));
                if (gs < 0.0) {
                    finalRedudence += -gs;
                }
                double returnGs = groupScore.getReturnScore() - sf.getRedudence();
                groupScore.setReturnScore(Math.max(returnGs, 0.0));
                if (!(returnGs < 0.0)) continue;
                finalReturnRedudence += -returnGs;
            }
        }
        double sum = score.getChildren().stream().mapToDouble(Score::getScore).sum();
        score.setScore(Math.max(0.0, sum - finalRedudence));
        double returnSum = score.getChildren().stream().mapToDouble(Score::getReturnScore).sum();
        score.setReturnScore(Math.max(0.0, returnSum - finalReturnRedudence));
        double unknownSum = this.records.stream().filter(e -> e.getStatus() == InspectionStatusEnum.UNKNOWN).mapToDouble(InspectionRecord::getTotalScore).filter(Objects::nonNull).sum();
        score.setRedudenceScore(Math.max(score.getTotalScore() - unknownSum - score.getScore(), 0.0));
        return score;
    }

    public boolean isAddModel() {
        return Objects.equals(1, this.scoreType);
    }

    private Double sumScore(List<InspectionRecord> records, ToDoubleFunction<InspectionRecord> function) {
        return records.stream().filter(e -> e.getStatus() != InspectionStatusEnum.INAPPLICABLE).mapToDouble(function).sum();
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<FinalSideEffect> getFinalSideEffects() {
        return this.finalSideEffects;
    }

    public List<InspectionRecord> getRecords() {
        return this.records;
    }

    public Integer getScoreType() {
        return this.scoreType;
    }

    public void setFinalSideEffects(List<FinalSideEffect> finalSideEffects) {
        this.finalSideEffects = finalSideEffects;
    }

    public void setRecords(List<InspectionRecord> records) {
        this.records = records;
    }

    public void setScoreType(Integer scoreType) {
        this.scoreType = scoreType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomScoreCalculator)) {
            return false;
        }
        CustomScoreCalculator other = (CustomScoreCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<FinalSideEffect> this$finalSideEffects = this.getFinalSideEffects();
        List<FinalSideEffect> other$finalSideEffects = other.getFinalSideEffects();
        if (this$finalSideEffects == null ? other$finalSideEffects != null : !((Object)this$finalSideEffects).equals(other$finalSideEffects)) {
            return false;
        }
        List<InspectionRecord> this$records = this.getRecords();
        List<InspectionRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Integer this$scoreType = this.getScoreType();
        Integer other$scoreType = other.getScoreType();
        return !(this$scoreType == null ? other$scoreType != null : !((Object)this$scoreType).equals(other$scoreType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CustomScoreCalculator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Group> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        List<FinalSideEffect> $finalSideEffects = this.getFinalSideEffects();
        result = result * 59 + ($finalSideEffects == null ? 43 : ((Object)$finalSideEffects).hashCode());
        List<InspectionRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Integer $scoreType = this.getScoreType();
        result = result * 59 + ($scoreType == null ? 43 : ((Object)$scoreType).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CustomScoreCalculator(groups=" + this.getGroups() + ", finalSideEffects=" + this.getFinalSideEffects() + ", records=" + this.getRecords() + ", scoreType=" + this.getScoreType() + ")";
    }
}

