/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CheckTaskRecordStatusEnum;
import com.ovopark.check.core.CheckTaskResultDetail;
import com.ovopark.check.core.Score;
import com.ovopark.check.core.ScoreValue;
import com.ovopark.check.support.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CheckTaskResult
implements Serializable {
    private Integer id;
    private CheckTask checkTask;
    private Integer submitNum = 1;
    private ScoreValue score = ScoreValue.NaN;
    private ScoreValue totalScore = ScoreValue.NaN;
    private ScoreValue extraScore = ScoreValue.NaN;
    private Double money = 0.0;
    private Double templateMoney = 0.0;
    private Boolean finished = false;
    private Double liveDurationSeconds;
    private Double totalDurationSeconds;
    private List<User> companies = new ArrayList<User>();
    private User reviewer;
    private Date reviewTime;
    private Boolean hasObjection = false;
    private String objection;
    private Integer templateEvaluation;
    private Score scoreDetail;
    private Boolean creatorCanReview = false;
    private List<CheckTaskResultDetail> details = new ArrayList<CheckTaskResultDetail>();

    public ScoreValue getPercentScore() {
        if (this.totalScore.isNaN().booleanValue() || this.totalScore.isZero().booleanValue() || this.score.isNaN().booleanValue()) {
            return ScoreValue.NaN;
        }
        return this.score.multiply(100.0).div(this.totalScore);
    }

    public String getMoneyStr() {
        if (this.money == null) {
            return "";
        }
        if (this.money == 0.0) {
            return "0";
        }
        if (this.money > 0.0) {
            return "+" + this.money;
        }
        return "" + this.money;
    }

    public Integer getTotalCount() {
        return (int)this.details.stream().filter(e -> e.getStatus() != CheckTaskRecordStatusEnum.INAPPLICABLE).count();
    }

    public Integer getQualifiedCount() {
        return (int)this.details.stream().filter(e -> e.getStatus() == CheckTaskRecordStatusEnum.QUALIFIED).count();
    }

    public Integer getUnqualifiedCount() {
        return (int)this.details.stream().filter(e -> e.getStatus() == CheckTaskRecordStatusEnum.UNQUALIFIED).count();
    }

    public Integer getInapplicableCount() {
        return (int)this.details.stream().filter(e -> e.getStatus() == CheckTaskRecordStatusEnum.INAPPLICABLE).count();
    }

    public Integer getId() {
        return this.id;
    }

    public CheckTask getCheckTask() {
        return this.checkTask;
    }

    public Integer getSubmitNum() {
        return this.submitNum;
    }

    public ScoreValue getScore() {
        return this.score;
    }

    public ScoreValue getTotalScore() {
        return this.totalScore;
    }

    public ScoreValue getExtraScore() {
        return this.extraScore;
    }

    public Double getMoney() {
        return this.money;
    }

    public Double getTemplateMoney() {
        return this.templateMoney;
    }

    public Boolean getFinished() {
        return this.finished;
    }

    public Double getLiveDurationSeconds() {
        return this.liveDurationSeconds;
    }

    public Double getTotalDurationSeconds() {
        return this.totalDurationSeconds;
    }

    public List<User> getCompanies() {
        return this.companies;
    }

    public User getReviewer() {
        return this.reviewer;
    }

    public Date getReviewTime() {
        return this.reviewTime;
    }

    public Boolean getHasObjection() {
        return this.hasObjection;
    }

    public String getObjection() {
        return this.objection;
    }

    public Integer getTemplateEvaluation() {
        return this.templateEvaluation;
    }

    public Score getScoreDetail() {
        return this.scoreDetail;
    }

    public Boolean getCreatorCanReview() {
        return this.creatorCanReview;
    }

    public List<CheckTaskResultDetail> getDetails() {
        return this.details;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setCheckTask(CheckTask checkTask) {
        this.checkTask = checkTask;
    }

    public void setSubmitNum(Integer submitNum) {
        this.submitNum = submitNum;
    }

    public void setScore(ScoreValue score) {
        this.score = score;
    }

    public void setTotalScore(ScoreValue totalScore) {
        this.totalScore = totalScore;
    }

    public void setExtraScore(ScoreValue extraScore) {
        this.extraScore = extraScore;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public void setTemplateMoney(Double templateMoney) {
        this.templateMoney = templateMoney;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    public void setLiveDurationSeconds(Double liveDurationSeconds) {
        this.liveDurationSeconds = liveDurationSeconds;
    }

    public void setTotalDurationSeconds(Double totalDurationSeconds) {
        this.totalDurationSeconds = totalDurationSeconds;
    }

    public void setCompanies(List<User> companies) {
        this.companies = companies;
    }

    public void setReviewer(User reviewer) {
        this.reviewer = reviewer;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public void setHasObjection(Boolean hasObjection) {
        this.hasObjection = hasObjection;
    }

    public void setObjection(String objection) {
        this.objection = objection;
    }

    public void setTemplateEvaluation(Integer templateEvaluation) {
        this.templateEvaluation = templateEvaluation;
    }

    public void setScoreDetail(Score scoreDetail) {
        this.scoreDetail = scoreDetail;
    }

    public void setCreatorCanReview(Boolean creatorCanReview) {
        this.creatorCanReview = creatorCanReview;
    }

    public void setDetails(List<CheckTaskResultDetail> details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckTaskResult)) {
            return false;
        }
        CheckTaskResult other = (CheckTaskResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        CheckTask this$checkTask = this.getCheckTask();
        CheckTask other$checkTask = other.getCheckTask();
        if (this$checkTask == null ? other$checkTask != null : !((Object)this$checkTask).equals(other$checkTask)) {
            return false;
        }
        Integer this$submitNum = this.getSubmitNum();
        Integer other$submitNum = other.getSubmitNum();
        if (this$submitNum == null ? other$submitNum != null : !((Object)this$submitNum).equals(other$submitNum)) {
            return false;
        }
        ScoreValue this$score = this.getScore();
        ScoreValue other$score = other.getScore();
        if (this$score == null ? other$score != null : !this$score.equals(other$score)) {
            return false;
        }
        ScoreValue this$totalScore = this.getTotalScore();
        ScoreValue other$totalScore = other.getTotalScore();
        if (this$totalScore == null ? other$totalScore != null : !this$totalScore.equals(other$totalScore)) {
            return false;
        }
        ScoreValue this$extraScore = this.getExtraScore();
        ScoreValue other$extraScore = other.getExtraScore();
        if (this$extraScore == null ? other$extraScore != null : !this$extraScore.equals(other$extraScore)) {
            return false;
        }
        Double this$money = this.getMoney();
        Double other$money = other.getMoney();
        if (this$money == null ? other$money != null : !((Object)this$money).equals(other$money)) {
            return false;
        }
        Double this$templateMoney = this.getTemplateMoney();
        Double other$templateMoney = other.getTemplateMoney();
        if (this$templateMoney == null ? other$templateMoney != null : !((Object)this$templateMoney).equals(other$templateMoney)) {
            return false;
        }
        Boolean this$finished = this.getFinished();
        Boolean other$finished = other.getFinished();
        if (this$finished == null ? other$finished != null : !((Object)this$finished).equals(other$finished)) {
            return false;
        }
        Double this$liveDurationSeconds = this.getLiveDurationSeconds();
        Double other$liveDurationSeconds = other.getLiveDurationSeconds();
        if (this$liveDurationSeconds == null ? other$liveDurationSeconds != null : !((Object)this$liveDurationSeconds).equals(other$liveDurationSeconds)) {
            return false;
        }
        Double this$totalDurationSeconds = this.getTotalDurationSeconds();
        Double other$totalDurationSeconds = other.getTotalDurationSeconds();
        if (this$totalDurationSeconds == null ? other$totalDurationSeconds != null : !((Object)this$totalDurationSeconds).equals(other$totalDurationSeconds)) {
            return false;
        }
        List<User> this$companies = this.getCompanies();
        List<User> other$companies = other.getCompanies();
        if (this$companies == null ? other$companies != null : !((Object)this$companies).equals(other$companies)) {
            return false;
        }
        User this$reviewer = this.getReviewer();
        User other$reviewer = other.getReviewer();
        if (this$reviewer == null ? other$reviewer != null : !((Object)this$reviewer).equals(other$reviewer)) {
            return false;
        }
        Date this$reviewTime = this.getReviewTime();
        Date other$reviewTime = other.getReviewTime();
        if (this$reviewTime == null ? other$reviewTime != null : !((Object)this$reviewTime).equals(other$reviewTime)) {
            return false;
        }
        Boolean this$hasObjection = this.getHasObjection();
        Boolean other$hasObjection = other.getHasObjection();
        if (this$hasObjection == null ? other$hasObjection != null : !((Object)this$hasObjection).equals(other$hasObjection)) {
            return false;
        }
        String this$objection = this.getObjection();
        String other$objection = other.getObjection();
        if (this$objection == null ? other$objection != null : !this$objection.equals(other$objection)) {
            return false;
        }
        Integer this$templateEvaluation = this.getTemplateEvaluation();
        Integer other$templateEvaluation = other.getTemplateEvaluation();
        if (this$templateEvaluation == null ? other$templateEvaluation != null : !((Object)this$templateEvaluation).equals(other$templateEvaluation)) {
            return false;
        }
        Score this$scoreDetail = this.getScoreDetail();
        Score other$scoreDetail = other.getScoreDetail();
        if (this$scoreDetail == null ? other$scoreDetail != null : !((Object)this$scoreDetail).equals(other$scoreDetail)) {
            return false;
        }
        Boolean this$creatorCanReview = this.getCreatorCanReview();
        Boolean other$creatorCanReview = other.getCreatorCanReview();
        if (this$creatorCanReview == null ? other$creatorCanReview != null : !((Object)this$creatorCanReview).equals(other$creatorCanReview)) {
            return false;
        }
        List<CheckTaskResultDetail> this$details = this.getDetails();
        List<CheckTaskResultDetail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckTaskResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        CheckTask $checkTask = this.getCheckTask();
        result = result * 59 + ($checkTask == null ? 43 : ((Object)$checkTask).hashCode());
        Integer $submitNum = this.getSubmitNum();
        result = result * 59 + ($submitNum == null ? 43 : ((Object)$submitNum).hashCode());
        ScoreValue $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : $score.hashCode());
        ScoreValue $totalScore = this.getTotalScore();
        result = result * 59 + ($totalScore == null ? 43 : $totalScore.hashCode());
        ScoreValue $extraScore = this.getExtraScore();
        result = result * 59 + ($extraScore == null ? 43 : $extraScore.hashCode());
        Double $money = this.getMoney();
        result = result * 59 + ($money == null ? 43 : ((Object)$money).hashCode());
        Double $templateMoney = this.getTemplateMoney();
        result = result * 59 + ($templateMoney == null ? 43 : ((Object)$templateMoney).hashCode());
        Boolean $finished = this.getFinished();
        result = result * 59 + ($finished == null ? 43 : ((Object)$finished).hashCode());
        Double $liveDurationSeconds = this.getLiveDurationSeconds();
        result = result * 59 + ($liveDurationSeconds == null ? 43 : ((Object)$liveDurationSeconds).hashCode());
        Double $totalDurationSeconds = this.getTotalDurationSeconds();
        result = result * 59 + ($totalDurationSeconds == null ? 43 : ((Object)$totalDurationSeconds).hashCode());
        List<User> $companies = this.getCompanies();
        result = result * 59 + ($companies == null ? 43 : ((Object)$companies).hashCode());
        User $reviewer = this.getReviewer();
        result = result * 59 + ($reviewer == null ? 43 : ((Object)$reviewer).hashCode());
        Date $reviewTime = this.getReviewTime();
        result = result * 59 + ($reviewTime == null ? 43 : ((Object)$reviewTime).hashCode());
        Boolean $hasObjection = this.getHasObjection();
        result = result * 59 + ($hasObjection == null ? 43 : ((Object)$hasObjection).hashCode());
        String $objection = this.getObjection();
        result = result * 59 + ($objection == null ? 43 : $objection.hashCode());
        Integer $templateEvaluation = this.getTemplateEvaluation();
        result = result * 59 + ($templateEvaluation == null ? 43 : ((Object)$templateEvaluation).hashCode());
        Score $scoreDetail = this.getScoreDetail();
        result = result * 59 + ($scoreDetail == null ? 43 : ((Object)$scoreDetail).hashCode());
        Boolean $creatorCanReview = this.getCreatorCanReview();
        result = result * 59 + ($creatorCanReview == null ? 43 : ((Object)$creatorCanReview).hashCode());
        List<CheckTaskResultDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "CheckTaskResult(id=" + this.getId() + ", checkTask=" + this.getCheckTask() + ", submitNum=" + this.getSubmitNum() + ", score=" + this.getScore() + ", totalScore=" + this.getTotalScore() + ", extraScore=" + this.getExtraScore() + ", money=" + this.getMoney() + ", templateMoney=" + this.getTemplateMoney() + ", finished=" + this.getFinished() + ", liveDurationSeconds=" + this.getLiveDurationSeconds() + ", totalDurationSeconds=" + this.getTotalDurationSeconds() + ", companies=" + this.getCompanies() + ", reviewer=" + this.getReviewer() + ", reviewTime=" + this.getReviewTime() + ", hasObjection=" + this.getHasObjection() + ", objection=" + this.getObjection() + ", templateEvaluation=" + this.getTemplateEvaluation() + ", scoreDetail=" + this.getScoreDetail() + ", creatorCanReview=" + this.getCreatorCanReview() + ", details=" + this.getDetails() + ")";
    }
}

