/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.ovopark.check.core.CheckTaskCheckIn;
import com.ovopark.check.core.CheckTaskCheckOut;
import com.ovopark.check.core.CheckTaskExtra;
import com.ovopark.check.core.CheckTaskRecord;
import com.ovopark.check.core.CheckTaskSignImages;
import com.ovopark.check.core.CheckTaskSourceEnum;
import com.ovopark.check.core.CheckTaskStatusEnum;
import com.ovopark.check.core.CheckTaskTypeEnum;
import com.ovopark.check.core.CheckTemplate;
import com.ovopark.check.core.ConfigSnap;
import com.ovopark.check.core.CooperateManager;
import com.ovopark.check.core.InspectionGroup;
import com.ovopark.check.core.MultiCommitStateEnum;
import com.ovopark.check.core.ScoreValue;
import com.ovopark.check.core.ShopInspectionConfig;
import com.ovopark.check.support.Department;
import com.ovopark.check.support.EnterpriseConfig;
import com.ovopark.check.support.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class CheckTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer id;
    private String name;
    private Department department;
    private List<CheckTaskRecord> records;
    private CheckTemplate template;
    private Date createTime;
    private Date endTime;
    private Date firstCommitTime;
    private Date revokeTime;
    private Integer delayMins = 0;
    private Integer isInRange;
    private CheckTaskTypeEnum type;
    private CheckTaskSourceEnum source = CheckTaskSourceEnum.NORMAL;
    CheckTaskStatusEnum status = CheckTaskStatusEnum.PROCESSING;
    MultiCommitStateEnum multiCommitState = MultiCommitStateEnum.NOT_COMMIT;
    private String summary;
    private List<User> companies;
    private Integer uuidStatus;
    private String uuidCommit;
    private String uuidCreate;
    private User onSiteUser;
    private User creator;
    private User realCreator;
    private Integer liveDurationSeconds = 0;
    private CheckTaskCheckIn checkIn;
    private CheckTaskCheckOut checkOut;
    private CheckTaskSignImages sign;
    private CheckTaskExtra extra;
    private Integer isCreateInRange;
    private String appendixContent;
    private String shiplog;
    Boolean objection;
    String objectionContent;
    private ConfigSnap config;
    private CooperateManager cooperate;
    private String address;
    private Double longitude;
    private Double latitude;
    private Double distance;
    private Integer refuseNum;
    private Date expireGmt8Time;
    private ScoreValue totalScore;
    private ScoreValue score;
    private Integer reviewAutoPass;
    @Deprecated
    private Integer reviewAutoDays;
    private Integer reviewAutoHours;
    private Integer reviewAutoSeconds;

    public void startCooperateCheck() {
        this.cooperate = new CooperateManager();
        this.cooperate.setTask(this);
    }

    public boolean isCooperate() {
        return this.cooperate != null;
    }

    public int durationMin() {
        return this.durationSec() / 60;
    }

    public int durationSec() {
        if (this.createTime == null || this.type == CheckTaskTypeEnum.INSP_CHECK) {
            return 0;
        }
        Date end = this.endTime;
        if (end == null || this.multiCommitState == MultiCommitStateEnum.WAIT_RECOMMIT) {
            end = this.department.getLocalDate();
        }
        if (this.revokeTime == null) {
            long timeDiff = DateUtil.between((Date)this.createTime, (Date)end, (DateUnit)DateUnit.SECOND);
            return (int)timeDiff;
        }
        long timeDiff = DateUtil.between((Date)this.createTime, (Date)this.firstCommitTime, (DateUnit)DateUnit.SECOND) + DateUtil.between((Date)this.revokeTime, (Date)end, (DateUnit)DateUnit.SECOND);
        return (int)timeDiff;
    }

    public int getLiveDurationSeconds() {
        if (this.liveDurationSeconds > this.durationSec()) {
            this.liveDurationSeconds = this.durationSec();
        }
        return this.liveDurationSeconds;
    }

    public CheckTaskRecord getRecord(Integer inspectionItemId) {
        if (CollectionUtils.isEmpty(this.records)) {
            return null;
        }
        for (CheckTaskRecord record : this.records) {
            if (!record.getInspectionItem().getId().equals(inspectionItemId)) continue;
            return record;
        }
        String ids = this.records.stream().map(CheckTaskRecord::getId).map(String::valueOf).collect(Collectors.joining(","));
        throw new RuntimeException("i18n.store.inspection.record.not.found");
    }

    public void finishVideoDownload(String unique, String path) {
        if (CollectionUtil.isEmpty(this.records)) {
            return;
        }
        this.records.stream().map(CheckTaskRecord::getVideos).flatMap(Collection::stream).filter(v -> Objects.equals(v.getDownloadReq(), unique)).forEach(v -> {
            v.setUrl(path);
            v.setIsFinish(StringUtils.isNotBlank((CharSequence)path) ? 1 : -1);
        });
    }

    public List<InspectionGroup> getInspectionGroups() {
        if (CollectionUtils.isEmpty(this.records)) {
            return new ArrayList<InspectionGroup>();
        }
        return this.records.stream().map(e -> e.getInspectionItem().getGroup()).distinct().sorted(Comparator.comparing(InspectionGroup::getOrder, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
    }

    public boolean isCompleted() {
        return this.status != CheckTaskStatusEnum.PROCESSING && this.status != CheckTaskStatusEnum.INVALID && this.status != CheckTaskStatusEnum.MANUAL_INVALID;
    }

    public boolean isInFinalState() {
        return this.status == CheckTaskStatusEnum.DONE || this.status == CheckTaskStatusEnum.REVIEW_COMPLETE || this.status == CheckTaskStatusEnum.AUTO_REVIEW_COMPLETE;
    }

    public boolean isTemplate() {
        return this.template != null;
    }

    public void done() {
        if (this.status != CheckTaskStatusEnum.PROCESSING && this.status != CheckTaskStatusEnum.FIRST_COMMIT && this.status != CheckTaskStatusEnum.REVIEW_REFUSE_MODIFIED) {
            throw new RuntimeException("i18n.task.cannot.be.completed");
        }
        if ((this.endTime == null || this.multiCommitState == MultiCommitStateEnum.NOT_COMMIT || this.revokeTime != null) && this.status != CheckTaskStatusEnum.REVIEW_REFUSE_MODIFIED) {
            this.endTime = this.department.getLocalDate();
        }
        this.status = CheckTaskStatusEnum.DONE;
        this.multiCommitState = MultiCommitStateEnum.FINAL_COMMIT;
    }

    public void waitReview() {
        if (this.status != CheckTaskStatusEnum.PROCESSING && this.status != CheckTaskStatusEnum.FIRST_COMMIT && this.status != CheckTaskStatusEnum.REVIEW_REFUSE_MODIFIED) {
            throw new RuntimeException("i18n.task.is.not.incomplete");
        }
        if ((this.endTime == null || this.multiCommitState == MultiCommitStateEnum.NOT_COMMIT || this.revokeTime != null) && this.status != CheckTaskStatusEnum.REVIEW_REFUSE_MODIFIED) {
            this.endTime = this.department.getLocalDate();
        }
        this.status = CheckTaskStatusEnum.WAIT_REVIEW;
        this.multiCommitState = MultiCommitStateEnum.FINAL_COMMIT;
        this.refuseNum = Optional.ofNullable(this.refuseNum).orElse(0);
    }

    public boolean isWaitReview() {
        return this.status == CheckTaskStatusEnum.WAIT_REVIEW;
    }

    public boolean isAutoReview() {
        return this.status == CheckTaskStatusEnum.AUTO_REVIEW_COMPLETE;
    }

    public String getName() {
        if (this.isTemplate()) {
            return this.template.getName();
        }
        return this.department.getName() + "-" + "|||" + "-" + DateUtil.format((Date)this.endTime, (String)"yyyy-MM-dd");
    }

    public void setRecords(List<CheckTaskRecord> records) {
        this.records = records;
        records.forEach(r -> r.setTask(this));
    }

    public Optional<Integer> getTemplateId() {
        return Optional.ofNullable(this.template).map(CheckTemplate::getId);
    }

    public boolean canOperate(User user) {
        return Objects.equals(this.creator.getId(), user.getId()) || this.isCooperate() && CollectionUtil.isNotEmpty(this.cooperate.getJoinedCooperators()) && this.cooperate.getJoinedCooperators().stream().anyMatch(u -> Objects.equals(u.getUser().getId(), user.getId()));
    }

    public void snapConfig(EnterpriseConfig config, ShopInspectionConfig shopInspectionConfig) {
        if (this.config == null) {
            this.config = new ConfigSnap();
        }
        ConfigSnap configSnap = this.config;
        configSnap.setAllowCooperate(shopInspectionConfig.getAllowCooperate());
        if (shopInspectionConfig.getAllowCooperate() != null && shopInspectionConfig.getAllowCooperate().booleanValue()) {
            configSnap.setAllowInvitedOutRange(shopInspectionConfig.getAllowInvitedOutRange());
            configSnap.setAllowLeadInspectorSubmit(shopInspectionConfig.getAllowLeadInspectorSubmit());
        }
        configSnap.setReviewerSignRequired(shopInspectionConfig.getReviewerSignRequired());
        switch (this.getType()) {
            case REMOTE_CHECK: {
                configSnap.setOnsiteUser(shopInspectionConfig.getOnsiteUserOptions());
                configSnap.setCc(config.getRemoteCheckCc() != false ? EnterpriseConfig.Options.DESIRE : EnterpriseConfig.Options.PROHIBIT);
                configSnap.setCompany(EnterpriseConfig.Options.PROHIBIT);
                configSnap.setAllowChangeReformer(config.getRemoteCheckAllowChangeReformer());
                configSnap.setLiveCheckTaskCheckInNecessary(config.getLiveCheckTaskCheckInNecessary());
                configSnap.setSelfCheckTaskCheckInNecessary(config.getSelfCheckTaskCheckInNecessary());
                configSnap.setLiveCheckTaskPosition(config.getLiveCheckTaskPosition());
                configSnap.setSelfCheckTaskPosition(config.getSelfCheckTaskPosition());
                configSnap.setMustSelectedDetailedRulesSwitch(config.getMustSelectedDetailedRulesSwitch());
                configSnap.setMustSelectedDetaileReviewSwitch(config.getMustSelectedDetaileReviewSwitch());
                break;
            }
            case LIVE_CHECK: {
                configSnap.setOnsiteUser(shopInspectionConfig.getOnsiteUserOptions());
                configSnap.setCc(config.getLiveCheckCc() != false ? EnterpriseConfig.Options.DESIRE : EnterpriseConfig.Options.PROHIBIT);
                configSnap.setCompany(config.getLiveCheckCompanyOpen() != false ? EnterpriseConfig.Options.DESIRE : EnterpriseConfig.Options.PROHIBIT);
                configSnap.setAllowChangeReformer(config.getLiveCheckAllowChangeReformer());
                configSnap.setLiveCheckTaskCheckInNecessary(config.getLiveCheckTaskCheckInNecessary());
                configSnap.setSelfCheckTaskCheckInNecessary(config.getSelfCheckTaskCheckInNecessary());
                configSnap.setLiveCheckTaskPosition(config.getLiveCheckTaskPosition());
                configSnap.setSelfCheckTaskPosition(config.getSelfCheckTaskPosition());
                configSnap.setLocationNecessary(config.getLiveCheckLocationNecessary());
                configSnap.setEvaluationNecessary(config.getLiveCheckEvaluationNecessary());
                configSnap.setSignNecessary(config.getLiveCheckSignNecessary());
                configSnap.setMustSelectedDetailedRulesSwitch(config.getMustSelectedDetailedRulesSwitch());
                configSnap.setMustSelectedDetaileReviewSwitch(config.getMustSelectedDetaileReviewSwitch());
                break;
            }
            case SELF_CHECK: {
                configSnap.setOnsiteUser(EnterpriseConfig.Options.PROHIBIT);
                configSnap.setCc(config.getSelfCheckCc() != false ? EnterpriseConfig.Options.DESIRE : EnterpriseConfig.Options.PROHIBIT);
                configSnap.setCompany(EnterpriseConfig.Options.PROHIBIT);
                configSnap.setAllowChangeReformer(config.getSelfCheckAllowChangeReformer());
                configSnap.setLiveCheckTaskCheckInNecessary(config.getLiveCheckTaskCheckInNecessary());
                configSnap.setSelfCheckTaskCheckInNecessary(config.getSelfCheckTaskCheckInNecessary());
                configSnap.setLiveCheckTaskPosition(config.getLiveCheckTaskPosition());
                configSnap.setSelfCheckTaskPosition(config.getSelfCheckTaskPosition());
                configSnap.setLocationNecessary(config.getSelfCheckLocationNecessary());
                configSnap.setMustSelectedDetailedRulesSwitch(config.getMustSelectedDetailedRulesSwitch());
                configSnap.setMustSelectedDetaileReviewSwitch(config.getMustSelectedDetaileReviewSwitch());
                break;
            }
        }
    }

    public void snapRequireTime(Integer totalMins, Integer pageMins) {
        if (this.config == null) {
            this.config = new ConfigSnap();
        }
        this.config.setTotalDurationMinsNecessary(totalMins);
        this.config.setTotalPageDurationMinsNecessary(pageMins);
    }

    public Integer getId() {
        return this.id;
    }

    public Department getDepartment() {
        return this.department;
    }

    public List<CheckTaskRecord> getRecords() {
        return this.records;
    }

    public CheckTemplate getTemplate() {
        return this.template;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getFirstCommitTime() {
        return this.firstCommitTime;
    }

    public Date getRevokeTime() {
        return this.revokeTime;
    }

    public Integer getDelayMins() {
        return this.delayMins;
    }

    public Integer getIsInRange() {
        return this.isInRange;
    }

    public CheckTaskTypeEnum getType() {
        return this.type;
    }

    public CheckTaskSourceEnum getSource() {
        return this.source;
    }

    public CheckTaskStatusEnum getStatus() {
        return this.status;
    }

    public MultiCommitStateEnum getMultiCommitState() {
        return this.multiCommitState;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<User> getCompanies() {
        return this.companies;
    }

    public Integer getUuidStatus() {
        return this.uuidStatus;
    }

    public String getUuidCommit() {
        return this.uuidCommit;
    }

    public String getUuidCreate() {
        return this.uuidCreate;
    }

    public User getOnSiteUser() {
        return this.onSiteUser;
    }

    public User getCreator() {
        return this.creator;
    }

    public User getRealCreator() {
        return this.realCreator;
    }

    public CheckTaskCheckIn getCheckIn() {
        return this.checkIn;
    }

    public CheckTaskCheckOut getCheckOut() {
        return this.checkOut;
    }

    public CheckTaskSignImages getSign() {
        return this.sign;
    }

    public CheckTaskExtra getExtra() {
        return this.extra;
    }

    public Integer getIsCreateInRange() {
        return this.isCreateInRange;
    }

    public String getAppendixContent() {
        return this.appendixContent;
    }

    public String getShiplog() {
        return this.shiplog;
    }

    public Boolean getObjection() {
        return this.objection;
    }

    public String getObjectionContent() {
        return this.objectionContent;
    }

    public ConfigSnap getConfig() {
        return this.config;
    }

    public CooperateManager getCooperate() {
        return this.cooperate;
    }

    public String getAddress() {
        return this.address;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Integer getRefuseNum() {
        return this.refuseNum;
    }

    public Date getExpireGmt8Time() {
        return this.expireGmt8Time;
    }

    public ScoreValue getTotalScore() {
        return this.totalScore;
    }

    public ScoreValue getScore() {
        return this.score;
    }

    public Integer getReviewAutoPass() {
        return this.reviewAutoPass;
    }

    @Deprecated
    public Integer getReviewAutoDays() {
        return this.reviewAutoDays;
    }

    public Integer getReviewAutoHours() {
        return this.reviewAutoHours;
    }

    public Integer getReviewAutoSeconds() {
        return this.reviewAutoSeconds;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public void setTemplate(CheckTemplate template) {
        this.template = template;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setFirstCommitTime(Date firstCommitTime) {
        this.firstCommitTime = firstCommitTime;
    }

    public void setRevokeTime(Date revokeTime) {
        this.revokeTime = revokeTime;
    }

    public void setDelayMins(Integer delayMins) {
        this.delayMins = delayMins;
    }

    public void setIsInRange(Integer isInRange) {
        this.isInRange = isInRange;
    }

    public void setType(CheckTaskTypeEnum type) {
        this.type = type;
    }

    public void setSource(CheckTaskSourceEnum source) {
        this.source = source;
    }

    public void setStatus(CheckTaskStatusEnum status) {
        this.status = status;
    }

    public void setMultiCommitState(MultiCommitStateEnum multiCommitState) {
        this.multiCommitState = multiCommitState;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setCompanies(List<User> companies) {
        this.companies = companies;
    }

    public void setUuidStatus(Integer uuidStatus) {
        this.uuidStatus = uuidStatus;
    }

    public void setUuidCommit(String uuidCommit) {
        this.uuidCommit = uuidCommit;
    }

    public void setUuidCreate(String uuidCreate) {
        this.uuidCreate = uuidCreate;
    }

    public void setOnSiteUser(User onSiteUser) {
        this.onSiteUser = onSiteUser;
    }

    public void setCreator(User creator) {
        this.creator = creator;
    }

    public void setRealCreator(User realCreator) {
        this.realCreator = realCreator;
    }

    public void setLiveDurationSeconds(Integer liveDurationSeconds) {
        this.liveDurationSeconds = liveDurationSeconds;
    }

    public void setCheckIn(CheckTaskCheckIn checkIn) {
        this.checkIn = checkIn;
    }

    public void setCheckOut(CheckTaskCheckOut checkOut) {
        this.checkOut = checkOut;
    }

    public void setSign(CheckTaskSignImages sign) {
        this.sign = sign;
    }

    public void setExtra(CheckTaskExtra extra) {
        this.extra = extra;
    }

    public void setIsCreateInRange(Integer isCreateInRange) {
        this.isCreateInRange = isCreateInRange;
    }

    public void setAppendixContent(String appendixContent) {
        this.appendixContent = appendixContent;
    }

    public void setShiplog(String shiplog) {
        this.shiplog = shiplog;
    }

    public void setObjection(Boolean objection) {
        this.objection = objection;
    }

    public void setObjectionContent(String objectionContent) {
        this.objectionContent = objectionContent;
    }

    public void setConfig(ConfigSnap config) {
        this.config = config;
    }

    public void setCooperate(CooperateManager cooperate) {
        this.cooperate = cooperate;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public void setRefuseNum(Integer refuseNum) {
        this.refuseNum = refuseNum;
    }

    public void setExpireGmt8Time(Date expireGmt8Time) {
        this.expireGmt8Time = expireGmt8Time;
    }

    public void setTotalScore(ScoreValue totalScore) {
        this.totalScore = totalScore;
    }

    public void setScore(ScoreValue score) {
        this.score = score;
    }

    public void setReviewAutoPass(Integer reviewAutoPass) {
        this.reviewAutoPass = reviewAutoPass;
    }

    @Deprecated
    public void setReviewAutoDays(Integer reviewAutoDays) {
        this.reviewAutoDays = reviewAutoDays;
    }

    public void setReviewAutoHours(Integer reviewAutoHours) {
        this.reviewAutoHours = reviewAutoHours;
    }

    public void setReviewAutoSeconds(Integer reviewAutoSeconds) {
        this.reviewAutoSeconds = reviewAutoSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckTask)) {
            return false;
        }
        CheckTask other = (CheckTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Department this$department = this.getDepartment();
        Department other$department = other.getDepartment();
        if (this$department == null ? other$department != null : !((Object)this$department).equals(other$department)) {
            return false;
        }
        List<CheckTaskRecord> this$records = this.getRecords();
        List<CheckTaskRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        CheckTemplate this$template = this.getTemplate();
        CheckTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Date this$firstCommitTime = this.getFirstCommitTime();
        Date other$firstCommitTime = other.getFirstCommitTime();
        if (this$firstCommitTime == null ? other$firstCommitTime != null : !((Object)this$firstCommitTime).equals(other$firstCommitTime)) {
            return false;
        }
        Date this$revokeTime = this.getRevokeTime();
        Date other$revokeTime = other.getRevokeTime();
        if (this$revokeTime == null ? other$revokeTime != null : !((Object)this$revokeTime).equals(other$revokeTime)) {
            return false;
        }
        Integer this$delayMins = this.getDelayMins();
        Integer other$delayMins = other.getDelayMins();
        if (this$delayMins == null ? other$delayMins != null : !((Object)this$delayMins).equals(other$delayMins)) {
            return false;
        }
        Integer this$isInRange = this.getIsInRange();
        Integer other$isInRange = other.getIsInRange();
        if (this$isInRange == null ? other$isInRange != null : !((Object)this$isInRange).equals(other$isInRange)) {
            return false;
        }
        CheckTaskTypeEnum this$type = this.getType();
        CheckTaskTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CheckTaskSourceEnum this$source = this.getSource();
        CheckTaskSourceEnum other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source)) {
            return false;
        }
        CheckTaskStatusEnum this$status = this.getStatus();
        CheckTaskStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        MultiCommitStateEnum this$multiCommitState = this.getMultiCommitState();
        MultiCommitStateEnum other$multiCommitState = other.getMultiCommitState();
        if (this$multiCommitState == null ? other$multiCommitState != null : !((Object)((Object)this$multiCommitState)).equals((Object)other$multiCommitState)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        List<User> this$companies = this.getCompanies();
        List<User> other$companies = other.getCompanies();
        if (this$companies == null ? other$companies != null : !((Object)this$companies).equals(other$companies)) {
            return false;
        }
        Integer this$uuidStatus = this.getUuidStatus();
        Integer other$uuidStatus = other.getUuidStatus();
        if (this$uuidStatus == null ? other$uuidStatus != null : !((Object)this$uuidStatus).equals(other$uuidStatus)) {
            return false;
        }
        String this$uuidCommit = this.getUuidCommit();
        String other$uuidCommit = other.getUuidCommit();
        if (this$uuidCommit == null ? other$uuidCommit != null : !this$uuidCommit.equals(other$uuidCommit)) {
            return false;
        }
        String this$uuidCreate = this.getUuidCreate();
        String other$uuidCreate = other.getUuidCreate();
        if (this$uuidCreate == null ? other$uuidCreate != null : !this$uuidCreate.equals(other$uuidCreate)) {
            return false;
        }
        User this$onSiteUser = this.getOnSiteUser();
        User other$onSiteUser = other.getOnSiteUser();
        if (this$onSiteUser == null ? other$onSiteUser != null : !((Object)this$onSiteUser).equals(other$onSiteUser)) {
            return false;
        }
        User this$creator = this.getCreator();
        User other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !((Object)this$creator).equals(other$creator)) {
            return false;
        }
        User this$realCreator = this.getRealCreator();
        User other$realCreator = other.getRealCreator();
        if (this$realCreator == null ? other$realCreator != null : !((Object)this$realCreator).equals(other$realCreator)) {
            return false;
        }
        if (this.getLiveDurationSeconds() != other.getLiveDurationSeconds()) {
            return false;
        }
        CheckTaskCheckIn this$checkIn = this.getCheckIn();
        CheckTaskCheckIn other$checkIn = other.getCheckIn();
        if (this$checkIn == null ? other$checkIn != null : !((Object)this$checkIn).equals(other$checkIn)) {
            return false;
        }
        CheckTaskCheckOut this$checkOut = this.getCheckOut();
        CheckTaskCheckOut other$checkOut = other.getCheckOut();
        if (this$checkOut == null ? other$checkOut != null : !((Object)this$checkOut).equals(other$checkOut)) {
            return false;
        }
        CheckTaskSignImages this$sign = this.getSign();
        CheckTaskSignImages other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !((Object)this$sign).equals(other$sign)) {
            return false;
        }
        CheckTaskExtra this$extra = this.getExtra();
        CheckTaskExtra other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra)) {
            return false;
        }
        Integer this$isCreateInRange = this.getIsCreateInRange();
        Integer other$isCreateInRange = other.getIsCreateInRange();
        if (this$isCreateInRange == null ? other$isCreateInRange != null : !((Object)this$isCreateInRange).equals(other$isCreateInRange)) {
            return false;
        }
        String this$appendixContent = this.getAppendixContent();
        String other$appendixContent = other.getAppendixContent();
        if (this$appendixContent == null ? other$appendixContent != null : !this$appendixContent.equals(other$appendixContent)) {
            return false;
        }
        String this$shiplog = this.getShiplog();
        String other$shiplog = other.getShiplog();
        if (this$shiplog == null ? other$shiplog != null : !this$shiplog.equals(other$shiplog)) {
            return false;
        }
        Boolean this$objection = this.getObjection();
        Boolean other$objection = other.getObjection();
        if (this$objection == null ? other$objection != null : !((Object)this$objection).equals(other$objection)) {
            return false;
        }
        String this$objectionContent = this.getObjectionContent();
        String other$objectionContent = other.getObjectionContent();
        if (this$objectionContent == null ? other$objectionContent != null : !this$objectionContent.equals(other$objectionContent)) {
            return false;
        }
        ConfigSnap this$config = this.getConfig();
        ConfigSnap other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        CooperateManager this$cooperate = this.getCooperate();
        CooperateManager other$cooperate = other.getCooperate();
        if (this$cooperate == null ? other$cooperate != null : !((Object)this$cooperate).equals(other$cooperate)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$distance = this.getDistance();
        Double other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        Integer this$refuseNum = this.getRefuseNum();
        Integer other$refuseNum = other.getRefuseNum();
        if (this$refuseNum == null ? other$refuseNum != null : !((Object)this$refuseNum).equals(other$refuseNum)) {
            return false;
        }
        Date this$expireGmt8Time = this.getExpireGmt8Time();
        Date other$expireGmt8Time = other.getExpireGmt8Time();
        if (this$expireGmt8Time == null ? other$expireGmt8Time != null : !((Object)this$expireGmt8Time).equals(other$expireGmt8Time)) {
            return false;
        }
        ScoreValue this$totalScore = this.getTotalScore();
        ScoreValue other$totalScore = other.getTotalScore();
        if (this$totalScore == null ? other$totalScore != null : !this$totalScore.equals(other$totalScore)) {
            return false;
        }
        ScoreValue this$score = this.getScore();
        ScoreValue other$score = other.getScore();
        if (this$score == null ? other$score != null : !this$score.equals(other$score)) {
            return false;
        }
        Integer this$reviewAutoPass = this.getReviewAutoPass();
        Integer other$reviewAutoPass = other.getReviewAutoPass();
        if (this$reviewAutoPass == null ? other$reviewAutoPass != null : !((Object)this$reviewAutoPass).equals(other$reviewAutoPass)) {
            return false;
        }
        Integer this$reviewAutoDays = this.getReviewAutoDays();
        Integer other$reviewAutoDays = other.getReviewAutoDays();
        if (this$reviewAutoDays == null ? other$reviewAutoDays != null : !((Object)this$reviewAutoDays).equals(other$reviewAutoDays)) {
            return false;
        }
        Integer this$reviewAutoHours = this.getReviewAutoHours();
        Integer other$reviewAutoHours = other.getReviewAutoHours();
        if (this$reviewAutoHours == null ? other$reviewAutoHours != null : !((Object)this$reviewAutoHours).equals(other$reviewAutoHours)) {
            return false;
        }
        Integer this$reviewAutoSeconds = this.getReviewAutoSeconds();
        Integer other$reviewAutoSeconds = other.getReviewAutoSeconds();
        return !(this$reviewAutoSeconds == null ? other$reviewAutoSeconds != null : !((Object)this$reviewAutoSeconds).equals(other$reviewAutoSeconds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Department $department = this.getDepartment();
        result = result * 59 + ($department == null ? 43 : ((Object)$department).hashCode());
        List<CheckTaskRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        CheckTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Date $firstCommitTime = this.getFirstCommitTime();
        result = result * 59 + ($firstCommitTime == null ? 43 : ((Object)$firstCommitTime).hashCode());
        Date $revokeTime = this.getRevokeTime();
        result = result * 59 + ($revokeTime == null ? 43 : ((Object)$revokeTime).hashCode());
        Integer $delayMins = this.getDelayMins();
        result = result * 59 + ($delayMins == null ? 43 : ((Object)$delayMins).hashCode());
        Integer $isInRange = this.getIsInRange();
        result = result * 59 + ($isInRange == null ? 43 : ((Object)$isInRange).hashCode());
        CheckTaskTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CheckTaskSourceEnum $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
        CheckTaskStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        MultiCommitStateEnum $multiCommitState = this.getMultiCommitState();
        result = result * 59 + ($multiCommitState == null ? 43 : ((Object)((Object)$multiCommitState)).hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        List<User> $companies = this.getCompanies();
        result = result * 59 + ($companies == null ? 43 : ((Object)$companies).hashCode());
        Integer $uuidStatus = this.getUuidStatus();
        result = result * 59 + ($uuidStatus == null ? 43 : ((Object)$uuidStatus).hashCode());
        String $uuidCommit = this.getUuidCommit();
        result = result * 59 + ($uuidCommit == null ? 43 : $uuidCommit.hashCode());
        String $uuidCreate = this.getUuidCreate();
        result = result * 59 + ($uuidCreate == null ? 43 : $uuidCreate.hashCode());
        User $onSiteUser = this.getOnSiteUser();
        result = result * 59 + ($onSiteUser == null ? 43 : ((Object)$onSiteUser).hashCode());
        User $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : ((Object)$creator).hashCode());
        User $realCreator = this.getRealCreator();
        result = result * 59 + ($realCreator == null ? 43 : ((Object)$realCreator).hashCode());
        result = result * 59 + this.getLiveDurationSeconds();
        CheckTaskCheckIn $checkIn = this.getCheckIn();
        result = result * 59 + ($checkIn == null ? 43 : ((Object)$checkIn).hashCode());
        CheckTaskCheckOut $checkOut = this.getCheckOut();
        result = result * 59 + ($checkOut == null ? 43 : ((Object)$checkOut).hashCode());
        CheckTaskSignImages $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : ((Object)$sign).hashCode());
        CheckTaskExtra $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        Integer $isCreateInRange = this.getIsCreateInRange();
        result = result * 59 + ($isCreateInRange == null ? 43 : ((Object)$isCreateInRange).hashCode());
        String $appendixContent = this.getAppendixContent();
        result = result * 59 + ($appendixContent == null ? 43 : $appendixContent.hashCode());
        String $shiplog = this.getShiplog();
        result = result * 59 + ($shiplog == null ? 43 : $shiplog.hashCode());
        Boolean $objection = this.getObjection();
        result = result * 59 + ($objection == null ? 43 : ((Object)$objection).hashCode());
        String $objectionContent = this.getObjectionContent();
        result = result * 59 + ($objectionContent == null ? 43 : $objectionContent.hashCode());
        ConfigSnap $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        CooperateManager $cooperate = this.getCooperate();
        result = result * 59 + ($cooperate == null ? 43 : ((Object)$cooperate).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        Integer $refuseNum = this.getRefuseNum();
        result = result * 59 + ($refuseNum == null ? 43 : ((Object)$refuseNum).hashCode());
        Date $expireGmt8Time = this.getExpireGmt8Time();
        result = result * 59 + ($expireGmt8Time == null ? 43 : ((Object)$expireGmt8Time).hashCode());
        ScoreValue $totalScore = this.getTotalScore();
        result = result * 59 + ($totalScore == null ? 43 : $totalScore.hashCode());
        ScoreValue $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : $score.hashCode());
        Integer $reviewAutoPass = this.getReviewAutoPass();
        result = result * 59 + ($reviewAutoPass == null ? 43 : ((Object)$reviewAutoPass).hashCode());
        Integer $reviewAutoDays = this.getReviewAutoDays();
        result = result * 59 + ($reviewAutoDays == null ? 43 : ((Object)$reviewAutoDays).hashCode());
        Integer $reviewAutoHours = this.getReviewAutoHours();
        result = result * 59 + ($reviewAutoHours == null ? 43 : ((Object)$reviewAutoHours).hashCode());
        Integer $reviewAutoSeconds = this.getReviewAutoSeconds();
        result = result * 59 + ($reviewAutoSeconds == null ? 43 : ((Object)$reviewAutoSeconds).hashCode());
        return result;
    }

    public String toString() {
        return "CheckTask(id=" + this.getId() + ", name=" + this.getName() + ", department=" + this.getDepartment() + ", records=" + this.getRecords() + ", template=" + this.getTemplate() + ", createTime=" + this.getCreateTime() + ", endTime=" + this.getEndTime() + ", firstCommitTime=" + this.getFirstCommitTime() + ", revokeTime=" + this.getRevokeTime() + ", delayMins=" + this.getDelayMins() + ", isInRange=" + this.getIsInRange() + ", type=" + (Object)((Object)this.getType()) + ", source=" + (Object)((Object)this.getSource()) + ", status=" + (Object)((Object)this.getStatus()) + ", multiCommitState=" + (Object)((Object)this.getMultiCommitState()) + ", summary=" + this.getSummary() + ", companies=" + this.getCompanies() + ", uuidStatus=" + this.getUuidStatus() + ", uuidCommit=" + this.getUuidCommit() + ", uuidCreate=" + this.getUuidCreate() + ", onSiteUser=" + this.getOnSiteUser() + ", creator=" + this.getCreator() + ", realCreator=" + this.getRealCreator() + ", liveDurationSeconds=" + this.getLiveDurationSeconds() + ", checkIn=" + this.getCheckIn() + ", checkOut=" + this.getCheckOut() + ", sign=" + this.getSign() + ", extra=" + this.getExtra() + ", isCreateInRange=" + this.getIsCreateInRange() + ", appendixContent=" + this.getAppendixContent() + ", shiplog=" + this.getShiplog() + ", objection=" + this.getObjection() + ", objectionContent=" + this.getObjectionContent() + ", config=" + this.getConfig() + ", cooperate=" + this.getCooperate() + ", address=" + this.getAddress() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", distance=" + this.getDistance() + ", refuseNum=" + this.getRefuseNum() + ", expireGmt8Time=" + this.getExpireGmt8Time() + ", totalScore=" + this.getTotalScore() + ", score=" + this.getScore() + ", reviewAutoPass=" + this.getReviewAutoPass() + ", reviewAutoDays=" + this.getReviewAutoDays() + ", reviewAutoHours=" + this.getReviewAutoHours() + ", reviewAutoSeconds=" + this.getReviewAutoSeconds() + ")";
    }

    public CheckTask(Integer id, String name, Department department, List<CheckTaskRecord> records, CheckTemplate template, Date createTime, Date endTime, Date firstCommitTime, Date revokeTime, Integer delayMins, Integer isInRange, CheckTaskTypeEnum type, CheckTaskSourceEnum source, CheckTaskStatusEnum status, MultiCommitStateEnum multiCommitState, String summary, List<User> companies, Integer uuidStatus, String uuidCommit, String uuidCreate, User onSiteUser, User creator, User realCreator, Integer liveDurationSeconds, CheckTaskCheckIn checkIn, CheckTaskCheckOut checkOut, CheckTaskSignImages sign, CheckTaskExtra extra, Integer isCreateInRange, String appendixContent, String shiplog, Boolean objection, String objectionContent, ConfigSnap config, CooperateManager cooperate, String address, Double longitude, Double latitude, Double distance, Integer refuseNum, Date expireGmt8Time, ScoreValue totalScore, ScoreValue score, Integer reviewAutoPass, Integer reviewAutoDays, Integer reviewAutoHours, Integer reviewAutoSeconds) {
        this.id = id;
        this.name = name;
        this.department = department;
        this.records = records;
        this.template = template;
        this.createTime = createTime;
        this.endTime = endTime;
        this.firstCommitTime = firstCommitTime;
        this.revokeTime = revokeTime;
        this.delayMins = delayMins;
        this.isInRange = isInRange;
        this.type = type;
        this.source = source;
        this.status = status;
        this.multiCommitState = multiCommitState;
        this.summary = summary;
        this.companies = companies;
        this.uuidStatus = uuidStatus;
        this.uuidCommit = uuidCommit;
        this.uuidCreate = uuidCreate;
        this.onSiteUser = onSiteUser;
        this.creator = creator;
        this.realCreator = realCreator;
        this.liveDurationSeconds = liveDurationSeconds;
        this.checkIn = checkIn;
        this.checkOut = checkOut;
        this.sign = sign;
        this.extra = extra;
        this.isCreateInRange = isCreateInRange;
        this.appendixContent = appendixContent;
        this.shiplog = shiplog;
        this.objection = objection;
        this.objectionContent = objectionContent;
        this.config = config;
        this.cooperate = cooperate;
        this.address = address;
        this.longitude = longitude;
        this.latitude = latitude;
        this.distance = distance;
        this.refuseNum = refuseNum;
        this.expireGmt8Time = expireGmt8Time;
        this.totalScore = totalScore;
        this.score = score;
        this.reviewAutoPass = reviewAutoPass;
        this.reviewAutoDays = reviewAutoDays;
        this.reviewAutoHours = reviewAutoHours;
        this.reviewAutoSeconds = reviewAutoSeconds;
    }

    public CheckTask() {
    }
}

