/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.review;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ovopark.check.core.review.Blocker;
import com.ovopark.check.support.Role;
import com.ovopark.check.support.User;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class ReviewNode {
    private List<User> users;
    private Role role;
    private Blocker blocker;
    private ReviewNode next;
    private Integer level;
    private boolean needSpecifyReviewer;

    public boolean match() {
        return this.blocker.match();
    }

    public ReviewNode next() {
        return this.next;
    }

    public boolean isRole() {
        return this.role != null;
    }

    public boolean needSpecifyReviewer() {
        return this.needSpecifyReviewer;
    }

    public void specifyUser(User user) {
        this.users.add(user);
    }

    public boolean haveReviewer() {
        return !CollectionUtils.isEmpty(this.users);
    }

    public String prettyString() {
        return StrUtil.format((CharSequence)"ReviewNode:{} \u7528\u6237:{} \u89d2\u8272:{} \u9700\u6307\u5b9a:{} \n {} ", (Object[])new Object[]{this.level, JSON.toJSONString(this.users), JSON.toJSONString((Object)this.role), this.needSpecifyReviewer, this.blocker.prettyString()});
    }

    public ReviewNode(List<User> users, Role role, Blocker blocker, ReviewNode next, Integer level, boolean needSpecifyReviewer) {
        this.users = users;
        this.role = role;
        this.blocker = blocker;
        this.next = next;
        this.level = level;
        this.needSpecifyReviewer = needSpecifyReviewer;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public Role getRole() {
        return this.role;
    }

    public Integer getLevel() {
        return this.level;
    }
}

