/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.ovopark.check.core.ScoreValueSerializer;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

@JSONType(serializer=ScoreValueSerializer.class)
public class ScoreValue
implements Serializable {
    private int SCALE = 2;
    private final BigDecimal value;
    public static final ScoreValue ZERO = ScoreValue.of(0L);
    public static final ScoreValue NaN = new ScoreValue(null);

    public static ScoreValue of(Number number) {
        return new ScoreValue(number);
    }

    public ScoreValue(Number number) {
        this.value = number != null ? BigDecimal.valueOf(number.doubleValue()).setScale(this.SCALE, RoundingMode.HALF_UP) : null;
    }

    @Deprecated
    public Double doubleValue(int scale) {
        if (this.value == null) {
            return null;
        }
        return this.value.setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public Double doubleNullAsZero(int scale) {
        if (this.value == null) {
            return 0.0;
        }
        return this.value.setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    @Deprecated
    public Double doubleValue() {
        return this.doubleValue(1);
    }

    public Double doubleNullAsZero() {
        return this.doubleNullAsZero(1);
    }

    @JSONField(serialize=false)
    public Boolean isNaN() {
        return this.value == null;
    }

    @JSONField(serialize=false)
    public Boolean isZero() {
        return this.value != null && this.value.compareTo(BigDecimal.ZERO) == 0;
    }

    public ScoreValue add(ScoreValue value) {
        if (value == null || this.value == null) {
            throw new RuntimeException("i18n.sum.of.scores.cannot.be.empty");
        }
        return new ScoreValue(this.value.add(value.value));
    }

    public ScoreValue sub(ScoreValue value) {
        if (value == null || this.value == null) {
            throw new RuntimeException("i18n.score.subtraction.cannot.be.empty");
        }
        return new ScoreValue(this.value.subtract(value.value));
    }

    public ScoreValue div(ScoreValue value) {
        if (value == null || value.isNaN().booleanValue() || this.value == null || this.isNaN().booleanValue()) {
            throw new RuntimeException("i18n.score.division.cannot.be.empty");
        }
        return ScoreValue.of(this.value.divide(value.value, this.SCALE, RoundingMode.HALF_UP));
    }

    public ScoreValue multiply(Number number) {
        if (this.value == null) {
            return NaN;
        }
        BigDecimal bigDecimal = this.value.multiply(new BigDecimal(number.toString())).setScale(this.SCALE, RoundingMode.HALF_UP);
        return ScoreValue.of(bigDecimal);
    }

    public boolean lt(ScoreValue other) {
        return this.value != null && this.value.compareTo(other.value) < 0;
    }

    public boolean le(ScoreValue other) {
        return this.value != null && this.value.compareTo(other.value) <= 0;
    }

    public boolean eq(ScoreValue other) {
        if (this.value == null || other.value == null) {
            return false;
        }
        return this.value.compareTo(other.value) == 0;
    }

    public boolean ge(ScoreValue other) {
        return this.value != null && this.value.compareTo(other.value) >= 0;
    }

    public boolean gt(ScoreValue other) {
        return this.value != null && this.value.compareTo(other.value) > 0;
    }

    public ScoreValue abs() {
        if (this.value == null) {
            return NaN;
        }
        return ScoreValue.of(this.value.abs());
    }

    public String toString() {
        return "" + this.value;
    }
}

