/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.review;

import com.ovopark.check.core.review.BlockCondition;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class Blocker {
    private List<BlockCondition> conditions;
    private String logic;
    public static final Blocker ALWAYS_MATCH = new Blocker(null, null);

    public boolean match() {
        if (Objects.equals("and", this.logic)) {
            return this.and(this.conditions);
        }
        if (Objects.equals("or", this.logic)) {
            return this.or(this.conditions);
        }
        return true;
    }

    public boolean and(List<BlockCondition> conditions) {
        return conditions.stream().allMatch(BlockCondition::match);
    }

    public boolean or(List<BlockCondition> conditions) {
        return conditions.stream().anyMatch(BlockCondition::match);
    }

    public String prettyString() {
        if (CollectionUtils.isEmpty(this.conditions)) {
            return "ALWAYS_MATCH";
        }
        return "\u5339\u914d:" + this.match() + "\n" + this.conditions.stream().map(BlockCondition::prettyString).collect(Collectors.joining("\n" + this.logic.toUpperCase()));
    }

    public Blocker(List<BlockCondition> conditions, String logic) {
        this.conditions = conditions;
        this.logic = logic;
    }
}

