/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CheckTaskSourceEnum;
import com.ovopark.check.core.CheckTaskTypeEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CheckConvertor {
    public static Integer convertCheckType(CheckTaskTypeEnum type, CheckTaskSourceEnum source) {
        if (CheckTaskSourceEnum.PLAN == source) {
            if (type.getCode() == 0) {
                return 10;
            }
            if (type.getCode() == 1) {
                return 11;
            }
            if (type.getCode() == 12) {
                return 17;
            }
        }
        if (CheckTaskSourceEnum.TASK == source) {
            if (type.getCode() == 0) {
                return 15;
            }
            if (type.getCode() == 1) {
                return 21;
            }
        }
        return type.getCode();
    }

    public static Integer getSourceType(CheckTask task) {
        int sourceType = 8;
        switch (CheckConvertor.convertCheckType(task.getType(), task.getSource())) {
            case 2: {
                sourceType = 1;
                break;
            }
            case 1: 
            case 5: {
                sourceType = 9;
                break;
            }
            case 10: {
                sourceType = 14;
                break;
            }
            case 11: {
                sourceType = 13;
                break;
            }
            case 15: {
                sourceType = 15;
                break;
            }
            case 12: {
                sourceType = 12;
                break;
            }
            case 17: {
                sourceType = 17;
                break;
            }
            case 21: {
                sourceType = 21;
                break;
            }
        }
        return sourceType;
    }

    public static CheckTaskTypeEnum getCheckTypeFromDb(Integer checkType) {
        if (checkType == 10) {
            return CheckTaskTypeEnum.LIVE_CHECK;
        }
        if (checkType == 11) {
            return CheckTaskTypeEnum.REMOTE_CHECK;
        }
        if (checkType == 17) {
            return CheckTaskTypeEnum.SELF_CHECK;
        }
        if (checkType == 15) {
            return CheckTaskTypeEnum.LIVE_CHECK;
        }
        if (checkType == 21) {
            return CheckTaskTypeEnum.REMOTE_CHECK;
        }
        return CheckTaskTypeEnum.of(checkType);
    }

    public static CheckTaskSourceEnum getCheckSourceFromDb(Integer checkType) {
        if (checkType == 10) {
            return CheckTaskSourceEnum.of(1);
        }
        if (checkType == 11) {
            return CheckTaskSourceEnum.of(1);
        }
        if (checkType == 17) {
            return CheckTaskSourceEnum.of(1);
        }
        if (checkType == 15 || checkType == 21) {
            return CheckTaskSourceEnum.of(2);
        }
        return CheckTaskSourceEnum.of(0);
    }

    public static int getBaseSourceType(Integer sourceType) {
        switch (sourceType) {
            case 13: 
            case 21: {
                return 9;
            }
            case 14: 
            case 15: {
                return 8;
            }
            case 17: {
                return 12;
            }
        }
        return sourceType;
    }

    public static Double calMoney(Integer moneyType, Double money) {
        if (moneyType != null && money != null) {
            if (moneyType == 0) {
                return money;
            }
            return -money.doubleValue();
        }
        return 0.0;
    }

    public static List<Integer> convertSourceTypes2CheckTypes(List<Integer> sourceTypes, Boolean notContainSpotCheck) {
        ArrayList<Integer> checkTypes = new ArrayList<Integer>();
        if (CollectionUtil.isEmpty(sourceTypes)) {
            return checkTypes;
        }
        HashSet<Integer> sourceTypesSet = new HashSet<Integer>(sourceTypes);
        if (sourceTypesSet.containsAll(ListUtil.toList((Object[])new Integer[]{8, 14, 15}))) {
            checkTypes.addAll(ListUtil.toList((Object[])new Integer[]{0, 10, 15}));
        }
        if (sourceTypesSet.containsAll(ListUtil.toList((Object[])new Integer[]{9, 13, 21}))) {
            checkTypes.addAll(ListUtil.toList((Object[])new Integer[]{1, 11, 21}));
        }
        if (notContainSpotCheck.booleanValue() && sourceTypesSet.containsAll(ListUtil.toList((Object[])new Integer[]{1}))) {
            checkTypes.addAll(ListUtil.toList((Object[])new Integer[]{-1}));
        }
        if (sourceTypesSet.containsAll(ListUtil.toList((Object[])new Integer[]{12, 17}))) {
            checkTypes.addAll(ListUtil.toList((Object[])new Integer[]{12, 17}));
        }
        return checkTypes;
    }

    public static Integer getMainTypeFromCheckType(Integer cmdCheckType) {
        Integer mainType = null;
        switch (cmdCheckType) {
            case 0: {
                mainType = 8;
                break;
            }
            case 1: {
                mainType = 9;
                break;
            }
            case 12: {
                mainType = 7;
                break;
            }
        }
        return mainType;
    }

    public static String convertInspTaskType(CheckTaskTypeEnum type) {
        if (type == CheckTaskTypeEnum.LIVE_CHECK) {
            return "INSP-TASK-TYPE_LIVE";
        }
        if (type == CheckTaskTypeEnum.SELF_CHECK) {
            return "INSP-TASK-TYPE_SELF";
        }
        if (type == CheckTaskTypeEnum.REMOTE_CHECK) {
            return "INSP-TASK-TYPE_REMOTE";
        }
        if (type == CheckTaskTypeEnum.INSP_CHECK) {
            return "INSP-TASK-TYPE_SCENE";
        }
        return null;
    }
}

