/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator.rule;

import com.ovopark.check.core.Score;
import com.ovopark.check.core.calculator.Action;
import com.ovopark.check.core.calculator.InspectionItem;
import com.ovopark.check.core.calculator.InspectionRecord;
import com.ovopark.check.core.calculator.rule.CustomRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SingleCustomRule
extends CustomRule {
    private final InspectionItem inspectionItem;
    private final Action action;
    private InspectionRecord record;

    public SingleCustomRule(InspectionItem inspectionItem, Action action) {
        this.inspectionItem = inspectionItem;
        this.action = action;
    }

    @Override
    public void matchAndKeep(List<InspectionRecord> records) {
        records.forEach(e -> {
            if (e.getInspectionItem().getId().equals(this.inspectionItem.getId())) {
                this.record = e;
            }
        });
    }

    @Override
    public boolean hasInsp(Integer inspId) {
        return Objects.equals(this.inspectionItem.getId(), inspId);
    }

    @Override
    public boolean calInspSubItemNumAsTimes(Integer inspId) {
        return this.action.getTimesType() == 1;
    }

    @Override
    public List<Score> getScore() {
        if (this.record == null) {
            return new ArrayList<Score>();
        }
        if (this.action != null) {
            if (this.record.isUnqualified()) {
                this.action.accept(this.group, this.record);
            } else if (this.record.isQualified()) {
                this.action.addReward(this.group, this.record.getRewardScore());
            }
        }
        return Collections.singletonList(new Score().setLevel(Score.Level.INSP_ITEM).setId(this.record.getInspectionItem().getId()).setScore(this.record.getScore()).setReturnScore(this.record.getReturnScore()).setTotalScore(this.record.getTotalScore()));
    }

    @Override
    public Set<Integer> allRuleSet() {
        return new HashSet<Integer>(this.action.getType());
    }

    public InspectionItem getInspectionItem() {
        return this.inspectionItem;
    }
}

