/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.ovopark.check.common.ID;
import com.ovopark.check.core.CheckSnapshotImage;
import com.ovopark.check.core.CheckSnapshotVideo;
import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CheckTaskRecordStatusEnum;
import com.ovopark.check.core.Constraints;
import com.ovopark.check.core.InspectionItem;
import com.ovopark.check.core.InspectionSubItemRecord;
import com.ovopark.check.core.RuleOption;
import com.ovopark.check.core.Score;
import com.ovopark.check.core.ScoreValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class CheckTaskRecord
implements ID,
Serializable {
    private static final long serialVersionUID = 1L;
    private Integer id;
    @JSONField(serialize=false)
    private CheckTask task;
    private InspectionItem inspectionItem;
    private List<InspectionSubItemRecord> inspSubItemRecords = new ArrayList<InspectionSubItemRecord>();
    private List<CheckSnapshotImage> images = new ArrayList<CheckSnapshotImage>();
    private List<CheckSnapshotVideo> videos = new ArrayList<CheckSnapshotVideo>();
    private String description;
    private CheckTaskRecordStatusEnum status = CheckTaskRecordStatusEnum.UNKNOWN;
    private Double money = 0.0;
    private Integer moneyTimes = 1;
    private ScoreValue extraMark = ScoreValue.ZERO;
    private Date createTime;
    private Date lastUpdateTime;
    public Date replayTime;
    public Integer times;
    public ScoreValue score = ScoreValue.ZERO;
    public ScoreValue beforeScore = ScoreValue.NaN;
    public Constraints constraints;
    public Integer version;
    public Boolean lightSpotShared;
    public Boolean problemShared;
    public String reformInfoStr;
    public ScoreValue returnScore = ScoreValue.ZERO;
    public ScoreValue ruleRedudence = ScoreValue.ZERO;
    public ScoreValue rewardScore = ScoreValue.ZERO;
    public RuleOption ruleOption = new RuleOption();

    public ScoreValue getTotalScore() {
        if (CollectionUtils.isEmpty(this.inspSubItemRecords)) {
            return this.inspectionItem.getTotalScore();
        }
        if (this.inspSubItemRecords.stream().map(InspectionSubItemRecord::getStandardScore).anyMatch(ScoreValue::isNaN)) {
            return this.inspectionItem.getTotalScore();
        }
        return this.inspSubItemRecords.stream().filter(e -> e.getStatus() != CheckTaskRecordStatusEnum.INAPPLICABLE).map(InspectionSubItemRecord::getStandardScore).reduce(ScoreValue::add).orElse(ScoreValue.ZERO);
    }

    public void setSubItemStatus(Map<Integer, CheckTaskRecordStatusEnum> map, boolean defaultQualified) {
        if (CollectionUtils.isEmpty(this.inspSubItemRecords)) {
            return;
        }
        for (InspectionSubItemRecord inspSubItemRecord : this.inspSubItemRecords) {
            CheckTaskRecordStatusEnum status = map.get(inspSubItemRecord.getId());
            if (status != null) {
                inspSubItemRecord.setStatus(map.get(inspSubItemRecord.getId()));
                continue;
            }
            if (!defaultQualified) continue;
            inspSubItemRecord.setStatus(CheckTaskRecordStatusEnum.QUALIFIED);
        }
        this.score = this.isUnqualified().booleanValue() ? (this.inspSubItemRecords.stream().map(InspectionSubItemRecord::getStandardScore).anyMatch(ScoreValue::isNaN) ? ScoreValue.ZERO : this.inspSubItemRecords.stream().map(InspectionSubItemRecord::getScore).reduce(ScoreValue::add).orElse(ScoreValue.ZERO)) : (this.isQualified() != false ? this.getTotalScore() : ScoreValue.ZERO);
    }

    public void batchSetSubItemStatus(CheckTaskRecordStatusEnum status) {
        if (CollectionUtils.isEmpty(this.inspSubItemRecords)) {
            return;
        }
        for (InspectionSubItemRecord inspSubItemRecord : this.inspSubItemRecords) {
            inspSubItemRecord.setStatus(status);
        }
    }

    private void reset() {
        this.times = 0;
        this.replayTime = null;
        this.score = ScoreValue.ZERO;
        this.description = "";
        this.extraMark = ScoreValue.ZERO;
        this.images = new ArrayList<CheckSnapshotImage>();
        this.videos = new ArrayList<CheckSnapshotVideo>();
        this.money = 0.0;
        this.moneyTimes = 1;
        this.batchSetSubItemStatus(CheckTaskRecordStatusEnum.UNKNOWN);
        this.reformInfoStr = "";
        this.ruleRedudence = ScoreValue.ZERO;
        this.rewardScore = ScoreValue.ZERO;
        if (this.ruleOption != null) {
            this.ruleOption.setId(this.id);
            this.ruleOption.setScore(ScoreValue.NaN);
        }
    }

    public boolean changeStatus(CheckTaskRecordStatusEnum status) {
        boolean change = status != this.status;
        this.status = status;
        if (status == CheckTaskRecordStatusEnum.UNKNOWN && change) {
            this.reset();
        }
        if (status != CheckTaskRecordStatusEnum.UNQUALIFIED && change) {
            this.extraMark = ScoreValue.ZERO;
            this.ruleRedudence = ScoreValue.ZERO;
        }
        if (status == CheckTaskRecordStatusEnum.QUALIFIED && change) {
            this.times = 0;
            this.moneyTimes = 1;
            this.setMoney(Math.max(this.inspectionItem.getMoney(), 0.0));
            this.score = this.getTotalScore();
            this.batchSetSubItemStatus(CheckTaskRecordStatusEnum.QUALIFIED);
            if (this.ruleOption != null && this.task.isTemplate()) {
                this.ruleOption = Optional.ofNullable(this.task.getTemplate().getInspQulifiedRuleOption().get(this.inspectionItem.getId())).orElse(new RuleOption());
            }
        }
        if (status == CheckTaskRecordStatusEnum.UNQUALIFIED && change) {
            this.times = 1;
            this.moneyTimes = 1;
            this.batchSetSubItemStatus(CheckTaskRecordStatusEnum.UNQUALIFIED);
            this.score = ScoreValue.ZERO;
            if (!this.task.isTemplate() && this.inspectionItem.getExtraScore() != null) {
                this.extraMark = this.inspectionItem.getExtraScore();
            }
            this.setMoney(Math.min(0.0, this.inspectionItem.getMoney()));
        }
        if (status == CheckTaskRecordStatusEnum.INAPPLICABLE && change) {
            this.score = ScoreValue.ZERO;
            this.money = 0.0;
            this.times = 0;
            this.moneyTimes = 1;
        }
        if (status != CheckTaskRecordStatusEnum.QUALIFIED && change) {
            this.rewardScore = ScoreValue.ZERO;
        }
        return change;
    }

    public CheckTaskRecord(InspectionItem inspectionItem, CheckTaskRecordStatusEnum status) {
        this.inspectionItem = inspectionItem;
        this.status = status;
        if (CollectionUtil.isNotEmpty(inspectionItem.getSubItems())) {
            this.inspSubItemRecords = inspectionItem.getSubItems().stream().map(s -> {
                InspectionSubItemRecord r = new InspectionSubItemRecord();
                r.setRecord(this);
                r.setId(s.getId());
                r.setContent(s.getName());
                r.setStandardScore(s.getStandardScore());
                return r;
            }).collect(Collectors.toList());
        }
        if (status == CheckTaskRecordStatusEnum.QUALIFIED) {
            this.score = inspectionItem.getTotalScore();
            this.returnScore = inspectionItem.getTotalScore();
            this.money = Math.max(0.0, inspectionItem.getMoney());
        }
        this.batchSetSubItemStatus(status);
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public void set(Score scoreDetail) {
        Double score = scoreDetail.getChildren().stream().flatMap(e -> e.getChildren().stream()).filter(e -> Objects.equals(this.inspectionItem.getId(), e.getId())).map(Score::getScore).findFirst().orElse(null);
        this.score = ScoreValue.of(score);
    }

    public String toString() {
        return "CheckTaskRecord{id=" + this.id + ", inspectionItem=" + this.inspectionItem + ", inspSubItemRecords=" + this.inspSubItemRecords + ", images=" + this.images + ", videos=" + this.videos + ", description='" + this.description + '\'' + ", status=" + this.status + ", money=" + this.money + ", extraMark=" + this.extraMark + ", createTime=" + this.createTime + ", replayTime=" + this.replayTime + ", times=" + this.times + ", score=" + this.score + ", beforeScore=" + this.beforeScore + '}';
    }

    public Boolean isQualified() {
        return this.status == CheckTaskRecordStatusEnum.QUALIFIED;
    }

    public Boolean isUnqualified() {
        return this.status == CheckTaskRecordStatusEnum.UNQUALIFIED;
    }

    public Boolean isInapplicable() {
        return this.status == CheckTaskRecordStatusEnum.INAPPLICABLE;
    }

    public Boolean isUnknown() {
        return this.status == CheckTaskRecordStatusEnum.UNKNOWN;
    }

    public void incrVersion() {
        if (this.version != null) {
            Integer n = this.version;
            Integer n2 = this.version = Integer.valueOf(this.version + 1);
        }
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public CheckTask getTask() {
        return this.task;
    }

    public InspectionItem getInspectionItem() {
        return this.inspectionItem;
    }

    public List<InspectionSubItemRecord> getInspSubItemRecords() {
        return this.inspSubItemRecords;
    }

    public List<CheckSnapshotImage> getImages() {
        return this.images;
    }

    public List<CheckSnapshotVideo> getVideos() {
        return this.videos;
    }

    public String getDescription() {
        return this.description;
    }

    public CheckTaskRecordStatusEnum getStatus() {
        return this.status;
    }

    public Double getMoney() {
        return this.money;
    }

    public Integer getMoneyTimes() {
        return this.moneyTimes;
    }

    public ScoreValue getExtraMark() {
        return this.extraMark;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Date getReplayTime() {
        return this.replayTime;
    }

    public Integer getTimes() {
        return this.times;
    }

    public ScoreValue getScore() {
        return this.score;
    }

    public ScoreValue getBeforeScore() {
        return this.beforeScore;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Boolean getLightSpotShared() {
        return this.lightSpotShared;
    }

    public Boolean getProblemShared() {
        return this.problemShared;
    }

    public String getReformInfoStr() {
        return this.reformInfoStr;
    }

    public ScoreValue getReturnScore() {
        return this.returnScore;
    }

    public ScoreValue getRuleRedudence() {
        return this.ruleRedudence;
    }

    public ScoreValue getRewardScore() {
        return this.rewardScore;
    }

    public RuleOption getRuleOption() {
        return this.ruleOption;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setTask(CheckTask task) {
        this.task = task;
    }

    public void setInspectionItem(InspectionItem inspectionItem) {
        this.inspectionItem = inspectionItem;
    }

    public void setInspSubItemRecords(List<InspectionSubItemRecord> inspSubItemRecords) {
        this.inspSubItemRecords = inspSubItemRecords;
    }

    public void setImages(List<CheckSnapshotImage> images) {
        this.images = images;
    }

    public void setVideos(List<CheckSnapshotVideo> videos) {
        this.videos = videos;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(CheckTaskRecordStatusEnum status) {
        this.status = status;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public void setMoneyTimes(Integer moneyTimes) {
        this.moneyTimes = moneyTimes;
    }

    public void setExtraMark(ScoreValue extraMark) {
        this.extraMark = extraMark;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setReplayTime(Date replayTime) {
        this.replayTime = replayTime;
    }

    public void setScore(ScoreValue score) {
        this.score = score;
    }

    public void setBeforeScore(ScoreValue beforeScore) {
        this.beforeScore = beforeScore;
    }

    public void setConstraints(Constraints constraints) {
        this.constraints = constraints;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setLightSpotShared(Boolean lightSpotShared) {
        this.lightSpotShared = lightSpotShared;
    }

    public void setProblemShared(Boolean problemShared) {
        this.problemShared = problemShared;
    }

    public void setReformInfoStr(String reformInfoStr) {
        this.reformInfoStr = reformInfoStr;
    }

    public void setReturnScore(ScoreValue returnScore) {
        this.returnScore = returnScore;
    }

    public void setRuleRedudence(ScoreValue ruleRedudence) {
        this.ruleRedudence = ruleRedudence;
    }

    public void setRewardScore(ScoreValue rewardScore) {
        this.rewardScore = rewardScore;
    }

    public void setRuleOption(RuleOption ruleOption) {
        this.ruleOption = ruleOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckTaskRecord)) {
            return false;
        }
        CheckTaskRecord other = (CheckTaskRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        CheckTask this$task = this.getTask();
        CheckTask other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        InspectionItem this$inspectionItem = this.getInspectionItem();
        InspectionItem other$inspectionItem = other.getInspectionItem();
        if (this$inspectionItem == null ? other$inspectionItem != null : !((Object)this$inspectionItem).equals(other$inspectionItem)) {
            return false;
        }
        List<InspectionSubItemRecord> this$inspSubItemRecords = this.getInspSubItemRecords();
        List<InspectionSubItemRecord> other$inspSubItemRecords = other.getInspSubItemRecords();
        if (this$inspSubItemRecords == null ? other$inspSubItemRecords != null : !((Object)this$inspSubItemRecords).equals(other$inspSubItemRecords)) {
            return false;
        }
        List<CheckSnapshotImage> this$images = this.getImages();
        List<CheckSnapshotImage> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        List<CheckSnapshotVideo> this$videos = this.getVideos();
        List<CheckSnapshotVideo> other$videos = other.getVideos();
        if (this$videos == null ? other$videos != null : !((Object)this$videos).equals(other$videos)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        CheckTaskRecordStatusEnum this$status = this.getStatus();
        CheckTaskRecordStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Double this$money = this.getMoney();
        Double other$money = other.getMoney();
        if (this$money == null ? other$money != null : !((Object)this$money).equals(other$money)) {
            return false;
        }
        Integer this$moneyTimes = this.getMoneyTimes();
        Integer other$moneyTimes = other.getMoneyTimes();
        if (this$moneyTimes == null ? other$moneyTimes != null : !((Object)this$moneyTimes).equals(other$moneyTimes)) {
            return false;
        }
        ScoreValue this$extraMark = this.getExtraMark();
        ScoreValue other$extraMark = other.getExtraMark();
        if (this$extraMark == null ? other$extraMark != null : !this$extraMark.equals(other$extraMark)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$lastUpdateTime = this.getLastUpdateTime();
        Date other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        Date this$replayTime = this.getReplayTime();
        Date other$replayTime = other.getReplayTime();
        if (this$replayTime == null ? other$replayTime != null : !((Object)this$replayTime).equals(other$replayTime)) {
            return false;
        }
        Integer this$times = this.getTimes();
        Integer other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        ScoreValue this$score = this.getScore();
        ScoreValue other$score = other.getScore();
        if (this$score == null ? other$score != null : !this$score.equals(other$score)) {
            return false;
        }
        ScoreValue this$beforeScore = this.getBeforeScore();
        ScoreValue other$beforeScore = other.getBeforeScore();
        if (this$beforeScore == null ? other$beforeScore != null : !this$beforeScore.equals(other$beforeScore)) {
            return false;
        }
        Constraints this$constraints = this.getConstraints();
        Constraints other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Boolean this$lightSpotShared = this.getLightSpotShared();
        Boolean other$lightSpotShared = other.getLightSpotShared();
        if (this$lightSpotShared == null ? other$lightSpotShared != null : !((Object)this$lightSpotShared).equals(other$lightSpotShared)) {
            return false;
        }
        Boolean this$problemShared = this.getProblemShared();
        Boolean other$problemShared = other.getProblemShared();
        if (this$problemShared == null ? other$problemShared != null : !((Object)this$problemShared).equals(other$problemShared)) {
            return false;
        }
        String this$reformInfoStr = this.getReformInfoStr();
        String other$reformInfoStr = other.getReformInfoStr();
        if (this$reformInfoStr == null ? other$reformInfoStr != null : !this$reformInfoStr.equals(other$reformInfoStr)) {
            return false;
        }
        ScoreValue this$returnScore = this.getReturnScore();
        ScoreValue other$returnScore = other.getReturnScore();
        if (this$returnScore == null ? other$returnScore != null : !this$returnScore.equals(other$returnScore)) {
            return false;
        }
        ScoreValue this$ruleRedudence = this.getRuleRedudence();
        ScoreValue other$ruleRedudence = other.getRuleRedudence();
        if (this$ruleRedudence == null ? other$ruleRedudence != null : !this$ruleRedudence.equals(other$ruleRedudence)) {
            return false;
        }
        ScoreValue this$rewardScore = this.getRewardScore();
        ScoreValue other$rewardScore = other.getRewardScore();
        if (this$rewardScore == null ? other$rewardScore != null : !this$rewardScore.equals(other$rewardScore)) {
            return false;
        }
        RuleOption this$ruleOption = this.getRuleOption();
        RuleOption other$ruleOption = other.getRuleOption();
        return !(this$ruleOption == null ? other$ruleOption != null : !((Object)this$ruleOption).equals(other$ruleOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckTaskRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        CheckTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        InspectionItem $inspectionItem = this.getInspectionItem();
        result = result * 59 + ($inspectionItem == null ? 43 : ((Object)$inspectionItem).hashCode());
        List<InspectionSubItemRecord> $inspSubItemRecords = this.getInspSubItemRecords();
        result = result * 59 + ($inspSubItemRecords == null ? 43 : ((Object)$inspSubItemRecords).hashCode());
        List<CheckSnapshotImage> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        List<CheckSnapshotVideo> $videos = this.getVideos();
        result = result * 59 + ($videos == null ? 43 : ((Object)$videos).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        CheckTaskRecordStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Double $money = this.getMoney();
        result = result * 59 + ($money == null ? 43 : ((Object)$money).hashCode());
        Integer $moneyTimes = this.getMoneyTimes();
        result = result * 59 + ($moneyTimes == null ? 43 : ((Object)$moneyTimes).hashCode());
        ScoreValue $extraMark = this.getExtraMark();
        result = result * 59 + ($extraMark == null ? 43 : $extraMark.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        Date $replayTime = this.getReplayTime();
        result = result * 59 + ($replayTime == null ? 43 : ((Object)$replayTime).hashCode());
        Integer $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        ScoreValue $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : $score.hashCode());
        ScoreValue $beforeScore = this.getBeforeScore();
        result = result * 59 + ($beforeScore == null ? 43 : $beforeScore.hashCode());
        Constraints $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Boolean $lightSpotShared = this.getLightSpotShared();
        result = result * 59 + ($lightSpotShared == null ? 43 : ((Object)$lightSpotShared).hashCode());
        Boolean $problemShared = this.getProblemShared();
        result = result * 59 + ($problemShared == null ? 43 : ((Object)$problemShared).hashCode());
        String $reformInfoStr = this.getReformInfoStr();
        result = result * 59 + ($reformInfoStr == null ? 43 : $reformInfoStr.hashCode());
        ScoreValue $returnScore = this.getReturnScore();
        result = result * 59 + ($returnScore == null ? 43 : $returnScore.hashCode());
        ScoreValue $ruleRedudence = this.getRuleRedudence();
        result = result * 59 + ($ruleRedudence == null ? 43 : $ruleRedudence.hashCode());
        ScoreValue $rewardScore = this.getRewardScore();
        result = result * 59 + ($rewardScore == null ? 43 : $rewardScore.hashCode());
        RuleOption $ruleOption = this.getRuleOption();
        result = result * 59 + ($ruleOption == null ? 43 : ((Object)$ruleOption).hashCode());
        return result;
    }

    public CheckTaskRecord(Integer id, CheckTask task, InspectionItem inspectionItem, List<InspectionSubItemRecord> inspSubItemRecords, List<CheckSnapshotImage> images, List<CheckSnapshotVideo> videos, String description, CheckTaskRecordStatusEnum status, Double money, Integer moneyTimes, ScoreValue extraMark, Date createTime, Date lastUpdateTime, Date replayTime, Integer times, ScoreValue score, ScoreValue beforeScore, Constraints constraints, Integer version, Boolean lightSpotShared, Boolean problemShared, String reformInfoStr, ScoreValue returnScore, ScoreValue ruleRedudence, ScoreValue rewardScore, RuleOption ruleOption) {
        this.id = id;
        this.task = task;
        this.inspectionItem = inspectionItem;
        this.inspSubItemRecords = inspSubItemRecords;
        this.images = images;
        this.videos = videos;
        this.description = description;
        this.status = status;
        this.money = money;
        this.moneyTimes = moneyTimes;
        this.extraMark = extraMark;
        this.createTime = createTime;
        this.lastUpdateTime = lastUpdateTime;
        this.replayTime = replayTime;
        this.times = times;
        this.score = score;
        this.beforeScore = beforeScore;
        this.constraints = constraints;
        this.version = version;
        this.lightSpotShared = lightSpotShared;
        this.problemShared = problemShared;
        this.reformInfoStr = reformInfoStr;
        this.returnScore = returnScore;
        this.ruleRedudence = ruleRedudence;
        this.rewardScore = rewardScore;
        this.ruleOption = ruleOption;
    }

    public CheckTaskRecord() {
    }
}

