/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator.rule;

import com.ovopark.check.core.Score;
import com.ovopark.check.core.calculator.Action;
import com.ovopark.check.core.calculator.InspectionItem;
import com.ovopark.check.core.calculator.InspectionRecord;
import com.ovopark.check.core.calculator.rule.CustomRule;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiCustomRule
extends CustomRule {
    private final List<InspectionItem> inspectionItems;
    private List<InspectionRecord> records;
    private final List<Action> actions;

    public MultiCustomRule(List<InspectionItem> inspectionItems, List<Action> actions) {
        this.inspectionItems = inspectionItems;
        this.actions = actions;
    }

    @Override
    public void matchAndKeep(List<InspectionRecord> records) {
        List inspectionIds = this.inspectionItems.stream().map(InspectionItem::getId).collect(Collectors.toList());
        this.records = records.stream().filter(e -> inspectionIds.contains(e.getInspectionItem().getId())).collect(Collectors.toList());
    }

    @Override
    public boolean hasInsp(Integer inspId) {
        return this.inspectionItems.stream().map(InspectionItem::getId).collect(Collectors.toList()).contains(inspId);
    }

    @Override
    public List<Score> getScore() {
        int unqualifiedNum = (int)this.records.stream().filter(InspectionRecord::isUnqualified).count();
        if (unqualifiedNum > 0) {
            Action action = this.actions.get(unqualifiedNum - 1);
            if (this.group.getId() > 0) {
                action.accept(this.group, this.records);
            } else {
                Map<Integer, List<InspectionItem>> unqualifiedGrouped = this.records.stream().filter(InspectionRecord::isUnqualified).map(InspectionRecord::getInspectionItem).collect(Collectors.groupingBy(InspectionItem::getGroupId));
                Map<Integer, Integer> groupWeight = unqualifiedGrouped.values().stream().collect(Collectors.toMap(l -> ((InspectionItem)l.get(0)).getGroupId(), List::size));
                action.accept(this.group.getCustomScoreCalculator(), groupWeight);
            }
        }
        return this.records.stream().map(e -> new Score().setId(e.getInspectionItem().getId()).setScore(e.getScore()).setTotalScore(e.getTotalScore()).setReturnScore(e.getReturnScore()).setLevel(Score.Level.INSP_ITEM)).collect(Collectors.toList());
    }

    @Override
    public Set<Integer> allRuleSet() {
        return this.actions.stream().map(Action::getType).collect(Collectors.toSet());
    }
}

